/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.Iterator;
import java.util.List;
import ome.model.annotations.Annotation;
import ome.model.annotations.CommentAnnotation;
import ome.model.meta.Session;
import ome.security.ACLVoter;
import ome.security.EventProvider;
import ome.security.SecurityFilter;
import ome.security.SystemTypes;
import ome.security.basic.BasicSecuritySystem;
import ome.security.basic.CurrentDetails;
import ome.security.basic.OmeroInterceptor;
import ome.security.basic.TokenHolder;
import ome.security.policy.PolicyService;
import ome.services.sessions.SessionManager;
import ome.services.sessions.SessionProvider;
import ome.system.Roles;
import ome.system.ServiceFactory;

public class BasicSecuritySystemReadOnly
extends BasicSecuritySystem {
    public BasicSecuritySystemReadOnly(OmeroInterceptor interceptor, SystemTypes sysTypes, CurrentDetails cd, SessionManager sessionManager, SessionProvider sessionProvider, EventProvider eventProvider, Roles roles, ServiceFactory sf, TokenHolder tokenHolder, List<SecurityFilter> filters, PolicyService policyService, ACLVoter aclVoter) {
        super(interceptor, sysTypes, cd, sessionManager, sessionProvider, eventProvider, roles, sf, tokenHolder, filters, policyService, aclVoter);
    }

    @Override
    protected boolean isGroupContextPermitted(long sessionId, long groupId) {
        Session session = this.sessionProvider.findSessionById(sessionId, this.sf);
        Iterator sessionAnnotations = session.linkedAnnotationIterator();
        while (sessionAnnotations.hasNext()) {
            Annotation sessionAnnotation = (Annotation)sessionAnnotations.next();
            if (!(sessionAnnotation instanceof CommentAnnotation) || !"openmicroscopy.org/security/group-sudo".equals(sessionAnnotation.getNs()) || !this.roles.isRootUser(sessionAnnotation.getDetails().getOwner()) || this.isGroupContextPermitted(groupId, ((CommentAnnotation)sessionAnnotation).getTextValue())) continue;
            return false;
        }
        return true;
    }
}

