/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext.bridges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ome.io.nio.OriginalFilesService;
import ome.model.IAnnotated;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.FileAnnotation;
import ome.model.containers.Dataset;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.screen.Plate;
import ome.model.screen.Well;
import ome.model.screen.WellSample;
import ome.services.fulltext.BridgeHelper;
import ome.system.OmeroContext;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.springframework.context.ApplicationEventPublisher;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Index;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;

@Deprecated
public class TablesBridge
extends BridgeHelper {
    public final String OMERO_TABLE = "OMERO.tables";
    OriginalFilesService ofs;

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        super.setApplicationEventPublisher(publisher);
        if (publisher instanceof OmeroContext) {
            OmeroContext ctx = (OmeroContext)publisher;
            this.ofs = (OriginalFilesService)ctx.getBean("/OMERO/Files", OriginalFilesService.class);
        } else {
            this.log.warn("Publisher is " + publisher.getClass().getName());
            this.log.warn("Cannot configure TablesBridge properly!");
        }
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions opts) {
        if (value instanceof Image) {
            this.handleImage((Image)value, document, opts);
        } else if (value instanceof Plate) {
            this.handleAnnotated((IAnnotated)((Plate)value), document, opts);
        } else if (value instanceof Dataset) {
            this.handleAnnotated((IAnnotated)((Dataset)value), document, opts);
        }
    }

    protected void handleImage(Image image, Document document, LuceneOptions opts) {
        Iterator it = image.iterateWellSamples();
        while (it.hasNext()) {
            WellSample ws = (WellSample)it.next();
            Well well = ws.getWell();
            Plate plate = well.getPlate();
            for (Annotation a : plate.linkedAnnotationList()) {
                this.handleAnnotation(a, new AttachRow((IObject)image, document, opts));
            }
        }
        for (Dataset ds : image.linkedDatasetList()) {
            for (Annotation a : ds.linkedAnnotationList()) {
                this.handleAnnotation(a, new AttachRow((IObject)image, document, opts));
            }
        }
    }

    protected void handleAnnotated(IAnnotated annotated, Document document, LuceneOptions opts) {
        for (Annotation a : annotated.linkedAnnotationList()) {
            this.handleAnnotation(a, new RegisterRow());
        }
    }

    protected void handleAnnotation(Annotation annotation, RowProcessor proc) {
        if ((annotation = TablesBridge.getProxiedObject(annotation)) instanceof FileAnnotation) {
            OriginalFile file = ((FileAnnotation)annotation).getFile();
            String mimetype = file.getMimetype();
            String path = this.ofs.getFilesPath(file.getId());
            if ("OMERO.tables".equals(mimetype)) {
                this.debug("Handling annotation %s", annotation);
                this.handleHdf5(path, proc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHdf5(String path, RowProcessor proc) {
        NetcdfFile ncfile = null;
        try {
            ncfile = NetcdfFile.open((String)path);
            Table table = new Table(ncfile);
            if (!proc.initialize(table)) {
                this.debug("Skipping %s", path);
                return;
            }
            this.debug("Handling %s with %s rows", path, table.rows);
            StructureData sData = null;
            int x = 0;
            while ((long)x < table.rows) {
                sData = (StructureData)table.structure.getObject(x);
                if (!proc.processRow(x, sData)) {
                    break;
                }
                ++x;
            }
        }
        catch (IOException ioe) {
            this.log.error("trying to open " + path, (Throwable)ioe);
        }
        finally {
            if (null != ncfile) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    this.log.error("trying to close " + path, (Throwable)ioe);
                }
            }
        }
    }

    private void debug(String format, Object ... vals) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(format, vals));
        }
    }

    private void trace(String format, Object ... vals) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format(format, vals));
        }
    }

    private class Table {
        public static final String COLUMN_BASE = "::omero::grid::";
        public static final String IMAGE_COL = "::omero::grid::ImageColumn";
        public static final String WELL_COL = "::omero::grid::WellColumn";
        public static final String PLATE_COL = "::omero::grid::PlateColumn";
        private final NetcdfFile f;
        final ArrayStructure structure;
        final long rows;
        final List<String> types;

        Table(NetcdfFile f) throws IOException {
            this.f = f;
            this.structure = this.structure();
            this.rows = this.structure.getSize();
            this.types = this.getColTypes();
            TablesBridge.this.trace("Column types: %s", new Object[]{this.types});
        }

        public IObject getObjectForColumn(int targetCol) {
            String type = this.types.get(targetCol);
            if (type.startsWith(IMAGE_COL)) {
                return new Image();
            }
            if (type.startsWith(WELL_COL)) {
                return new Well();
            }
            if (type.startsWith(PLATE_COL)) {
                return new Plate();
            }
            throw new RuntimeException("Unsupported type:" + type);
        }

        public int getFinestColumn() {
            ArrayList<Integer> plates = new ArrayList<Integer>();
            ArrayList<Integer> wells = new ArrayList<Integer>();
            ArrayList<Integer> images = new ArrayList<Integer>();
            for (int i = 0; i < this.types.size(); ++i) {
                String type = this.types.get(i);
                if (type.startsWith(IMAGE_COL)) {
                    images.add(i);
                    continue;
                }
                if (type.startsWith(WELL_COL)) {
                    wells.add(i);
                    continue;
                }
                if (!type.startsWith(PLATE_COL)) continue;
                plates.add(i);
            }
            if (images.size() == 1) {
                return (Integer)images.get(0);
            }
            if (images.size() > 1) {
                TablesBridge.this.log.warn("Multiple image columns found.");
                return -1;
            }
            if (wells.size() == 1) {
                return (Integer)wells.get(0);
            }
            if (wells.size() > 1) {
                TablesBridge.this.log.warn("Multiple well columns found.");
                return -2;
            }
            if (plates.size() == 1) {
                return (Integer)plates.get(0);
            }
            if (plates.size() > 1) {
                TablesBridge.this.log.warn("Multiple plate columns found.");
                return -3;
            }
            return -4;
        }

        private ArrayStructure structure() throws IOException {
            return (ArrayStructure)this.f.findVariable("/OME/Measurements").read();
        }

        private List<String> getColTypes() throws IOException {
            ArrayChar typeArray = (ArrayChar)this.f.findVariable("/OME/ColumnTypes").read();
            char[][] obj = (char[][])typeArray.copyToNDJavaArray();
            ArrayList<String> types = new ArrayList<String>();
            for (int i = 0; i < obj.length; ++i) {
                types.add(new String(obj[i]));
            }
            return types;
        }
    }

    class RegisterRow
    extends RowProcessor {
        RegisterRow() {
        }

        @Override
        public boolean processRow(int row, StructureData sData) {
            List members = sData.getMembers();
            Array targetArray = sData.getArray((StructureMembers.Member)members.get(this.targetCol));
            long targetId = this.getLong(targetArray);
            this.targetType.setId(Long.valueOf(targetId));
            TablesBridge.this.reindex(this.targetType);
            return true;
        }
    }

    class AttachRow
    extends RowProcessor {
        final IObject object;
        final Document document;
        final LuceneOptions opts;

        AttachRow(IObject object, Document document, LuceneOptions opts) {
            this.object = object;
            this.document = document;
            this.opts = opts;
        }

        @Override
        public boolean processRow(int row, StructureData sData) {
            List members = sData.getMembers();
            Array targetArray = sData.getArray((StructureMembers.Member)members.get(this.targetCol));
            long targetId = this.getLong(targetArray);
            if (targetId != this.object.getId()) {
                return true;
            }
            for (int i = 0; i < members.size(); ++i) {
                if (i == this.targetCol) continue;
                StructureMembers.Member member = (StructureMembers.Member)members.get(i);
                String name = member.getName();
                Array array = sData.getArray(member);
                String str = this.getObject(array).toString();
                TablesBridge.this.trace("Add %s:%s to %s", new Object[]{name, str, this.object});
                TablesBridge.this.add(this.document, name, str, this.opts);
            }
            return true;
        }
    }

    abstract class RowProcessor {
        int targetCol;
        IObject targetType;

        RowProcessor() {
        }

        public boolean initialize(Table table) {
            this.targetCol = table.getFinestColumn();
            if (this.targetCol < 0) {
                TablesBridge.this.log.info("No column found.");
                return false;
            }
            this.targetType = table.getObjectForColumn(this.targetCol);
            return true;
        }

        public abstract boolean processRow(int var1, StructureData var2);

        protected long getLong(Array array) {
            Index index = array.getIndex();
            index.set(0);
            long targetId = array.getLong(index);
            return targetId;
        }

        protected Object getObject(Array array) {
            Index index = array.getIndex();
            index.set(0);
            return array.getObject(index);
        }
    }
}

