/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.conditions.InternalException;
import ome.system.OmeroContext;
import ome.system.SelfConfigurableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanHelper {
    private transient Class beanClass;
    private transient Logger logger;
    private transient OmeroContext applicationContext;

    public BeanHelper(Class implementationClass) {
        this.beanClass = implementationClass;
        this.logger = LoggerFactory.getLogger((Class)this.beanClass);
    }

    public final void acquireContext() {
        if (this.applicationContext == null) {
            this.applicationContext = OmeroContext.getManagedServerContext();
        }
    }

    public final void configure(SelfConfigurableService bean) {
        this.acquireContext();
        this.applicationContext.applyBeanPropertyValues((Object)bean, bean.getServiceInterface());
        if (bean instanceof ApplicationContextAware) {
            ApplicationContextAware aca = (ApplicationContextAware)bean;
            aca.setApplicationContext((ApplicationContext)this.applicationContext);
        }
    }

    public void throwIfAlreadySet(Object current, Object injected) {
        if (current != null) {
            throw new InternalException(String.format("%s already configured with %s cannot set inject %s.", this.getClass().getName(), current, injected));
        }
    }

    public void passivationNotAllowed() {
        throw new InternalException(String.format("Passivation should have been disabled for this Stateful Session Beans (%s).\nPlease contact the Omero development team for how to ensure that passivation\nis disabled on your application server.", this.getClass().getName()));
    }

    public Exception translateException(Throwable t) {
        if (Exception.class.isAssignableFrom(t.getClass())) {
            return (Exception)t;
        }
        InternalException ie = new InternalException(t.getMessage());
        ie.setStackTrace(t.getStackTrace());
        return ie;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getLogString(SelfConfigurableService bean) {
        StringBuilder sb = new StringBuilder();
        sb.append("Bean ");
        sb.append(bean);
        sb.append("\n with Context ");
        sb.append(this.applicationContext);
        return sb.toString();
    }
}

