/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import Ice.ObjectNotExistException;
import java.util.ArrayList;
import java.util.List;
import ome.formats.OMEROMetadataStoreClient;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.cmd.HandlePrx;
import omero.cmd.Response;
import omero.grid.ImportProcessPrx;
import omero.grid.ImportProcessPrxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCloser {
    private static final Logger log = LoggerFactory.getLogger(ImportCloser.class);
    List<ImportProcessPrx> imports;
    int closed = 0;
    int errors = 0;
    int processed = 0;

    ImportCloser(OMEROMetadataStoreClient client2) throws Exception {
        this.imports = ImportCloser.getImports(client2);
    }

    void closeCompleted() {
        for (ImportProcessPrx imPrx : this.imports) {
            try {
                Response rsp;
                ++this.processed;
                String logName = imPrx.toString().split("\\s")[0];
                HandlePrx handle = imPrx.getHandle();
                if (handle != null && (rsp = handle.getResponse()) != null) {
                    log.info("Done: {}", (Object)logName);
                    imPrx.close();
                    ++this.closed;
                    continue;
                }
                log.info("Running: {}", (Object)logName);
            }
            catch (Exception e) {
                ++this.errors;
                log.warn("Failure accessing service", (Throwable)e);
            }
        }
    }

    int getClosed() {
        return this.closed;
    }

    int getErrors() {
        return this.errors;
    }

    int getProcessed() {
        return this.processed;
    }

    private static List<ImportProcessPrx> getImports(OMEROMetadataStoreClient client2) throws Exception {
        ArrayList<ImportProcessPrx> rv = new ArrayList<ImportProcessPrx>();
        ServiceFactoryPrx sf = client2.getServiceFactory();
        List<String> active = sf.activeServices();
        for (String service : active) {
            try {
                ServiceInterfacePrx prx = sf.getByName(service);
                ImportProcessPrx imPrx = ImportProcessPrxHelper.checkedCast(prx);
                if (imPrx == null) continue;
                try {
                    imPrx.ice_ping();
                    rv.add(imPrx);
                }
                catch (ObjectNotExistException objectNotExistException) {
                }
            }
            catch (Exception e) {
                log.warn("Failure accessing active service", (Throwable)e);
            }
        }
        return rv;
    }
}

