/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.NGramDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.search.DateValueSourceParser;
import org.apache.solr.search.Double2Parser;
import org.apache.solr.search.DoubleParser;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.NamedParser;
import org.apache.solr.search.function.BoostedQuery;
import org.apache.solr.search.function.DivFloatFunction;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.DoubleConstValueSource;
import org.apache.solr.search.function.DualFloatFunction;
import org.apache.solr.search.function.LinearFloatFunction;
import org.apache.solr.search.function.LiteralValueSource;
import org.apache.solr.search.function.MaxFloatFunction;
import org.apache.solr.search.function.MultiValueSource;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.ProductFloatFunction;
import org.apache.solr.search.function.QueryValueSource;
import org.apache.solr.search.function.RangeMapFloatFunction;
import org.apache.solr.search.function.ReciprocalFloatFunction;
import org.apache.solr.search.function.ReverseOrdFieldSource;
import org.apache.solr.search.function.ScaleFloatFunction;
import org.apache.solr.search.function.SimpleFloatFunction;
import org.apache.solr.search.function.SumFloatFunction;
import org.apache.solr.search.function.TopValueSource;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.search.function.VectorValueSource;
import org.apache.solr.search.function.distance.GeohashFunction;
import org.apache.solr.search.function.distance.GeohashHaversineFunction;
import org.apache.solr.search.function.distance.HaversineConstFunction;
import org.apache.solr.search.function.distance.HaversineFunction;
import org.apache.solr.search.function.distance.SquaredEuclideanFunction;
import org.apache.solr.search.function.distance.StringDistanceFunction;
import org.apache.solr.search.function.distance.VectorDistanceFunction;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueSourceParser
implements NamedListInitializedPlugin {
    public static Map<String, ValueSourceParser> standardValueSourceParsers = new HashMap<String, ValueSourceParser>();

    @Override
    public void init(NamedList args) {
    }

    public abstract ValueSource parse(FunctionQParser var1) throws ParseException;

    public static ValueSourceParser addParser(String name, ValueSourceParser p) {
        return standardValueSourceParsers.put(name, p);
    }

    public static ValueSourceParser addParser(NamedParser p) {
        return standardValueSourceParsers.put(p.name(), p);
    }

    private static void alias(String source, String dest) {
        standardValueSourceParsers.put(dest, standardValueSourceParsers.get(source));
    }

    private static void splitSources(int dim, List<ValueSource> sources, List<ValueSource> dest1, List<ValueSource> dest2) {
        int i;
        for (i = 0; i < dim; ++i) {
            dest1.add(sources.get(i));
        }
        for (i = dim; i < sources.size(); ++i) {
            dest2.add(sources.get(i));
        }
    }

    private static MVResult getMultiValueSources(List<ValueSource> sources) {
        MVResult mvr = new MVResult();
        if (sources.size() % 2 != 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal number of sources.  There must be an even number of sources");
        }
        if (sources.size() == 2) {
            boolean s1MV = sources.get(0) instanceof MultiValueSource;
            boolean s2MV = sources.get(1) instanceof MultiValueSource;
            if (s1MV && s2MV) {
                mvr.mv1 = (MultiValueSource)sources.get(0);
                mvr.mv2 = (MultiValueSource)sources.get(1);
            } else {
                if (s1MV || s2MV) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal number of sources.  There must be an even number of sources");
                }
                mvr.mv1 = new VectorValueSource(Collections.singletonList(sources.get(0)));
                mvr.mv2 = new VectorValueSource(Collections.singletonList(sources.get(1)));
            }
        } else {
            int dim = sources.size() / 2;
            ArrayList<ValueSource> sources1 = new ArrayList<ValueSource>(dim);
            ArrayList<ValueSource> sources2 = new ArrayList<ValueSource>(dim);
            ValueSourceParser.splitSources(dim, sources, sources1, sources2);
            mvr.mv1 = new VectorValueSource(sources1);
            mvr.mv2 = new VectorValueSource(sources2);
        }
        return mvr;
    }

    static {
        ValueSourceParser.addParser("ord", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                String field = fp.parseId();
                return new TopValueSource(new OrdFieldSource(field));
            }
        });
        ValueSourceParser.addParser("literal", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                return new LiteralValueSource(fp.getString());
            }
        });
        ValueSourceParser.addParser("rord", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                String field = fp.parseId();
                return new TopValueSource(new ReverseOrdFieldSource(field));
            }
        });
        ValueSourceParser.addParser("top", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                if (source instanceof TopValueSource) {
                    return source;
                }
                return new TopValueSource(source);
            }
        });
        ValueSourceParser.addParser("linear", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float slope = fp.parseFloat().floatValue();
                float intercept = fp.parseFloat().floatValue();
                return new LinearFloatFunction(source, slope, intercept);
            }
        });
        ValueSourceParser.addParser("max", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float val = fp.parseFloat().floatValue();
                return new MaxFloatFunction(source, val);
            }
        });
        ValueSourceParser.addParser("recip", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float m = fp.parseFloat().floatValue();
                float a = fp.parseFloat().floatValue();
                float b = fp.parseFloat().floatValue();
                return new ReciprocalFloatFunction(source, m, a, b);
            }
        });
        ValueSourceParser.addParser("scale", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float min = fp.parseFloat().floatValue();
                float max = fp.parseFloat().floatValue();
                return new TopValueSource(new ScaleFloatFunction(source, min, max));
            }
        });
        ValueSourceParser.addParser("div", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DivFloatFunction(a, b);
            }
        });
        ValueSourceParser.addParser("map", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                float min = fp.parseFloat().floatValue();
                float max = fp.parseFloat().floatValue();
                float target = fp.parseFloat().floatValue();
                Float def = fp.hasMoreArguments() ? fp.parseFloat() : null;
                return new RangeMapFloatFunction(source, min, max, target, def);
            }
        });
        ValueSourceParser.addParser("abs", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource source = fp.parseValueSource();
                return new SimpleFloatFunction(source){

                    protected String name() {
                        return "abs";
                    }

                    protected float func(int doc, DocValues vals) {
                        return Math.abs(vals.floatVal(doc));
                    }
                };
            }
        });
        ValueSourceParser.addParser("sum", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new SumFloatFunction(sources.toArray(new ValueSource[sources.size()]));
            }
        });
        ValueSourceParser.alias("sum", "add");
        ValueSourceParser.addParser("product", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                List<ValueSource> sources = fp.parseValueSourceList();
                return new ProductFloatFunction(sources.toArray(new ValueSource[sources.size()]));
            }
        });
        ValueSourceParser.alias("product", "mul");
        ValueSourceParser.addParser("sub", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource a = fp.parseValueSource();
                ValueSource b = fp.parseValueSource();
                return new DualFloatFunction(a, b){

                    protected String name() {
                        return "sub";
                    }

                    protected float func(int doc, DocValues aVals, DocValues bVals) {
                        return aVals.floatVal(doc) - bVals.floatVal(doc);
                    }
                };
            }
        });
        ValueSourceParser.addParser("vector", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                return new VectorValueSource(fp.parseValueSourceList());
            }
        });
        ValueSourceParser.addParser("query", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                Query q = fp.parseNestedQuery();
                float defVal = 0.0f;
                if (fp.hasMoreArguments()) {
                    defVal = fp.parseFloat().floatValue();
                }
                return new QueryValueSource(q, defVal);
            }
        });
        ValueSourceParser.addParser("boost", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                Query q = fp.parseNestedQuery();
                ValueSource vs = fp.parseValueSource();
                BoostedQuery bq = new BoostedQuery(q, vs);
                return new QueryValueSource(bq, 0.0f);
            }
        });
        ValueSourceParser.addParser("geodist", HaversineConstFunction.parser);
        ValueSourceParser.addParser("hsin", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                MultiValueSource pv2;
                MultiValueSource pv1;
                double radius = fp.parseDouble();
                boolean convert = Boolean.parseBoolean(fp.parseArg());
                ValueSource one = fp.parseValueSource();
                ValueSource two = fp.parseValueSource();
                if (fp.hasMoreArguments()) {
                    ArrayList<ValueSource> s1 = new ArrayList<ValueSource>();
                    s1.add(one);
                    s1.add(two);
                    pv1 = new VectorValueSource(s1);
                    ValueSource x2 = fp.parseValueSource();
                    ValueSource y2 = fp.parseValueSource();
                    ArrayList<ValueSource> s2 = new ArrayList<ValueSource>();
                    s2.add(x2);
                    s2.add(y2);
                    pv2 = new VectorValueSource(s2);
                } else if (one instanceof MultiValueSource && two instanceof MultiValueSource) {
                    pv1 = (MultiValueSource)one;
                    pv2 = (MultiValueSource)two;
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Input must either be 2 MultiValueSources, or there must be 4 ValueSources");
                }
                return new HaversineFunction(pv1, pv2, radius, convert);
            }
        });
        ValueSourceParser.addParser("ghhsin", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                double radius = fp.parseDouble();
                ValueSource gh1 = fp.parseValueSource();
                ValueSource gh2 = fp.parseValueSource();
                return new GeohashHaversineFunction(gh1, gh2, radius);
            }
        });
        ValueSourceParser.addParser("geohash", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource lat = fp.parseValueSource();
                ValueSource lon = fp.parseValueSource();
                return new GeohashFunction(lat, lon);
            }
        });
        ValueSourceParser.addParser("strdist", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                ValueSource str1 = fp.parseValueSource();
                ValueSource str2 = fp.parseValueSource();
                String distClass = fp.parseArg();
                JaroWinklerDistance dist = null;
                if (distClass.equalsIgnoreCase("jw")) {
                    dist = new JaroWinklerDistance();
                } else if (distClass.equalsIgnoreCase("edit")) {
                    dist = new LevensteinDistance();
                } else if (distClass.equalsIgnoreCase("ngram")) {
                    int ngram = 2;
                    if (fp.hasMoreArguments()) {
                        ngram = fp.parseInt();
                    }
                    dist = new NGramDistance(ngram);
                } else {
                    dist = (StringDistance)fp.req.getCore().getResourceLoader().newInstance(distClass, new String[0]);
                }
                return new StringDistanceFunction(str1, str2, (StringDistance)dist);
            }
        });
        ValueSourceParser.addParser(new DoubleParser("rad"){

            public double func(int doc, DocValues vals) {
                return vals.doubleVal(doc) * (Math.PI / 180);
            }
        });
        ValueSourceParser.addParser(new DoubleParser("deg"){

            public double func(int doc, DocValues vals) {
                return vals.doubleVal(doc) * 57.29577951308232;
            }
        });
        ValueSourceParser.addParser(new DoubleParser("sqrt"){

            public double func(int doc, DocValues vals) {
                return Math.sqrt(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("cbrt"){

            public double func(int doc, DocValues vals) {
                return Math.cbrt(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("log"){

            public double func(int doc, DocValues vals) {
                return Math.log10(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("ln"){

            public double func(int doc, DocValues vals) {
                return Math.log(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("exp"){

            public double func(int doc, DocValues vals) {
                return Math.exp(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("sin"){

            public double func(int doc, DocValues vals) {
                return Math.sin(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("cos"){

            public double func(int doc, DocValues vals) {
                return Math.cos(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("tan"){

            public double func(int doc, DocValues vals) {
                return Math.tan(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("asin"){

            public double func(int doc, DocValues vals) {
                return Math.asin(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("acos"){

            public double func(int doc, DocValues vals) {
                return Math.acos(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("atan"){

            public double func(int doc, DocValues vals) {
                return Math.atan(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("sinh"){

            public double func(int doc, DocValues vals) {
                return Math.sinh(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("cosh"){

            public double func(int doc, DocValues vals) {
                return Math.cosh(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("tanh"){

            public double func(int doc, DocValues vals) {
                return Math.tanh(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("ceil"){

            public double func(int doc, DocValues vals) {
                return Math.ceil(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("floor"){

            public double func(int doc, DocValues vals) {
                return Math.floor(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new DoubleParser("rint"){

            public double func(int doc, DocValues vals) {
                return Math.rint(vals.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new Double2Parser("pow"){

            public double func(int doc, DocValues a, DocValues b) {
                return Math.pow(a.doubleVal(doc), b.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new Double2Parser("hypot"){

            public double func(int doc, DocValues a, DocValues b) {
                return Math.hypot(a.doubleVal(doc), b.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser(new Double2Parser("atan2"){

            public double func(int doc, DocValues a, DocValues b) {
                return Math.atan2(a.doubleVal(doc), b.doubleVal(doc));
            }
        });
        ValueSourceParser.addParser("sqedist", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                List<ValueSource> sources = fp.parseValueSourceList();
                MVResult mvr = ValueSourceParser.getMultiValueSources(sources);
                return new SquaredEuclideanFunction(mvr.mv1, mvr.mv2);
            }
        });
        ValueSourceParser.addParser("dist", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                float power = fp.parseFloat().floatValue();
                List<ValueSource> sources = fp.parseValueSourceList();
                MVResult mvr = ValueSourceParser.getMultiValueSources(sources);
                return new VectorDistanceFunction(power, mvr.mv1, mvr.mv2);
            }
        });
        ValueSourceParser.addParser("ms", new DateValueSourceParser());
        ValueSourceParser.addParser("pi", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                return new DoubleConstValueSource(Math.PI);
            }
        });
        ValueSourceParser.addParser("e", new ValueSourceParser(){

            public ValueSource parse(FunctionQParser fp) throws ParseException {
                return new DoubleConstValueSource(Math.E);
            }
        });
    }

    private static class MVResult {
        MultiValueSource mv1;
        MultiValueSource mv2;

        private MVResult() {
        }
    }
}

