/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.search.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static final Logger log = LoggerFactory.make();
    private FSDirectory directory;
    private String indexName;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        boolean manual = context.getIndexingStrategy().equals("manual");
        File indexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, !manual);
        try {
            this.indexName = indexDir.getCanonicalPath();
            this.directory = DirectoryProviderHelper.createFSIndex(indexDir, properties);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        try {
            this.directory.close();
        }
        catch (Exception e) {
            log.error("Unable to properly close Lucene directory {}" + this.directory.getDirectory(), (Throwable)e);
        }
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }
}

