/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.datagen;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.tool.datagen.DateGenerator;
import org.hibernate.tool.datagen.EntityGenerator;
import org.hibernate.tool.datagen.Generator;
import org.hibernate.tool.datagen.NumberGenerator;
import org.hibernate.tool.datagen.StringGenerator;
import org.hibernate.tool.datagen.ValueGenerator;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public class HibernateEntityGenerator
implements EntityGenerator {
    String targetEntity;
    private Map generators = new HashMap();
    private int level;

    public void setTargetEntity(Class target) {
        this.setTargetEntity(target.getName());
    }

    public void setTargetEntity(String target) {
        this.targetEntity = target;
    }

    public void setValueGenerator(String propertyName, ValueGenerator generator) {
        this.generators.put(propertyName, generator);
    }

    public Object generate(SessionFactory sf) {
        ClassMetadata classMetadata = sf.getClassMetadata(this.getTargetEntity());
        Object targetObject = classMetadata.instantiate(null, EntityMode.POJO);
        this.populate(classMetadata, targetObject, sf);
        return targetObject;
    }

    public void populate(ClassMetadata metadata, Object targetObject, SessionFactory sf) {
        String[] propertyNames = metadata.getPropertyNames();
        Type[] propertyTypes = metadata.getPropertyTypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            Type type = propertyTypes[i];
            Generator generator = this.getGenerator(propertyNames[i], type, (SessionFactoryImplementor)sf);
            if (generator != null) {
                metadata.setPropertyValue(targetObject, propertyNames[i], generator.generate(sf), EntityMode.POJO);
                continue;
            }
            metadata.setPropertyValue(targetObject, propertyNames[i], null, EntityMode.POJO);
        }
    }

    private Generator getGenerator(String propertyName, Type type, SessionFactoryImplementor factory) {
        ValueGenerator generator = (ValueGenerator)this.generators.get(propertyName);
        if (generator == null) {
            if (Number.class.isAssignableFrom(type.getReturnedClass())) {
                generator = new NumberGenerator().setReturnedType(type.getReturnedClass());
            } else if (type == Hibernate.STRING) {
                generator = new StringGenerator();
            } else if (type == Hibernate.DATE) {
                generator = new DateGenerator();
            } else {
                if (type.isAssociationType()) {
                    if (this.getLevel() < 10) {
                        AssociationType associationType = (AssociationType)type;
                        String associatedEntityName = associationType.getAssociatedEntityName(factory);
                        HibernateEntityGenerator generator2 = new HibernateEntityGenerator();
                        generator2.setLevel(this.getLevel() + 1);
                        generator2.setTargetEntity(associatedEntityName);
                        return generator2;
                    }
                    return null;
                }
                throw new IllegalStateException("No generator available for " + propertyName + " of type " + type);
            }
            this.generators.put(propertyName, generator);
        }
        return generator;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    private int getLevel() {
        return this.level;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }
}

