/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTool
extends AbstractTool {
    private static final int ANCHOR_WIDTH = 6;
    private Map<AttributeKey, Object> prototypeAttributes;
    private Connector startConnector;
    private Connector endConnector;
    protected ConnectionFigure createdFigure;
    protected ConnectionFigure prototype;
    protected Figure targetFigure;
    protected Collection<Connector> connectors = Collections.emptyList();
    private String presentationName;

    public ConnectionTool(ConnectionFigure prototype) {
        this(prototype, null, null);
    }

    public ConnectionTool(ConnectionFigure prototype, Map<AttributeKey, Object> attributes) {
        this(prototype, attributes, null);
    }

    public ConnectionTool(ConnectionFigure prototype, Map<AttributeKey, Object> attributes, String presentationName) {
        this.prototype = prototype;
        this.prototypeAttributes = attributes;
        if (presentationName == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            presentationName = labels.getString("createConnectionFigure");
        }
        this.presentationName = presentationName;
    }

    public ConnectionTool(String prototypeClassName) {
        this(prototypeClassName, null, null);
    }

    public ConnectionTool(String prototypeClassName, Map<AttributeKey, Object> attributes, String presentationName) {
        try {
            this.prototype = (ConnectionFigure)Class.forName(prototypeClassName).newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to create ConnectionFigure from " + prototypeClassName);
            error.initCause(e);
            throw error;
        }
        this.prototypeAttributes = attributes;
        if (presentationName == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            presentationName = labels.getString("createConnectionFigure");
        }
        this.presentationName = presentationName;
    }

    public ConnectionFigure getPrototype() {
        return this.prototype;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.repaintConnectors(evt);
    }

    public void repaintConnectors(MouseEvent evt) {
        Rectangle2D.Double invalidArea = null;
        Point2D.Double targetPoint = this.viewToDrawing(new Point(evt.getX(), evt.getY()));
        Figure aFigure = this.getDrawing().findFigureExcept(targetPoint, this.createdFigure);
        if (aFigure != null && !aFigure.canConnect()) {
            aFigure = null;
        }
        if (this.targetFigure != aFigure) {
            for (Connector c : this.connectors) {
                if (invalidArea == null) {
                    invalidArea = c.getDrawingArea();
                    continue;
                }
                invalidArea.add(c.getDrawingArea());
            }
            this.targetFigure = aFigure;
            if (this.targetFigure != null) {
                this.connectors = this.targetFigure.getConnectors(this.getPrototype());
                for (Connector c : this.connectors) {
                    if (invalidArea == null) {
                        invalidArea = c.getDrawingArea();
                        continue;
                    }
                    invalidArea.add(c.getDrawingArea());
                }
            }
        }
        if (invalidArea != null) {
            this.getView().getComponent().repaint(this.getView().drawingToView(invalidArea));
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.getView().clearSelection();
        Point2D.Double startPoint = this.viewToDrawing(this.anchor);
        Figure startFigure = this.getDrawing().findFigure(startPoint);
        Connector connector = this.startConnector = startFigure == null ? null : startFigure.findConnector(startPoint, this.prototype);
        if (this.startConnector != null && this.prototype.canConnect(this.startConnector)) {
            Point2D.Double anchor = this.startConnector.getAnchor();
            this.createdFigure = this.createFigure();
            this.createdFigure.setStartPoint(anchor);
            this.createdFigure.setEndPoint(anchor);
            this.getDrawing().add(this.createdFigure);
            Rectangle r = new Rectangle(this.getView().drawingToView(anchor));
            r.grow(6, 6);
            this.fireAreaInvalidated(r);
        } else {
            this.startConnector = null;
            this.createdFigure = null;
        }
        this.endConnector = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.repaintConnectors(e);
        if (this.createdFigure != null) {
            this.createdFigure.willChange();
            Point2D.Double endPoint = this.viewToDrawing(new Point(e.getX(), e.getY()));
            this.getView().getConstrainer().constrainPoint(endPoint);
            Figure endFigure = this.getDrawing().findFigureExcept(endPoint, this.createdFigure);
            Connector connector = this.endConnector = endFigure == null ? null : endFigure.findConnector(endPoint, this.prototype);
            if (this.endConnector != null && this.createdFigure.canConnect(this.startConnector, this.endConnector)) {
                endPoint = this.endConnector.getAnchor();
            }
            Rectangle r = new Rectangle(this.getView().drawingToView(this.createdFigure.getEndPoint()));
            this.createdFigure.setEndPoint(endPoint);
            r.add(this.getView().drawingToView(endPoint));
            r.grow(8, 8);
            this.getView().getComponent().repaint(r);
            this.createdFigure.changed();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.createdFigure != null && this.startConnector != null && this.endConnector != null) {
            this.createdFigure.willChange();
            this.createdFigure.setStartConnector(this.startConnector);
            this.createdFigure.setEndConnector(this.endConnector);
            this.createdFigure.updateConnection();
            this.createdFigure.changed();
            final ConnectionFigure addedFigure = this.createdFigure;
            final Drawing addedDrawing = this.getDrawing();
            this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return ConnectionTool.this.presentationName;
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    addedDrawing.remove(addedFigure);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    addedDrawing.add(addedFigure);
                }
            });
            this.targetFigure = null;
            Point2D.Double anchor = this.startConnector.getAnchor();
            Rectangle r = new Rectangle(this.getView().drawingToView(anchor));
            r.grow(6, 6);
            this.fireAreaInvalidated(r);
            anchor = this.endConnector.getAnchor();
            r = new Rectangle(this.getView().drawingToView(anchor));
            r.grow(6, 6);
            this.fireAreaInvalidated(r);
            this.endConnector = null;
            this.startConnector = null;
            this.createdFigure = null;
            this.creationFinished(this.createdFigure);
        } else {
            this.fireToolDone();
        }
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        if (this.createdFigure != null) {
            this.getDrawing().remove(this.createdFigure);
            this.createdFigure = null;
        }
        this.targetFigure = null;
        this.endConnector = null;
        this.startConnector = null;
        super.deactivate(editor);
    }

    protected ConnectionFigure createFigure() {
        ConnectionFigure f = (ConnectionFigure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.prototypeAttributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.prototypeAttributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D gg = (Graphics2D)g.create();
        gg.transform(this.getView().getDrawingToViewTransform());
        if (this.targetFigure != null) {
            for (Connector c : this.targetFigure.getConnectors(this.getPrototype())) {
                c.draw(gg);
            }
        }
        if (this.createdFigure != null) {
            this.createdFigure.draw(gg);
            Point p = this.getView().drawingToView(this.createdFigure.getStartPoint());
            Ellipse2D.Double e = new Ellipse2D.Double(p.x - 3, p.y - 3, 6.0, 6.0);
            g.setColor(Color.GREEN);
            g.fill(e);
            g.setColor(Color.BLACK);
            g.draw(e);
            p = this.getView().drawingToView(this.createdFigure.getEndPoint());
            e = new Ellipse2D.Double(p.x - 3, p.y - 3, 6.0, 6.0);
            g.setColor(Color.GREEN);
            g.fill(e);
            g.setColor(Color.BLACK);
            g.draw(e);
        }
        gg.dispose();
    }

    protected void creationFinished(Figure createdFigure) {
        this.fireToolDone();
    }
}

