/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractEditorAction;

public class ZoomEditorAction
extends AbstractEditorAction {
    public static final String ID = "zoomEditor";
    private double scaleFactor;
    private AbstractButton button;
    private String label;
    private boolean updateAllViews;

    public ZoomEditorAction(DrawingEditor editor, double scaleFactor, AbstractButton button) {
        this(editor, scaleFactor, button, true);
    }

    public ZoomEditorAction(DrawingEditor editor, double scaleFactor, AbstractButton button, boolean updateAllViews) {
        super(editor);
        this.scaleFactor = scaleFactor;
        this.button = button;
        this.updateAllViews = updateAllViews;
        this.label = (int)(scaleFactor * 100.0) + " %";
        this.putValue("Default", this.label);
        this.putValue("Name", this.label);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.button != null) {
            this.button.setText(this.label);
        }
        if (this.updateAllViews) {
            for (DrawingView v : this.getEditor().getDrawingViews()) {
                v.setScaleFactor(this.scaleFactor);
            }
        } else {
            this.getView().setScaleFactor(this.scaleFactor);
        }
    }
}

