/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.estimation;

import java.io.Serializable;
import org.apache.commons.math.estimation.AbstractEstimator;
import org.apache.commons.math.estimation.EstimationException;
import org.apache.commons.math.estimation.EstimationProblem;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class GaussNewtonEstimator
extends AbstractEstimator
implements Serializable {
    private double steadyStateThreshold;
    private double convergence;
    private static final long serialVersionUID = 5485001826076289109L;

    public GaussNewtonEstimator(int maxCostEval, double convergence, double steadyStateThreshold) {
        this.setMaxCostEval(maxCostEval);
        this.steadyStateThreshold = steadyStateThreshold;
        this.convergence = convergence;
    }

    public void estimate(EstimationProblem problem) throws EstimationException {
        this.initializeEstimate(problem);
        double[] grad = new double[this.parameters.length];
        RealMatrixImpl bDecrement = new RealMatrixImpl(this.parameters.length, 1);
        double[][] bDecrementData = bDecrement.getDataRef();
        RealMatrixImpl wGradGradT = new RealMatrixImpl(this.parameters.length, this.parameters.length);
        double[][] wggData = wGradGradT.getDataRef();
        double previous = Double.POSITIVE_INFINITY;
        do {
            this.incrementJacobianEvaluationsCounter();
            RealMatrix b = new RealMatrixImpl(this.parameters.length, 1);
            RealMatrix a = new RealMatrixImpl(this.parameters.length, this.parameters.length);
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i].isIgnored()) continue;
                double weight = this.measurements[i].getWeight();
                double residual = this.measurements[i].getResidual();
                for (int j = 0; j < this.parameters.length; ++j) {
                    grad[j] = this.measurements[i].getPartial(this.parameters[j]);
                    bDecrementData[j][0] = weight * residual * grad[j];
                }
                for (int k = 0; k < this.parameters.length; ++k) {
                    double[] wggRow = wggData[k];
                    double gk = grad[k];
                    for (int l = 0; l < this.parameters.length; ++l) {
                        wggRow[l] = weight * gk * grad[l];
                    }
                }
                a = a.add(wGradGradT);
                b = b.add(bDecrement);
            }
            try {
                RealMatrix dX = a.solve(b);
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].setEstimate(this.parameters[i].getEstimate() + dX.getEntry(i, 0));
                }
            }
            catch (InvalidMatrixException e) {
                throw new EstimationException("unable to solve: singular problem", new Object[0]);
            }
            previous = this.cost;
            this.updateResidualsAndCost();
        } while (this.getCostEvaluations() < 2 || Math.abs(previous - this.cost) > this.cost * this.steadyStateThreshold && Math.abs(this.cost) > this.convergence);
    }
}

