/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.File;
import java.util.Formatter;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFileSystemService {
    private static Logger log = LoggerFactory.getLogger(AbstractFileSystemService.class);
    public static final String ROOT_DEFAULT = File.separator + "OMERO" + File.separator;
    public static final String PIXELS_PATH = "Pixels" + File.separator;
    public static final String FILES_PATH = "Files" + File.separator;
    public static final String THUMBNAILS_PATH = "Thumbnails" + File.separator;
    private final String root;

    @Deprecated
    public AbstractFileSystemService(String path) {
        this(path, false);
        log.info("assuming read-write repository at " + path);
    }

    public AbstractFileSystemService(String path, boolean isReadOnlyRepo) {
        File rootDirectory = new File(path);
        if (!rootDirectory.isDirectory() || !rootDirectory.canRead() || !isReadOnlyRepo && !rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Invalid directory specified for file system service: " + rootDirectory);
        }
        this.root = rootDirectory.getAbsolutePath();
        if (log.isDebugEnabled()) {
            log.debug("Using root path: '" + this.root + "'");
        }
    }

    protected void createSubpath(String path) {
        File directory;
        File file = new File(path);
        if (!file.exists() && !(directory = new File(file.getParent())).exists()) {
            directory.mkdirs();
        }
    }

    public String getPixelsDirectory() {
        return FilenameUtils.concat((String)this.root, (String)PIXELS_PATH);
    }

    public String getPixelsPath(Long id) {
        return this.getPath(PIXELS_PATH, id);
    }

    public String getFilesPath(Long id) {
        return this.getPath(FILES_PATH, id);
    }

    public String getThumbnailPath(Long id) {
        return this.getPath(THUMBNAILS_PATH, id);
    }

    protected String getPath(String prefix, Long id) {
        String suffix = "";
        Long remaining = id;
        Long dirno = 0L;
        if (id == null) {
            throw new NullPointerException("Expecting a not-null id.");
        }
        while (remaining > 999L) {
            if ((remaining = Long.valueOf(remaining / 1000L)) <= 0L) continue;
            try (Formatter formatter = new Formatter();){
                dirno = remaining % 1000L;
                suffix = formatter.format("Dir-%03d", dirno).out().toString() + File.separator + suffix;
            }
        }
        return FilenameUtils.concat((String)this.root, (String)(prefix + suffix + id));
    }
}

