/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class IndexSearcherWithPayload {
    private static final Logger log = LoggerFactory.make();
    private final IndexSearcher searcher;
    private boolean fieldSortDoTrackScores;
    private boolean fieldSortDoMaxScore;

    public IndexSearcherWithPayload(IndexSearcher searcher, boolean fieldSortDoTrackScores, boolean fieldSortDoMaxScore) {
        this.searcher = searcher;
        this.fieldSortDoTrackScores = fieldSortDoTrackScores;
        this.fieldSortDoMaxScore = fieldSortDoMaxScore;
        searcher.setDefaultFieldSortScoring(fieldSortDoTrackScores, fieldSortDoMaxScore);
    }

    public IndexSearcher getSearcher() {
        return this.searcher;
    }

    public boolean isFieldSortDoTrackScores() {
        return this.fieldSortDoTrackScores;
    }

    public boolean isFieldSortDoMaxScore() {
        return this.fieldSortDoMaxScore;
    }

    public void closeSearcher(Object query, SearchFactoryImplementor searchFactoryImplementor) {
        Set<IndexReader> indexReaders = ReaderProviderHelper.getIndexReaders(this.getSearcher());
        ReaderProvider readerProvider = searchFactoryImplementor.getReaderProvider();
        for (IndexReader indexReader : indexReaders) {
            try {
                readerProvider.closeReader(indexReader);
            }
            catch (SearchException e) {
                log.warn("Unable to properly close searcher during lucene query: " + query.toString(), (Throwable)e);
            }
        }
    }
}

