/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RLong;
import omero.gateway.model.AnnotationData;
import omero.model.LongAnnotation;
import omero.model.LongAnnotationI;
import omero.rtypes;

public class RatingAnnotationData
extends AnnotationData {
    public static final String INSIGHT_RATING_NS = "openmicroscopy.org/omero/insight/rating";
    public static final int LEVEL_ZERO = 0;
    public static final int LEVEL_ONE = 1;
    public static final int LEVEL_TWO = 2;
    public static final int LEVEL_THREE = 3;
    public static final int LEVEL_FOUR = 4;
    public static final int LEVEL_FIVE = 5;

    private void checkValue(int v) {
        switch (v) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Rating value not supported.");
            }
        }
    }

    public RatingAnnotationData() {
        this(0);
    }

    public RatingAnnotationData(int value) {
        super(LongAnnotationI.class);
        this.setRating(value);
        this.setNameSpace(INSIGHT_RATING_NS);
    }

    public RatingAnnotationData(LongAnnotation annotation) {
        super(annotation);
        this.checkValue(this.getRating());
        this.setNameSpace(INSIGHT_RATING_NS);
    }

    public int getRating() {
        Long i = (Long)this.getContent();
        return i == null ? -1 : i.intValue();
    }

    public void setRating(int value) {
        this.checkValue(value);
        this.setDirty(true);
        RLong l = rtypes.rlong((long)value);
        ((LongAnnotation)this.asAnnotation()).setLongValue(l);
    }

    @Override
    public Object getContent() {
        RLong l = ((LongAnnotation)this.asAnnotation()).getLongValue();
        return l == null ? null : Long.valueOf(l.getValue());
    }

    @Override
    public String getContentAsString() {
        return "" + this.getRating();
    }

    @Override
    public void setContent(Object content) {
        if (content == null) {
            this.setRating(0);
        } else if (content instanceof Number) {
            Number n = (Number)content;
            this.setRating(n.intValue());
        } else {
            throw new IllegalArgumentException("Value not supported.");
        }
    }
}

