/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.utils.Encoder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Uid;
import java.util.concurrent.atomic.AtomicInteger;

public class UidGenerator {
    private static final AtomicInteger sequenceGenerator = new AtomicInteger();

    public static Uid generateUid() {
        byte[] timestamp = Encoder.longToBytes(MonotonicClock.currentTimeMillis());
        byte[] sequence = Encoder.intToBytes(sequenceGenerator.incrementAndGet());
        byte[] serverId = TransactionManagerServices.getConfiguration().buildServerIdArray();
        int uidLength = serverId.length + timestamp.length + sequence.length;
        byte[] uidArray = new byte[uidLength];
        System.arraycopy(serverId, 0, uidArray, 0, serverId.length);
        System.arraycopy(timestamp, 0, uidArray, serverId.length, timestamp.length);
        System.arraycopy(sequence, 0, uidArray, serverId.length + timestamp.length, sequence.length);
        return new Uid(uidArray);
    }

    public static BitronixXid generateXid(Uid gtrid) {
        return new BitronixXid(gtrid, UidGenerator.generateUid());
    }
}

