/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2DataRepresentationSection {
    private final int length;
    private final int section;
    private final int dataPoints;
    private final int dataTemplate;
    private float referenceValue;
    private int binaryScaleFactor;
    private int decimalScaleFactor;
    private int numberOfBits;
    private int originalType;
    private int splittingMethod;
    private int compressionMethod;
    private int compressionRatio;
    private int missingValueManagement;
    private float primaryMissingValue = -9999.0f;
    private float secondaryMissingValue = -9999.0f;
    private int numberOfGroups;
    private int referenceGroupWidths;
    private int bitsGroupWidths;
    private int referenceGroupLength;
    private int lengthIncrement;
    private int lengthLastGroup;
    private int bitsScaledGroupLength;
    private int orderSpatial;
    private int descriptorSpatial;

    public Grib2DataRepresentationSection(RandomAccessFile raf) throws IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        this.dataPoints = GribNumbers.int4(raf);
        this.dataTemplate = GribNumbers.uint2(raf);
        switch (this.dataTemplate) {
            case 0: 
            case 1: {
                this.referenceValue = raf.readFloat();
                this.binaryScaleFactor = GribNumbers.int2(raf);
                this.decimalScaleFactor = GribNumbers.int2(raf);
                this.numberOfBits = raf.read();
                this.originalType = raf.read();
                if (this.dataTemplate == 0) break;
                System.out.println("DRS dataTemplate=1 not implemented yet");
                break;
            }
            case 2: 
            case 3: {
                this.referenceValue = raf.readFloat();
                this.binaryScaleFactor = GribNumbers.int2(raf);
                this.decimalScaleFactor = GribNumbers.int2(raf);
                this.numberOfBits = raf.read();
                this.originalType = raf.read();
                this.splittingMethod = raf.read();
                this.missingValueManagement = raf.read();
                this.primaryMissingValue = raf.readFloat();
                this.secondaryMissingValue = raf.readFloat();
                this.numberOfGroups = GribNumbers.int4(raf);
                this.referenceGroupWidths = raf.read();
                this.bitsGroupWidths = raf.read();
                this.bitsGroupWidths -= this.referenceGroupWidths;
                this.referenceGroupLength = GribNumbers.int4(raf);
                this.lengthIncrement = raf.read();
                this.lengthLastGroup = GribNumbers.int4(raf);
                this.bitsScaledGroupLength = raf.read();
                if (this.dataTemplate == 2) break;
                this.orderSpatial = raf.read();
                this.descriptorSpatial = raf.read();
                break;
            }
            case 40: 
            case 40000: {
                this.referenceValue = raf.readFloat();
                this.binaryScaleFactor = GribNumbers.int2(raf);
                this.decimalScaleFactor = GribNumbers.int2(raf);
                this.numberOfBits = raf.read();
                this.originalType = raf.read();
                this.compressionMethod = raf.read();
                this.compressionRatio = raf.read();
                break;
            }
        }
    }

    public final int getLength() {
        return this.length;
    }

    public final int getDataPoints() {
        return this.dataPoints;
    }

    public final int getDataTemplateNumber() {
        return this.dataTemplate;
    }

    public final float getReferenceValue() {
        return this.referenceValue;
    }

    public final int getBinaryScaleFactor() {
        return this.binaryScaleFactor;
    }

    public final int getDecimalScaleFactor() {
        return this.decimalScaleFactor;
    }

    public final int getNumberOfBits() {
        return this.numberOfBits;
    }

    public final int getOriginalType() {
        return this.originalType;
    }

    public final int getSplittingMethod() {
        return this.splittingMethod;
    }

    public final int getCompressionMethod() {
        return this.compressionMethod;
    }

    public final int getCompressionRatio() {
        return this.compressionRatio;
    }

    public final int getMissingValueManagement() {
        return this.missingValueManagement;
    }

    public final float getPrimaryMissingValue() {
        return this.primaryMissingValue;
    }

    public final float getSecondaryMissingValue() {
        return this.secondaryMissingValue;
    }

    public final int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public final int getReferenceGroupWidths() {
        return this.referenceGroupWidths;
    }

    public final int getBitsGroupWidths() {
        return this.bitsGroupWidths;
    }

    public final int getReferenceGroupLength() {
        return this.referenceGroupLength;
    }

    public final int getLengthIncrement() {
        return this.lengthIncrement;
    }

    public final int getLengthLastGroup() {
        return this.lengthLastGroup;
    }

    public final int getBitsScaledGroupLength() {
        return this.bitsScaledGroupLength;
    }

    public final int getOrderSpatial() {
        return this.orderSpatial;
    }

    public final int getDescriptorSpatial() {
        return this.descriptorSpatial;
    }
}

