/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.osgi;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.InitializationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    private static final Pattern UNIQUE_NAME = Pattern.compile("^\\s*resource\\.[^\\.]*\\.uniqueName\\s*=\\s*([^\\s]+)\\s*$");
    private ServiceRegistration tmRegistration;
    private ServiceRegistration utRegistration;
    private Map<String, ServiceRegistration> dsRegistrations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.dsRegistrations = new HashMap<String, ServiceRegistration>();
        String configArea = context.getProperty("osgi.configuration.area").replace(" ", "%20");
        String btmPropFile = System.getProperty("bitronix.tm.configuration", "bitronix-default-config.properties");
        URI btmConfig = URI.create(configArea + btmPropFile);
        File cfgFile = new File(btmConfig);
        if (!cfgFile.exists() && !(cfgFile = new File(btmPropFile)).exists()) {
            throw new InitializationException("Configuration file not found: " + btmPropFile);
        }
        FileReader fileReader = new FileReader(cfgFile);
        Properties btmProperties = new Properties();
        try {
            btmProperties.load(fileReader);
        }
        finally {
            fileReader.close();
        }
        System.setProperty("bitronix.tm.configuration", cfgFile.getAbsolutePath());
        File resourceFile = cfgFile;
        String resourcePropFile = btmProperties.getProperty("bitronix.tm.resource.configuration");
        if (resourcePropFile != null) {
            URI resourceConfig = URI.create(configArea + resourcePropFile);
            resourceFile = new File(resourceConfig);
            if (!resourceFile.exists() && !(resourceFile = new File(resourcePropFile)).exists()) {
                throw new InitializationException("Configuration file not found: " + resourcePropFile);
            }
            System.setProperty("bitronix.tm.resource.configuration", resourceFile.getAbsolutePath());
        }
        BitronixTransactionManager tm = TransactionManagerServices.getTransactionManager();
        this.tmRegistration = context.registerService(TransactionManager.class.getName(), (Object)tm, null);
        this.utRegistration = context.registerService(UserTransaction.class.getName(), (Object)tm, null);
        Map<String, Integer> uniqueNameLineNumbers = this.rankingOfUniqueNameProperties(resourceFile);
        Map<String, XAResourceProducer> resources = TransactionManagerServices.getResourceLoader().getResources();
        for (Map.Entry<String, XAResourceProducer> me : resources.entrySet()) {
            Integer ranking = uniqueNameLineNumbers.get(me.getKey());
            if (ranking == null) {
                ranking = 1;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.pid", me.getKey());
            ((Dictionary)props).put("service.ranking", ranking);
            ((Dictionary)props).put("osgi.jndi.serviceName", me.getKey());
            ServiceRegistration sr = context.registerService(DataSource.class.getName(), (Object)me.getValue(), props);
            this.dsRegistrations.put(me.getKey(), sr);
        }
        Configuration conf = TransactionManagerServices.getConfiguration();
        log.info(String.format("Started JTA for server ID '%s'.", conf.getServerId()));
    }

    public void stop(BundleContext context) throws Exception {
        BitronixTransactionManager tm = TransactionManagerServices.getTransactionManager();
        tm.shutdown();
        this.tmRegistration.unregister();
        this.utRegistration.unregister();
        for (ServiceRegistration reg : this.dsRegistrations.values()) {
            reg.unregister();
        }
        this.dsRegistrations.clear();
        Configuration conf = TransactionManagerServices.getConfiguration();
        log.info(String.format("Stopped JTA for server ID '%s'.", conf.getServerId()));
    }

    private Map<String, Integer> rankingOfUniqueNameProperties(File file) throws FileNotFoundException, IOException {
        HashMap<String, Integer> lineNumbers = new HashMap<String, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int ranking = 1;
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = UNIQUE_NAME.matcher(line);
            if (matcher.matches()) {
                lineNumbers.put(matcher.group(1), ranking);
                ++ranking;
            }
            line = reader.readLine();
        }
        reader.close();
        return lineNumbers;
    }
}

