/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.svg.SVGDrawingPanel;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.io.SVGInputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;

public class SVGApplet
extends JApplet {
    private static final String VERSION = "7.0.8";
    private static final String NAME = "JHotDraw SVG";
    private SVGDrawingPanel drawingPanel;

    public String getParameter(String name) {
        try {
            return super.getParameter(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        String[] labels = this.getAppletInfo().split("\n");
        for (int i = 0; i < labels.length; ++i) {
            c.add(new JLabel(labels[i].length() == 0 ? " " : labels[i]));
        }
        new Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                Serializable result = null;
                InputStream in = null;
                try {
                    if (SVGApplet.this.getParameter("data") != null) {
                        in = new ByteArrayInputStream(SVGApplet.this.getParameter("data").getBytes("UTF8"));
                    } else if (SVGApplet.this.getParameter("datafile") != null) {
                        URL url = new URL(SVGApplet.this.getDocumentBase(), SVGApplet.this.getParameter("datafile"));
                        in = url.openConnection().getInputStream();
                    }
                    if (in != null) {
                        Drawing drawing = SVGApplet.this.createDrawing();
                        drawing.getInputFormats().get(0).read(in, drawing);
                        result = drawing;
                    }
                }
                catch (Throwable t) {
                    result = t;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                return result;
            }

            public void finished(Object result) {
                if (result instanceof Throwable) {
                    ((Throwable)result).printStackTrace();
                }
                Container c = SVGApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(SVGApplet.this.drawingPanel = new SVGDrawingPanel());
                SVGApplet.this.initComponents();
                if (result != null) {
                    if (result instanceof Drawing) {
                        SVGApplet.this.setDrawing((Drawing)result);
                    } else if (result instanceof Throwable) {
                        SVGApplet.this.getDrawing().add(new SVGTextFigure(result.toString()));
                        ((Throwable)result).printStackTrace();
                    }
                }
                c.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing d) {
        this.drawingPanel.setDrawing(d);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    private Drawing createDrawing() {
        DefaultDrawing drawing = new DefaultDrawing();
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(new SVGInputFormat());
        inputFormats.add(new ImageInputFormat(new SVGImageFigure()));
        inputFormats.add(new TextInputFormat(new SVGTextFigure()));
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(new SVGOutputFormat());
        outputFormats.add(new ImageOutputFormat());
        drawing.setInputFormats(inputFormats);
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String text) {
        if (text != null && text.length() > 0) {
            ByteArrayInputStream in = null;
            try {
                in = new ByteArrayInputStream(text.getBytes("UTF8"));
                Drawing drawing = this.createDrawing();
                drawing.getInputFormats().get(0).read(in, drawing);
                this.setDrawing(drawing);
            }
            catch (Throwable e) {
                this.getDrawing().clear();
                SVGTextFigure tf = new SVGTextFigure();
                tf.setText(e.getMessage());
                tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                this.getDrawing().add(tf);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public String getData() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getDrawing().getOutputFormats().get(0).write(out, this.getDrawing());
            return out.toString("UTF8");
        }
        catch (IOException e) {
            SVGTextFigure tf = new SVGTextFigure();
            tf.setText(e.getMessage());
            tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
            this.getDrawing().add(tf);
            e.printStackTrace();
            return "";
        }
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}};
    }

    public String getAppletInfo() {
        return "JHotDraw SVG\nVersion 7.0.8\n\nCopyright 1996-2007 (c) by the authors of JHotDraw\nThis software is licensed under LGPL or\nCreative Commons 2.5 BY";
    }

    private void initComponents() {
    }

    public static void mainx(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame f = new JFrame("SVGDraw Applet");
                f.setDefaultCloseOperation(3);
                SVGApplet a = new SVGApplet();
                f.getContentPane().add(a);
                a.init();
                f.setSize(500, 300);
                f.setVisible(true);
                a.start();
            }
        });
    }
}

