/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.io.Base64;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.io.StreamPosTokenizer;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.SVGConstants;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.io.DefaultSVGFigureFactory;
import org.jhotdraw.samples.svg.io.SVGFigureFactory;
import org.jhotdraw.xml.css.CSSParser;
import org.jhotdraw.xml.css.StyleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGInputFormat
implements InputFormat {
    private static final boolean DEBUG = false;
    private SVGFigureFactory factory;
    private URL url;
    private HashMap<String, IXMLElement> identifiedElements;
    private HashMap<IXMLElement, Object> elementObjects;
    private Stack<Viewport> viewportStack;
    private StyleManager styleManager;
    private LinkedList<Figure> figures;
    private IXMLElement document;
    private static final HashSet<String> supportedFeatures = new HashSet<String>(Arrays.asList("http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-static", "http://www.w3.org/Graphics/SVG/feature/1.2/#CoreAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#Structure", "http://www.w3.org/Graphics/SVG/feature/1.2/#ConditionalProcessing", "http://www.w3.org/Graphics/SVG/feature/1.2/#ConditionalProcessingAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#Image", "http://www.w3.org/Graphics/SVG/feature/1.2/#Shape", "http://www.w3.org/Graphics/SVG/feature/1.2/#Text", "http://www.w3.org/Graphics/SVG/feature/1.2/#PaintAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#OpacityAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#GraphicsAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#Gradient", "http://www.w3.org/Graphics/SVG/feature/1.2/#SolidColor", "http://www.w3.org/Graphics/SVG/feature/1.2/#Font"));

    public SVGInputFormat() {
        this(new DefaultSVGFigureFactory());
    }

    public SVGInputFormat(SVGFigureFactory factory) {
        this.factory = factory;
    }

    public LinkedList<Figure> readFigures(InputStream in) throws IOException {
        IXMLParser parser;
        this.figures = new LinkedList();
        try {
            parser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception ex) {
            InternalError e = new InternalError("Unable to instantiate NanoXML Parser");
            e.initCause(ex);
            throw e;
        }
        StdXMLReader reader = new StdXMLReader(in);
        parser.setReader(reader);
        try {
            this.document = (IXMLElement)parser.parse();
        }
        catch (XMLException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        IXMLElement svg = this.document;
        Stack stack = new Stack();
        LinkedList<IXMLElement> ll = new LinkedList<IXMLElement>();
        ll.add(this.document);
        stack.push(ll.iterator());
        while (!stack.empty() && ((Iterator)stack.peek()).hasNext()) {
            Iterator iter = (Iterator)stack.peek();
            IXMLElement node = (IXMLElement)iter.next();
            Iterator<IXMLElement> children = node.getChildren().iterator();
            if (!iter.hasNext()) {
                stack.pop();
            }
            if (children.hasNext()) {
                stack.push(children);
            }
            if (node.getName() == null || !node.getName().equals("svg") || node.getNamespace() != null && !node.getNamespace().equals("http://www.w3.org/2000/svg")) continue;
            svg = node;
            break;
        }
        if (svg.getName() == null || !svg.getName().equals("svg") || svg.getNamespace() != null && !svg.getNamespace().equals("http://www.w3.org/2000/svg")) {
            throw new IOException("'svg' element expected: " + svg.getName());
        }
        this.initStorageContext(this.document);
        this.flattenStyles(svg);
        this.readElement(svg);
        return this.figures;
    }

    private void initStorageContext(IXMLElement root) {
        this.identifiedElements = new HashMap();
        this.identifyElements(root);
        this.elementObjects = new HashMap();
        this.viewportStack = new Stack();
        this.viewportStack.push(new Viewport());
        this.styleManager = new StyleManager();
    }

    private void flattenStyles(IXMLElement elem) throws IOException {
        if (elem.getName() != null && elem.getName().equals("style") && this.readAttribute(elem, "type", "").equals("text/css") && elem.getContent() != null) {
            CSSParser cssParser = new CSSParser();
            cssParser.parse(elem.getContent(), this.styleManager);
        } else if (elem.getNamespace() == null || elem.getNamespace().equals("http://www.w3.org/2000/svg")) {
            String style = this.readAttribute(elem, "style", null);
            if (style != null) {
                for (String styleProperty : style.split(";")) {
                    String[] stylePropertyElements = styleProperty.split(":");
                    if (stylePropertyElements.length != 2 || elem.hasAttribute(stylePropertyElements[0].trim(), "http://www.w3.org/2000/svg")) continue;
                    elem.setAttribute(stylePropertyElements[0].trim(), "http://www.w3.org/2000/svg", stylePropertyElements[1].trim());
                }
            }
            this.styleManager.applyStylesTo(elem);
            for (IXMLElement node : elem.getChildren()) {
                if (!(node instanceof IXMLElement)) continue;
                IXMLElement child = node;
                this.flattenStyles(child);
            }
        }
    }

    private Figure readElement(IXMLElement elem) throws IOException {
        Figure f = null;
        if (elem.getNamespace() == null || elem.getNamespace().equals("http://www.w3.org/2000/svg")) {
            String name = elem.getName();
            if (name.equals("a")) {
                f = this.readAElement(elem);
            } else if (name.equals("circle")) {
                f = this.readCircleElement(elem);
            } else if (name.equals("defs")) {
                this.readDefsElement(elem);
                f = null;
            } else if (name.equals("ellipse")) {
                f = this.readEllipseElement(elem);
            } else if (name.equals("g")) {
                f = this.readGElement(elem);
            } else if (name.equals("image")) {
                f = this.readImageElement(elem);
            } else if (name.equals("line")) {
                f = this.readLineElement(elem);
            } else if (name.equals("linearGradient")) {
                this.readLinearGradientElement(elem);
                f = null;
            } else if (name.equals("path")) {
                f = this.readPathElement(elem);
            } else if (name.equals("polygon")) {
                f = this.readPolygonElement(elem);
            } else if (name.equals("polyline")) {
                f = this.readPolylineElement(elem);
            } else if (name.equals("radialGradient")) {
                this.readRadialGradientElement(elem);
                f = null;
            } else if (name.equals("rect")) {
                f = this.readRectElement(elem);
            } else if (name.equals("solidColor")) {
                this.readSolidColorElement(elem);
                f = null;
            } else if (name.equals("svg")) {
                f = this.readSVGElement(elem);
            } else if (name.equals("switch")) {
                f = this.readSwitchElement(elem);
            } else if (name.equals("text")) {
                f = this.readTextElement(elem);
            } else if (name.equals("textArea")) {
                f = this.readTextAreaElement(elem);
            } else if (!name.equals("title")) {
                if (name.equals("use")) {
                    f = this.readUseElement(elem);
                } else if (name.equals("style")) {
                    // empty if block
                }
            }
        }
        if (f instanceof SVGFigure) {
            if (((SVGFigure)f).isEmpty()) {
                return null;
            }
        } else if (f != null) {
            // empty if block
        }
        return f;
    }

    private void readDefsElement(IXMLElement elem) throws IOException {
        for (IXMLElement node : elem.getChildren()) {
            if (!(node instanceof IXMLElement)) continue;
            IXMLElement child = node;
            Figure childFigure = this.readElement(child);
        }
    }

    private Figure readGElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readOpacityAttribute(elem, a);
        CompositeFigure g = this.factory.createG(a);
        for (IXMLElement node : elem.getChildren()) {
            if (!(node instanceof IXMLElement)) continue;
            IXMLElement child = node;
            Figure childFigure = this.readElement(child);
            if (!this.readAttribute(child, "visibility", "visible").equals("visible") || this.readAttribute(child, "display", "inline").equals("none") || childFigure == null) continue;
            g.basicAdd(childFigure);
        }
        this.readTransformAttribute(elem, a);
        if (AttributeKeys.TRANSFORM.get(a) != null) {
            g.transform(AttributeKeys.TRANSFORM.get(a));
        }
        return g;
    }

    private Figure readAElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        CompositeFigure g = this.factory.createG(a);
        String href = this.readAttribute(elem, "xlink:href", null);
        if (href == null) {
            href = this.readAttribute(elem, "href", null);
        }
        for (IXMLElement node : elem.getChildren()) {
            if (!(node instanceof IXMLElement)) continue;
            IXMLElement child = node;
            Figure childFigure = this.readElement(child);
            if (this.readAttribute(child, "visibility", "visible").equals("visible") && !this.readAttribute(child, "display", "inline").equals("none") && childFigure != null) {
                g.basicAdd(childFigure);
            }
            if (childFigure == null) continue;
            SVGAttributeKeys.LINK.basicSet(childFigure, href);
        }
        return g.getChildCount() == 1 ? g.getChild(0) : g;
    }

    private Figure readSVGElement(IXMLElement elem) throws IOException {
        Viewport viewport = new Viewport();
        viewport.width = this.toWidth(elem, this.readAttribute(elem, "width", "100%"));
        viewport.height = this.toHeight(elem, this.readAttribute(elem, "height", "100%"));
        if (this.readAttribute(elem, "viewBox", "none").equals("none")) {
            viewport.viewBox.width = viewport.width;
            viewport.viewBox.height = viewport.height;
        } else {
            String[] viewBoxValues = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(elem, "viewBox", "none"));
            viewport.viewBox.x = this.toNumber(elem, viewBoxValues[0]);
            viewport.viewBox.y = this.toNumber(elem, viewBoxValues[1]);
            viewport.viewBox.width = this.toNumber(elem, viewBoxValues[2]);
            viewport.viewBox.height = this.toNumber(elem, viewBoxValues[3]);
        }
        viewport.isPreserveAspectRatio = !this.readAttribute(elem, "preserveAspectRatio", "none").equals("none");
        viewport.widthPercentFactor = viewport.viewBox.width / 100.0;
        viewport.heightPercentFactor = viewport.viewBox.height / 100.0;
        viewport.numberFactor = Math.min(viewport.width / viewport.viewBox.width, viewport.height / viewport.viewBox.height);
        AffineTransform viewBoxTransform = new AffineTransform();
        viewBoxTransform.translate(-viewport.viewBox.x * viewport.width / viewport.viewBox.width, -viewport.viewBox.y * viewport.height / viewport.viewBox.height);
        if (viewport.isPreserveAspectRatio) {
            double factor = Math.min(viewport.width / viewport.viewBox.width, viewport.height / viewport.viewBox.height);
            viewBoxTransform.scale(factor, factor);
        } else {
            viewBoxTransform.scale(viewport.width / viewport.viewBox.width, viewport.height / viewport.viewBox.height);
        }
        this.viewportStack.push(viewport);
        for (IXMLElement node : elem.getChildren()) {
            if (!(node instanceof IXMLElement)) continue;
            IXMLElement child = node;
            Figure childFigure = this.readElement(child);
            if (!this.readAttribute(child, "visibility", "visible").equals("visible") || this.readAttribute(child, "display", "inline").equals("none") || childFigure == null) continue;
            childFigure.transform(viewBoxTransform);
            this.figures.add(childFigure);
        }
        this.viewportStack.pop();
        return null;
    }

    private Figure readRectElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        double x = this.toNumber(elem, this.readAttribute(elem, "x", "0"));
        double y = this.toNumber(elem, this.readAttribute(elem, "y", "0"));
        double w = this.toWidth(elem, this.readAttribute(elem, "width", "0"));
        double h = this.toHeight(elem, this.readAttribute(elem, "height", "0"));
        String rxValue = this.readAttribute(elem, "rx", "none");
        String ryValue = this.readAttribute(elem, "ry", "none");
        if (rxValue.equals("none")) {
            rxValue = ryValue;
        }
        if (ryValue.equals("none")) {
            ryValue = rxValue;
        }
        double rx = this.toNumber(elem, rxValue.equals("none") ? "0" : rxValue);
        double ry = this.toNumber(elem, ryValue.equals("none") ? "0" : ryValue);
        Figure figure = this.factory.createRect(x, y, w, h, rx, ry, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readCircleElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        double cx = this.toWidth(elem, this.readAttribute(elem, "cx", "0"));
        double cy = this.toHeight(elem, this.readAttribute(elem, "cy", "0"));
        double r = this.toWidth(elem, this.readAttribute(elem, "r", "0"));
        Figure figure = this.factory.createCircle(cx, cy, r, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readEllipseElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        double cx = this.toWidth(elem, this.readAttribute(elem, "cx", "0"));
        double cy = this.toHeight(elem, this.readAttribute(elem, "cy", "0"));
        double rx = this.toWidth(elem, this.readAttribute(elem, "rx", "0"));
        double ry = this.toHeight(elem, this.readAttribute(elem, "ry", "0"));
        Figure figure = this.factory.createEllipse(cx, cy, rx, ry, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Figure readImageElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        double x = this.toNumber(elem, this.readAttribute(elem, "x", "0"));
        double y = this.toNumber(elem, this.readAttribute(elem, "y", "0"));
        double w = this.toWidth(elem, this.readAttribute(elem, "width", "0"));
        double h = this.toHeight(elem, this.readAttribute(elem, "height", "0"));
        String href = this.readAttribute(elem, "xlink:href", null);
        if (href == null) {
            href = this.readAttribute(elem, "href", null);
        }
        byte[] imageData = null;
        if (href != null) {
            if (href.startsWith("data:")) {
                int semicolonPos = href.indexOf(59);
                if (semicolonPos == -1) throw new IOException("Unsupported data href in image element:" + href);
                if (href.indexOf(";base64,") != semicolonPos) throw new IOException("Unsupported encoding in data href in image element:" + href);
                imageData = Base64.decode(href.substring(semicolonPos + 8));
            } else {
                URL imageUrl = new URL(this.url, href);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[512];
                int len = 0;
                InputStream in = null;
                try {
                    in = imageUrl.openStream();
                    while ((len = in.read(buf)) > 0) {
                        bout.write(buf, 0, len);
                    }
                    imageData = bout.toByteArray();
                }
                catch (FileNotFoundException e) {
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        BufferedImage bufferedImage = null;
        if (imageData != null) {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        if (bufferedImage == null) {
            imageData = null;
        }
        Figure figure = this.factory.createImage(x, y, w, h, imageData, bufferedImage, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readLineElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readLineAttributes(elem, a);
        if (AttributeKeys.FILL_COLOR.get(a) != null && AttributeKeys.STROKE_COLOR.get(a) == null) {
            AttributeKeys.STROKE_COLOR.set(a, AttributeKeys.FILL_COLOR.get(a));
        }
        if (SVGAttributeKeys.FILL_GRADIENT.get(a) != null && SVGAttributeKeys.STROKE_GRADIENT.get(a) == null) {
            SVGAttributeKeys.STROKE_GRADIENT.set(a, SVGAttributeKeys.FILL_GRADIENT.get(a));
        }
        AttributeKeys.FILL_COLOR.set(a, null);
        SVGAttributeKeys.FILL_GRADIENT.set(a, null);
        double x1 = this.toNumber(elem, this.readAttribute(elem, "x1", "0"));
        double y1 = this.toNumber(elem, this.readAttribute(elem, "y1", "0"));
        double x2 = this.toNumber(elem, this.readAttribute(elem, "x2", "0"));
        double y2 = this.toNumber(elem, this.readAttribute(elem, "y2", "0"));
        Figure figure = this.factory.createLine(x1, y1, x2, y2, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readPolylineElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readLineAttributes(elem, a);
        Point2D.Double[] points = this.toPoints(elem, this.readAttribute(elem, "points", ""));
        Figure figure = this.factory.createPolyline(points, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readPolygonElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        Point2D.Double[] points = this.toPoints(elem, this.readAttribute(elem, "points", ""));
        Figure figure = this.factory.createPolygon(points, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readPathElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        BezierPath[] beziers = this.toPath(elem, this.readAttribute(elem, "d", ""));
        Figure figure = this.factory.createPath(beziers, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readTextElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        this.readFontAttributes(elem, a);
        this.readTextAttributes(elem, a);
        String[] xStr = SVGInputFormat.toCommaSeparatedArray(this.readAttribute(elem, "x", "0"));
        String[] yStr = SVGInputFormat.toCommaSeparatedArray(this.readAttribute(elem, "y", "0"));
        Point2D.Double[] coordinates = new Point2D.Double[Math.max(xStr.length, yStr.length)];
        double lastX = 0.0;
        double lastY = 0.0;
        for (int i = 0; i < coordinates.length; ++i) {
            if (xStr.length > i) {
                try {
                    lastX = this.toNumber(elem, xStr[i]);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (yStr.length > i) {
                try {
                    lastY = this.toNumber(elem, yStr[i]);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            coordinates[i] = new Point2D.Double(lastX, lastY);
        }
        String[] rotateStr = SVGInputFormat.toCommaSeparatedArray(this.readAttribute(elem, "rotate", ""));
        double[] rotate = new double[rotateStr.length];
        for (int i = 0; i < rotateStr.length; ++i) {
            try {
                rotate[i] = this.toDouble(elem, rotateStr[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                rotate[i] = 0.0;
            }
        }
        DefaultStyledDocument doc = new DefaultStyledDocument();
        try {
            if (elem.getContent() != null) {
                doc.insertString(0, this.toText(elem, elem.getContent()), null);
            } else {
                for (IXMLElement node : elem.getChildren()) {
                    if (node.getName() == null) {
                        doc.insertString(0, this.toText(elem, node.getContent()), null);
                        continue;
                    }
                    if (!node.getName().equals("tspan")) continue;
                    this.readTSpanElement(node, doc);
                }
            }
        }
        catch (BadLocationException e) {
            InternalError ex = new InternalError(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        Figure figure = this.factory.createText(coordinates, rotate, doc, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private Figure readTextAreaElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a);
        this.readShapeAttributes(elem, a);
        this.readFontAttributes(elem, a);
        this.readTextAttributes(elem, a);
        this.readTextFlowAttributes(elem, a);
        double x = this.toNumber(elem, this.readAttribute(elem, "x", "0"));
        double y = this.toNumber(elem, this.readAttribute(elem, "y", "0"));
        double w = this.toWidth(elem, this.readAttribute(elem, "width", "0"));
        double h = this.toHeight(elem, this.readAttribute(elem, "height", "0"));
        DefaultStyledDocument doc = new DefaultStyledDocument();
        try {
            if (elem.getContent() != null) {
                doc.insertString(0, this.toText(elem, elem.getContent()), null);
            } else {
                for (IXMLElement node : elem.getChildren()) {
                    if (node.getName() == null) {
                        doc.insertString(0, this.toText(elem, node.getContent()), null);
                        continue;
                    }
                    if (!node.getName().equals("tspan")) continue;
                    this.readTSpanElement(node, doc);
                }
            }
        }
        catch (BadLocationException e) {
            InternalError ex = new InternalError(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        Figure figure = this.factory.createTextArea(x, y, w, h, doc, a);
        this.elementObjects.put(elem, figure);
        return figure;
    }

    private void readTSpanElement(IXMLElement elem, DefaultStyledDocument doc) throws IOException {
        try {
            if (elem.getContent() != null) {
                doc.insertString(doc.getLength(), this.toText(elem, elem.getContent()), null);
            } else {
                for (IXMLElement node : elem.getChildren()) {
                    if (node instanceof IXMLElement) {
                        IXMLElement child = node;
                        if (node.getName() == null || !node.getName().equals("tspan")) continue;
                        this.readTSpanElement(node, doc);
                        continue;
                    }
                    if (node.getName() != null) continue;
                    doc.insertString(doc.getLength(), this.toText(elem, node.getContent()), null);
                }
            }
        }
        catch (BadLocationException e) {
            InternalError ex = new InternalError(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private Figure readSwitchElement(IXMLElement elem) throws IOException {
        for (IXMLElement node : elem.getChildren()) {
            boolean isMatch;
            if (!(node instanceof IXMLElement)) continue;
            IXMLElement child = node;
            String[] requiredFeatures = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(child, "requiredFeatures", ""));
            String[] requiredExtensions = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(child, "requiredExtensions", ""));
            String[] systemLanguage = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(child, "systemLanguage", ""));
            String[] requiredFormats = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(child, "requiredFormats", ""));
            String[] requiredFonts = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(child, "requiredFonts", ""));
            boolean bl = isMatch = supportedFeatures.containsAll(Arrays.asList(requiredFeatures)) && requiredExtensions.length == 0 && requiredFormats.length == 0 && requiredFonts.length == 0;
            if (isMatch && systemLanguage.length > 0) {
                isMatch = false;
                Locale locale = Locale.getDefault();
                for (String lng : systemLanguage) {
                    int p = lng.indexOf(45);
                    if (p == -1) {
                        if (!locale.getLanguage().equals(lng)) continue;
                        isMatch = true;
                        break;
                    }
                    if (!locale.getLanguage().equals(lng.substring(0, p)) || !locale.getCountry().toLowerCase().equals(lng.substring(p + 1))) continue;
                    isMatch = true;
                    break;
                }
            }
            if (!isMatch) continue;
            Figure figure = this.readElement(child);
            if (this.readAttribute(child, "visibility", "visible").equals("visible") && !this.readAttribute(child, "display", "inline").equals("none")) {
                return figure;
            }
            return null;
        }
        return null;
    }

    private Figure readUseElement(IXMLElement elem) throws IOException {
        Figure obj;
        IXMLElement refElem;
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        HashMap<AttributeKey, Object> a2 = new HashMap<AttributeKey, Object>();
        this.readTransformAttribute(elem, a);
        this.readOpacityAttribute(elem, a2);
        this.readUseShapeAttributes(elem, a2);
        String href = this.readAttribute(elem, "xlink:href", null);
        if (href != null && href.startsWith("#") && (refElem = this.identifiedElements.get(href.substring(1))) != null && (obj = this.readElement(refElem)) instanceof Figure) {
            Figure figure = (Figure)obj.clone();
            for (Map.Entry<AttributeKey, Object> entry : a2.entrySet()) {
                figure.setAttribute(entry.getKey(), entry.getValue());
            }
            AffineTransform tx = AttributeKeys.TRANSFORM.get(a) == null ? new AffineTransform() : AttributeKeys.TRANSFORM.get(a);
            double x = this.toNumber(elem, this.readAttribute(elem, "x", "0"));
            double y = this.toNumber(elem, this.readAttribute(elem, "y", "0"));
            tx.translate(x, y);
            figure.transform(tx);
            return figure;
        }
        return null;
    }

    private String readInheritAttribute(IXMLElement elem, String attributeName, String defaultValue) {
        if (elem.hasAttribute(attributeName, "http://www.w3.org/2000/svg")) {
            String value = elem.getAttribute(attributeName, "http://www.w3.org/2000/svg", null);
            if (value.equals("inherit")) {
                return this.readInheritAttribute(elem.getParent(), attributeName, defaultValue);
            }
            return value;
        }
        if (elem.hasAttribute(attributeName)) {
            String value = elem.getAttribute(attributeName);
            if (value.equals("inherit")) {
                return this.readInheritAttribute(elem.getParent(), attributeName, defaultValue);
            }
            return value;
        }
        if (elem.getParent() != null && (elem.getParent().getNamespace() == null || elem.getParent().getNamespace().equals("http://www.w3.org/2000/svg"))) {
            return this.readInheritAttribute(elem.getParent(), attributeName, defaultValue);
        }
        return defaultValue;
    }

    private double readInheritFontSizeAttribute(IXMLElement elem, String attributeName, String defaultValue) throws IOException {
        String value = null;
        value = elem.hasAttribute(attributeName, "http://www.w3.org/2000/svg") ? elem.getAttribute(attributeName, "http://www.w3.org/2000/svg", null) : (elem.hasAttribute(attributeName) ? elem.getAttribute(attributeName, null) : defaultValue);
        if (value.equals("inherit")) {
            return this.readInheritFontSizeAttribute(elem.getParent(), attributeName, defaultValue);
        }
        if (SVGConstants.SVG_ABSOLUTE_FONT_SIZES.containsKey(value)) {
            return SVGConstants.SVG_ABSOLUTE_FONT_SIZES.get(value);
        }
        if (SVGConstants.SVG_RELATIVE_FONT_SIZES.containsKey(value)) {
            return SVGConstants.SVG_RELATIVE_FONT_SIZES.get(value) * this.readInheritFontSizeAttribute(elem.getParent(), attributeName, defaultValue);
        }
        if (value.endsWith("%")) {
            double factor = Double.valueOf(value.substring(0, value.length() - 1));
            return factor * this.readInheritFontSizeAttribute(elem.getParent(), attributeName, defaultValue);
        }
        return this.toNumber(elem, value);
    }

    private String readAttribute(IXMLElement elem, String attributeName, String defaultValue) {
        if (elem.hasAttribute(attributeName, "http://www.w3.org/2000/svg")) {
            String value = elem.getAttribute(attributeName, "http://www.w3.org/2000/svg", null);
            if (value.equals("inherit")) {
                return this.readAttribute(elem.getParent(), attributeName, defaultValue);
            }
            return value;
        }
        if (elem.hasAttribute(attributeName)) {
            String value = elem.getAttribute(attributeName, null);
            if (value.equals("inherit")) {
                return this.readAttribute(elem.getParent(), attributeName, defaultValue);
            }
            return value;
        }
        return defaultValue;
    }

    private double toWidth(IXMLElement elem, String str) throws IOException {
        return this.toLength(elem, str, this.viewportStack.peek().widthPercentFactor);
    }

    private double toHeight(IXMLElement elem, String str) throws IOException {
        return this.toLength(elem, str, this.viewportStack.peek().heightPercentFactor);
    }

    private double toNumber(IXMLElement elem, String str) throws IOException {
        return this.toLength(elem, str, this.viewportStack.peek().numberFactor);
    }

    private double toLength(IXMLElement elem, String str, double percentFactor) throws IOException {
        double scaleFactor = 1.0;
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
            scaleFactor = percentFactor;
        } else if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("pt")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 1.25;
        } else if (str.endsWith("pc")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 15.0;
        } else if (str.endsWith("mm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 3.543307;
        } else if (str.endsWith("cm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 35.43307;
        } else if (str.endsWith("in")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 90.0;
        } else if (str.endsWith("em")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = this.toLength(elem, this.readAttribute(elem, "font-size", "0"), percentFactor);
        } else {
            scaleFactor = 1.0;
        }
        return Double.parseDouble(str) * scaleFactor;
    }

    public static String[] toCommaSeparatedArray(String str) throws IOException {
        return str.split("\\s*,\\s*");
    }

    public static String[] toWSOrCommaSeparatedArray(String str) throws IOException {
        String[] result = str.split("(\\s*,\\s*|\\s+)");
        if (result.length == 1 && result[0].equals("")) {
            return new String[0];
        }
        return result;
    }

    private Point2D.Double[] toPoints(IXMLElement elem, String str) throws IOException {
        StringTokenizer tt = new StringTokenizer(str, " ,");
        Point2D.Double[] points = new Point2D.Double[tt.countTokens() / 2];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new Point2D.Double(this.toNumber(elem, tt.nextToken()), this.toNumber(elem, tt.nextToken()));
        }
        return points;
    }

    private BezierPath[] toPath(IXMLElement elem, String str) throws IOException {
        LinkedList<ArrayList> paths = new LinkedList<ArrayList>();
        ArrayList path = null;
        Point2D.Double p = new Point2D.Double();
        Point2D.Double c1 = new Point2D.Double();
        Point2D.Double c2 = new Point2D.Double();
        StreamPosTokenizer tt = new StreamPosTokenizer(new StringReader(str));
        tt.resetSyntax();
        tt.parseNumbers();
        tt.parseExponents();
        tt.parsePlusAsNumber();
        tt.whitespaceChars(0, 32);
        tt.whitespaceChars(44, 44);
        int nextCommand = 77;
        int command = 77;
        block21: while (tt.nextToken() != -1) {
            if (tt.ttype > 0) {
                command = (char)tt.ttype;
            } else {
                command = nextCommand;
                tt.pushBack();
            }
            switch (command) {
                case 77: {
                    if (path != null) {
                        paths.add(path);
                    }
                    path = new BezierPath();
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'M' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'M' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).moveTo(p.x, p.y);
                    nextCommand = 76;
                    continue block21;
                }
                case 109: {
                    if (path != null) {
                        paths.add(path);
                    }
                    path = new BezierPath();
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'm' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'm' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).moveTo(p.x, p.y);
                    nextCommand = 108;
                    continue block21;
                }
                case 90: 
                case 122: {
                    p.x = ((BezierPath.Node)path.get((int)0)).x[0];
                    p.y = ((BezierPath.Node)path.get((int)0)).y[0];
                    if (path.size() > 1) {
                        BezierPath.Node first = (BezierPath.Node)path.get(0);
                        BezierPath.Node last = (BezierPath.Node)path.get(path.size() - 1);
                        if (first.x[0] == last.x[0] && first.y[0] == last.y[0]) {
                            if ((last.mask & 1) != 0) {
                                first.mask |= 1;
                                first.x[1] = last.x[1];
                                first.y[1] = last.y[1];
                            }
                            path.remove(path.size() - 1);
                        }
                    }
                    ((BezierPath)path).setClosed(true);
                    continue block21;
                }
                case 76: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'L' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'L' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 76;
                    continue block21;
                }
                case 108: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'l' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'l' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 108;
                    continue block21;
                }
                case 72: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'H' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 72;
                    continue block21;
                }
                case 104: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'h' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 104;
                    continue block21;
                }
                case 86: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'V' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 86;
                    continue block21;
                }
                case 118: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'v' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 118;
                    continue block21;
                }
                case 67: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x1 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y1 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x2 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y2 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 67;
                    continue block21;
                }
                case 99: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx1 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy1 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx2 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy2 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 99;
                    continue block21;
                }
                case 83: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("x2 coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y2 coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 83;
                    continue block21;
                }
                case 115: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx2 coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy2 coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 115;
                    continue block21;
                }
                case 81: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x1 coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y1 coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 81;
                    continue block21;
                }
                case 113: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx1 coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy1 coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 113;
                    continue block21;
                }
                case 84: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'T' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'T' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 84;
                    continue block21;
                }
                case 116: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 't' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 't' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 115;
                    continue block21;
                }
                case 65: {
                    boolean sweepFlag;
                    boolean largeArcFlag;
                    if (tt.nextToken() != -2) {
                        throw new IOException("rx coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double rx = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("ry coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double ry = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x-axis-rotation missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double xAxisRotation = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("large-arc-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl = largeArcFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("sweep-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl2 = sweepFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).arcTo(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, p.x, p.y);
                    nextCommand = 65;
                    continue block21;
                }
                case 97: {
                    boolean sweepFlag;
                    boolean largeArcFlag;
                    if (tt.nextToken() != -2) {
                        throw new IOException("rx coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double rx = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("ry coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double ry = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x-axis-rotation missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double xAxisRotation = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("large-arc-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl = largeArcFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("sweep-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl3 = sweepFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).arcTo(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, p.x, p.y);
                    nextCommand = 97;
                    continue block21;
                }
            }
            break;
        }
        if (path != null) {
            paths.add(path);
        }
        return paths.toArray(new BezierPath[paths.size()]);
    }

    private void readCoreAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
    }

    private void identifyElements(IXMLElement elem) {
        this.identifiedElements.put(elem.getAttribute("id"), elem);
        this.identifiedElements.put(elem.getAttribute("xml:id"), elem);
        for (IXMLElement child : elem.getChildren()) {
            this.identifyElements(child);
        }
    }

    private void readOpacityAttribute(IXMLElement elem, Map<AttributeKey, Object> a) throws IOException {
        double value = this.toDouble(elem, this.readAttribute(elem, "opacity", "1"), 1.0, 0.0, 1.0);
        SVGAttributeKeys.OPACITY.set(a, (Double)value);
    }

    private void readTextAttributes(IXMLElement elem, Map<AttributeKey, Object> a) throws IOException {
        String value = this.readInheritAttribute(elem, "text-anchor", "start");
        if (SVGConstants.SVG_TEXT_ANCHORS.get(value) != null) {
            SVGAttributeKeys.TEXT_ANCHOR.set(a, SVGConstants.SVG_TEXT_ANCHORS.get(value));
        }
        if (!(value = this.readInheritAttribute(elem, "display-align", "auto")).equals("auto")) {
            if (value.equals("center")) {
                SVGAttributeKeys.TEXT_ANCHOR.set(a, SVGAttributeKeys.TextAnchor.MIDDLE);
            } else if (value.equals("before")) {
                SVGAttributeKeys.TEXT_ANCHOR.set(a, SVGAttributeKeys.TextAnchor.END);
            }
        }
        if (!(value = this.readInheritAttribute(elem, "text-align", "start")).equals("start")) {
            SVGAttributeKeys.TEXT_ALIGN.set(a, SVGConstants.SVG_TEXT_ALIGNS.get(value));
        }
    }

    private void readTextFlowAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        String value = this.readInheritAttribute(elem, "line-increment", "auto");
    }

    private void readTransformAttribute(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        String value = this.readAttribute(elem, "transform", "none");
        if (!value.equals("none")) {
            AttributeKeys.TRANSFORM.set(a, SVGInputFormat.toTransform(elem, value));
        }
    }

    private void readSolidColorElement(IXMLElement elem) throws IOException {
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        Color color = this.toColor(elem, this.readAttribute(elem, "solid-color", "black"));
        double opacity = this.toDouble(elem, this.readAttribute(elem, "solid-opacity", "1"), 1.0, 0.0, 1.0);
        if (opacity != 1.0) {
            color = new Color((int)(255.0 * opacity) << 24 | 0xFFFFFF & color.getRGB(), true);
        }
        this.elementObjects.put(elem, color);
    }

    private void readShapeAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        Object objectValue = this.toPaint(elem, this.readInheritAttribute(elem, "fill", "black"));
        if (objectValue instanceof Color) {
            AttributeKeys.FILL_COLOR.set(a, (Color)objectValue);
        } else if (objectValue instanceof Gradient) {
            SVGAttributeKeys.FILL_GRADIENT.setClone(a, (Gradient)objectValue);
        } else if (objectValue == null) {
            AttributeKeys.FILL_COLOR.set(a, null);
        } else {
            AttributeKeys.FILL_COLOR.set(a, null);
        }
        objectValue = this.readInheritAttribute(elem, "fill-opacity", "1");
        SVGAttributeKeys.FILL_OPACITY.set(a, (Double)this.toDouble(elem, (String)objectValue, 1.0, 0.0, 1.0));
        String value = this.readInheritAttribute(elem, "fill-rule", "nonzero");
        AttributeKeys.WINDING_RULE.set(a, SVGConstants.SVG_FILL_RULES.get(value));
        objectValue = this.toPaint(elem, this.readInheritAttribute(elem, "stroke", "none"));
        if (objectValue instanceof Color) {
            AttributeKeys.STROKE_COLOR.set(a, (Color)objectValue);
        } else if (objectValue instanceof Gradient) {
            SVGAttributeKeys.STROKE_GRADIENT.setClone(a, (Gradient)objectValue);
        } else if (objectValue == null) {
            AttributeKeys.STROKE_COLOR.set(a, null);
        } else {
            AttributeKeys.STROKE_COLOR.set(a, null);
        }
        value = this.readInheritAttribute(elem, "stroke-dasharray", "none");
        if (!value.equals("none")) {
            String[] values = SVGInputFormat.toWSOrCommaSeparatedArray(value);
            double[] dashes = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                dashes[i] = this.toNumber(elem, values[i]);
            }
            AttributeKeys.STROKE_DASHES.set(a, dashes);
        }
        double doubleValue = this.toNumber(elem, this.readInheritAttribute(elem, "stroke-dashoffset", "0"));
        AttributeKeys.STROKE_DASH_PHASE.set(a, (Double)doubleValue);
        AttributeKeys.IS_STROKE_DASH_FACTOR.set(a, (Boolean)false);
        value = this.readInheritAttribute(elem, "stroke-linecap", "butt");
        AttributeKeys.STROKE_CAP.set(a, SVGConstants.SVG_STROKE_LINECAPS.get(value));
        value = this.readInheritAttribute(elem, "stroke-linejoin", "miter");
        AttributeKeys.STROKE_JOIN.set(a, SVGConstants.SVG_STROKE_LINEJOINS.get(value));
        doubleValue = this.toDouble(elem, this.readInheritAttribute(elem, "stroke-miterlimit", "4"), 4.0, 1.0, Double.MAX_VALUE);
        AttributeKeys.STROKE_MITER_LIMIT.set(a, (Double)doubleValue);
        AttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR.set(a, (Boolean)false);
        objectValue = this.readInheritAttribute(elem, "stroke-opacity", "1");
        SVGAttributeKeys.STROKE_OPACITY.set(a, (Double)this.toDouble(elem, (String)objectValue, 1.0, 0.0, 1.0));
        doubleValue = this.toNumber(elem, this.readInheritAttribute(elem, "stroke-width", "1"));
        AttributeKeys.STROKE_WIDTH.set(a, (Double)doubleValue);
    }

    private void readUseShapeAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        double doubleValue;
        String value;
        Object objectValue = this.readInheritAttribute(elem, "fill", null);
        if (objectValue != null) {
            if ((objectValue = this.toPaint(elem, (String)objectValue)) instanceof Color) {
                AttributeKeys.FILL_COLOR.set(a, (Color)objectValue);
            } else if (objectValue instanceof Gradient) {
                SVGAttributeKeys.FILL_GRADIENT.set(a, (Gradient)objectValue);
            } else if (objectValue == null) {
                AttributeKeys.FILL_COLOR.set(a, null);
            } else {
                AttributeKeys.FILL_COLOR.set(a, null);
            }
        }
        if ((objectValue = this.readInheritAttribute(elem, "fill-opacity", null)) != null) {
            SVGAttributeKeys.FILL_OPACITY.set(a, (Double)this.toDouble(elem, (String)objectValue, 1.0, 0.0, 1.0));
        }
        if ((value = this.readInheritAttribute(elem, "fill-rule", null)) != null) {
            AttributeKeys.WINDING_RULE.set(a, SVGConstants.SVG_FILL_RULES.get(value));
        }
        if ((objectValue = this.toPaint(elem, this.readInheritAttribute(elem, "stroke", null))) != null) {
            if (objectValue instanceof Color) {
                AttributeKeys.STROKE_COLOR.set(a, (Color)objectValue);
            } else if (objectValue instanceof Gradient) {
                SVGAttributeKeys.STROKE_GRADIENT.set(a, (Gradient)objectValue);
            }
        }
        if ((value = this.readInheritAttribute(elem, "stroke-dasharray", null)) != null && !value.equals("none")) {
            String[] values = SVGInputFormat.toCommaSeparatedArray(value);
            double[] dashes = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                dashes[i] = this.toNumber(elem, values[i]);
            }
            AttributeKeys.STROKE_DASHES.set(a, dashes);
        }
        if ((objectValue = this.readInheritAttribute(elem, "stroke-dashoffset", null)) != null) {
            doubleValue = this.toNumber(elem, (String)objectValue);
            AttributeKeys.STROKE_DASH_PHASE.set(a, (Double)doubleValue);
            AttributeKeys.IS_STROKE_DASH_FACTOR.set(a, (Boolean)false);
        }
        if ((value = this.readInheritAttribute(elem, "stroke-linecap", null)) != null) {
            AttributeKeys.STROKE_CAP.set(a, SVGConstants.SVG_STROKE_LINECAPS.get(value));
        }
        if ((value = this.readInheritAttribute(elem, "stroke-linejoin", null)) != null) {
            AttributeKeys.STROKE_JOIN.set(a, SVGConstants.SVG_STROKE_LINEJOINS.get(value));
        }
        if ((objectValue = this.readInheritAttribute(elem, "stroke-miterlimit", null)) != null) {
            doubleValue = this.toDouble(elem, (String)objectValue, 4.0, 1.0, Double.MAX_VALUE);
            AttributeKeys.STROKE_MITER_LIMIT.set(a, (Double)doubleValue);
            AttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR.set(a, (Boolean)false);
        }
        if ((objectValue = this.readInheritAttribute(elem, "stroke-opacity", null)) != null) {
            SVGAttributeKeys.STROKE_OPACITY.set(a, (Double)this.toDouble(elem, (String)objectValue, 1.0, 0.0, 1.0));
        }
        if ((objectValue = this.readInheritAttribute(elem, "stroke-width", null)) != null) {
            doubleValue = this.toNumber(elem, (String)objectValue);
            AttributeKeys.STROKE_WIDTH.set(a, (Double)doubleValue);
        }
    }

    private void readLineAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        Object objectValue = this.toPaint(elem, this.readInheritAttribute(elem, "fill", "none"));
        if (objectValue instanceof Color) {
            AttributeKeys.FILL_COLOR.set(a, (Color)objectValue);
        } else if (objectValue instanceof Gradient) {
            SVGAttributeKeys.FILL_GRADIENT.setClone(a, (Gradient)objectValue);
        } else if (objectValue == null) {
            AttributeKeys.FILL_COLOR.set(a, null);
        } else {
            AttributeKeys.FILL_COLOR.set(a, null);
        }
        objectValue = this.readInheritAttribute(elem, "fill-opacity", "1");
        SVGAttributeKeys.FILL_OPACITY.set(a, (Double)this.toDouble(elem, (String)objectValue, 1.0, 0.0, 1.0));
        String value = this.readInheritAttribute(elem, "fill-rule", "nonzero");
        AttributeKeys.WINDING_RULE.set(a, SVGConstants.SVG_FILL_RULES.get(value));
        objectValue = this.toPaint(elem, this.readInheritAttribute(elem, "stroke", "black"));
        if (objectValue instanceof Color) {
            AttributeKeys.STROKE_COLOR.set(a, (Color)objectValue);
        } else if (objectValue instanceof Gradient) {
            SVGAttributeKeys.STROKE_GRADIENT.setClone(a, (Gradient)objectValue);
        } else if (objectValue == null) {
            AttributeKeys.STROKE_COLOR.set(a, null);
        } else {
            AttributeKeys.STROKE_COLOR.set(a, null);
        }
        value = this.readInheritAttribute(elem, "stroke-dasharray", "none");
        if (!value.equals("none")) {
            String[] values = SVGInputFormat.toWSOrCommaSeparatedArray(value);
            double[] dashes = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                dashes[i] = this.toNumber(elem, values[i]);
            }
            AttributeKeys.STROKE_DASHES.set(a, dashes);
        }
        double doubleValue = this.toNumber(elem, this.readInheritAttribute(elem, "stroke-dashoffset", "0"));
        AttributeKeys.STROKE_DASH_PHASE.set(a, (Double)doubleValue);
        AttributeKeys.IS_STROKE_DASH_FACTOR.set(a, (Boolean)false);
        value = this.readInheritAttribute(elem, "stroke-linecap", "butt");
        AttributeKeys.STROKE_CAP.set(a, SVGConstants.SVG_STROKE_LINECAPS.get(value));
        value = this.readInheritAttribute(elem, "stroke-linejoin", "miter");
        AttributeKeys.STROKE_JOIN.set(a, SVGConstants.SVG_STROKE_LINEJOINS.get(value));
        doubleValue = this.toDouble(elem, this.readInheritAttribute(elem, "stroke-miterlimit", "4"), 4.0, 1.0, Double.MAX_VALUE);
        AttributeKeys.STROKE_MITER_LIMIT.set(a, (Double)doubleValue);
        AttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR.set(a, (Boolean)false);
        objectValue = this.readInheritAttribute(elem, "stroke-opacity", "1");
        SVGAttributeKeys.STROKE_OPACITY.set(a, (Double)this.toDouble(elem, (String)objectValue, 1.0, 0.0, 1.0));
        doubleValue = this.toNumber(elem, this.readInheritAttribute(elem, "stroke-width", "1"));
        AttributeKeys.STROKE_WIDTH.set(a, (Double)doubleValue);
    }

    private void readViewportAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        String value = this.readAttribute(elem, "viewport-fill", "none");
        value = this.readAttribute(elem, "viewport-fill-opacity", "1.0");
    }

    private void readGraphicsAttributes(IXMLElement elem, Figure f) throws IOException {
        String value = this.readAttribute(elem, "display", "inline");
        value = this.readInheritAttribute(elem, "image-rendering", "auto");
        value = this.readInheritAttribute(elem, "pointer-events", "visiblePainted");
        value = this.readInheritAttribute(elem, "shape-rendering", "auto");
        value = this.readInheritAttribute(elem, "text-rendering", "auto");
        value = this.readAttribute(elem, "vector-effect", "none");
        value = this.readInheritAttribute(elem, "visibility", null);
    }

    private void readLinearGradientElement(IXMLElement elem) throws IOException {
        String xlink;
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        double x1 = this.toLength(elem, this.readAttribute(elem, "x1", "0"), 0.01);
        double y1 = this.toLength(elem, this.readAttribute(elem, "y1", "0"), 0.01);
        double x2 = this.toLength(elem, this.readAttribute(elem, "x2", "1"), 0.01);
        double y2 = this.toLength(elem, this.readAttribute(elem, "y2", "0"), 0.01);
        boolean isRelativeToFigureBounds = this.readAttribute(elem, "gradientUnits", "objectBoundingBox").equals("objectBoundingBox");
        ArrayList<IXMLElement> stops = elem.getChildrenNamed("stop", "http://www.w3.org/2000/svg");
        if (stops.size() == 0) {
            stops = elem.getChildrenNamed("stop");
        }
        if (stops.size() == 0 && (xlink = this.readAttribute(elem, "xlink:href", "")).startsWith("#") && this.identifiedElements.get(xlink.substring(1)) != null && (stops = this.identifiedElements.get(xlink.substring(1)).getChildrenNamed("stop", "http://www.w3.org/2000/svg")).size() == 0) {
            stops = this.identifiedElements.get(xlink.substring(1)).getChildrenNamed("stop");
        }
        if (stops.size() == 0) {
            // empty if block
        }
        double[] stopOffsets = new double[stops.size()];
        Color[] stopColors = new Color[stops.size()];
        double[] stopOpacities = new double[stops.size()];
        for (int i = 0; i < stops.size(); ++i) {
            IXMLElement stopElem = stops.get(i);
            String offsetStr = this.readAttribute(stopElem, "offset", "0");
            stopOffsets[i] = offsetStr.endsWith("%") ? this.toDouble(stopElem, offsetStr.substring(0, offsetStr.length() - 1), 0.0, 0.0, 100.0) / 100.0 : this.toDouble(stopElem, offsetStr, 0.0, 0.0, 1.0);
            stopColors[i] = this.toColor(stopElem, this.readAttribute(stopElem, "stop-color", "black"));
            if (stopColors[i] == null) {
                stopColors[i] = new Color(0, true);
            }
            stopOpacities[i] = this.toDouble(stopElem, this.readAttribute(stopElem, "stop-opacity", "1"), 1.0, 0.0, 1.0);
        }
        AffineTransform tx = SVGInputFormat.toTransform(elem, this.readAttribute(elem, "gradientTransform", "none"));
        Gradient gradient = this.factory.createLinearGradient(x1, y1, x2, y2, stopOffsets, stopColors, stopOpacities, isRelativeToFigureBounds, tx);
        this.elementObjects.put(elem, gradient);
    }

    private void readRadialGradientElement(IXMLElement elem) throws IOException {
        String xlink;
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(elem, a);
        double cx = this.toLength(elem, this.readAttribute(elem, "cx", "0.5"), 0.01);
        double cy = this.toLength(elem, this.readAttribute(elem, "cy", "0.5"), 0.01);
        double fx = this.toLength(elem, this.readAttribute(elem, "fx", this.readAttribute(elem, "cx", "0.5")), 0.01);
        double fy = this.toLength(elem, this.readAttribute(elem, "fy", this.readAttribute(elem, "cy", "0.5")), 0.01);
        double r = this.toLength(elem, this.readAttribute(elem, "r", "0.5"), 0.01);
        boolean isRelativeToFigureBounds = this.readAttribute(elem, "gradientUnits", "objectBoundingBox").equals("objectBoundingBox");
        ArrayList<IXMLElement> stops = elem.getChildrenNamed("stop", "http://www.w3.org/2000/svg");
        if (stops.size() == 0) {
            stops = elem.getChildrenNamed("stop");
        }
        if (stops.size() == 0 && (xlink = this.readAttribute(elem, "xlink:href", "")).startsWith("#") && this.identifiedElements.get(xlink.substring(1)) != null && (stops = this.identifiedElements.get(xlink.substring(1)).getChildrenNamed("stop", "http://www.w3.org/2000/svg")).size() == 0) {
            stops = this.identifiedElements.get(xlink.substring(1)).getChildrenNamed("stop");
        }
        double[] stopOffsets = new double[stops.size()];
        Color[] stopColors = new Color[stops.size()];
        double[] stopOpacities = new double[stops.size()];
        for (int i = 0; i < stops.size(); ++i) {
            IXMLElement stopElem = stops.get(i);
            String offsetStr = this.readAttribute(stopElem, "offset", "0");
            stopOffsets[i] = offsetStr.endsWith("%") ? this.toDouble(stopElem, offsetStr.substring(0, offsetStr.length() - 1), 0.0, 0.0, 100.0) / 100.0 : this.toDouble(stopElem, offsetStr, 0.0, 0.0, 1.0);
            stopColors[i] = this.toColor(stopElem, this.readAttribute(stopElem, "stop-color", "black"));
            if (stopColors[i] == null) {
                stopColors[i] = new Color(0, true);
            }
            stopOpacities[i] = this.toDouble(stopElem, this.readAttribute(stopElem, "stop-opacity", "1"), 1.0, 0.0, 1.0);
        }
        AffineTransform tx = SVGInputFormat.toTransform(elem, this.readAttribute(elem, "gradientTransform", "none"));
        Gradient gradient = this.factory.createRadialGradient(cx, cy, fx, fy, r, stopOffsets, stopColors, stopOpacities, isRelativeToFigureBounds, tx);
        this.elementObjects.put(elem, gradient);
    }

    private void readFontAttributes(IXMLElement elem, Map<AttributeKey, Object> a) throws IOException {
        String value = this.readInheritAttribute(elem, "font-family", "Dialog");
        AttributeKeys.FONT_FACE.set(a, new Font(value, 0, 12));
        double doubleValue = this.readInheritFontSizeAttribute(elem, "font-size", "medium");
        AttributeKeys.FONT_SIZE.set(a, (Double)doubleValue);
        value = this.readInheritAttribute(elem, "font-style", "normal");
        AttributeKeys.FONT_ITALIC.set(a, (Boolean)value.equals("italic"));
        value = this.readInheritAttribute(elem, "font-variant", "normal");
        value = this.readInheritAttribute(elem, "font-weight", "normal");
        AttributeKeys.FONT_BOLD.set(a, (Boolean)(value.equals("bold") || value.equals("bolder") || value.equals("400") || value.equals("500") || value.equals("600") || value.equals("700") || value.equals("800") || value.equals("900") ? 1 : 0));
        value = this.readAttribute(elem, "text-decoration", "none");
        AttributeKeys.FONT_UNDERLINE.set(a, (Boolean)value.equals("underline"));
    }

    private Object toPaint(IXMLElement elem, String value) throws IOException {
        String str = value;
        if (str == null) {
            return null;
        }
        if ((str = str.trim().toLowerCase()).equals("none")) {
            return null;
        }
        if (str.equals("currentcolor")) {
            String currentColor = this.readInheritAttribute(elem, "color", "black");
            if (currentColor == null || currentColor.trim().toLowerCase().equals("currentColor")) {
                return null;
            }
            return this.toPaint(elem, currentColor);
        }
        if (SVGConstants.SVG_COLORS.containsKey(str)) {
            return SVGConstants.SVG_COLORS.get(str);
        }
        if (str.startsWith("#") && str.length() == 7) {
            return new Color(Integer.decode(str));
        }
        if (str.startsWith("#") && str.length() == 4) {
            int th = Integer.decode(str);
            return new Color(th & 0xF | (th & 0xF) << 4 | (th & 0xF0) << 4 | (th & 0xF0) << 8 | (th & 0xF00) << 8 | (th & 0xF00) << 12);
        }
        if (str.startsWith("rgb")) {
            try {
                StringTokenizer tt = new StringTokenizer(str, "() ,");
                tt.nextToken();
                String r = tt.nextToken();
                String g = tt.nextToken();
                String b = tt.nextToken();
                Color c = new Color(r.endsWith("%") ? (int)((double)Integer.decode(r.substring(0, r.length() - 1)).intValue() * 2.55) : Integer.decode(r), g.endsWith("%") ? (int)((double)Integer.decode(g.substring(0, g.length() - 1)).intValue() * 2.55) : Integer.decode(g), b.endsWith("%") ? (int)((double)Integer.decode(b.substring(0, b.length() - 1)).intValue() * 2.55) : Integer.decode(b));
                return c;
            }
            catch (Exception e) {
                System.out.println("SVGInputFormat.toPaint illegal RGB value " + str);
                e.printStackTrace();
                return null;
            }
        }
        if (str.startsWith("url(")) {
            String href = value.substring(4, value.length() - 1);
            if (this.identifiedElements.containsKey(href.substring(1)) && this.elementObjects.containsKey(this.identifiedElements.get(href.substring(1)))) {
                Object obj = this.elementObjects.get(this.identifiedElements.get(href.substring(1)));
                return obj;
            }
            return null;
        }
        return null;
    }

    private Color toColor(IXMLElement elem, String value) throws IOException {
        String str = value;
        if (str == null) {
            return null;
        }
        if ((str = str.trim().toLowerCase()).equals("currentcolor")) {
            String currentColor = this.readInheritAttribute(elem, "color", "black");
            if (currentColor == null || currentColor.trim().toLowerCase().equals("currentColor")) {
                return null;
            }
            return this.toColor(elem, currentColor);
        }
        if (SVGConstants.SVG_COLORS.containsKey(str)) {
            return SVGConstants.SVG_COLORS.get(str);
        }
        if (str.startsWith("#") && str.length() == 7) {
            return new Color(Integer.decode(str));
        }
        if (str.startsWith("#") && str.length() == 4) {
            int th = Integer.decode(str);
            return new Color(th & 0xF | (th & 0xF) << 4 | (th & 0xF0) << 4 | (th & 0xF0) << 8 | (th & 0xF00) << 8 | (th & 0xF00) << 12);
        }
        if (str.startsWith("rgb")) {
            try {
                StringTokenizer tt = new StringTokenizer(str, "() ,");
                tt.nextToken();
                String r = tt.nextToken();
                String g = tt.nextToken();
                String b = tt.nextToken();
                Color c = new Color(r.endsWith("%") ? (int)((double)Integer.decode(r.substring(0, r.length() - 1)).intValue() * 2.55) : Integer.decode(r), g.endsWith("%") ? (int)((double)Integer.decode(g.substring(0, g.length() - 1)).intValue() * 2.55) : Integer.decode(g), b.endsWith("%") ? (int)((double)Integer.decode(b.substring(0, b.length() - 1)).intValue() * 2.55) : Integer.decode(b));
                return c;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (str.startsWith("url")) {
            return null;
        }
        return null;
    }

    private double toDouble(IXMLElement elem, String value) throws IOException {
        return this.toDouble(elem, value, 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    private double toDouble(IXMLElement elem, String value, double defaultValue, double min, double max) throws IOException {
        try {
            double d = Double.valueOf(value);
            return Math.max(Math.min(d, max), min);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String toText(IXMLElement elem, String value) throws IOException {
        String space = this.readInheritAttribute(elem, "xml:space", "default");
        if (space.equals("default")) {
            return value.trim().replaceAll("\\s++", " ");
        }
        return value;
    }

    public static AffineTransform toTransform(IXMLElement elem, String str) throws IOException {
        AffineTransform t = new AffineTransform();
        if (str != null && !str.equals("none")) {
            StreamPosTokenizer tt = new StreamPosTokenizer(new StringReader(str));
            tt.resetSyntax();
            tt.wordChars(97, 122);
            tt.wordChars(65, 90);
            tt.wordChars(160, 255);
            tt.whitespaceChars(0, 32);
            tt.whitespaceChars(44, 44);
            tt.parseNumbers();
            tt.parseExponents();
            while (tt.nextToken() != -1) {
                if (tt.ttype != -3) {
                    throw new IOException("Illegal transform " + str);
                }
                String type = tt.sval;
                if (tt.nextToken() != 40) {
                    throw new IOException("'(' not found in transform " + str);
                }
                if (type.equals("matrix")) {
                    double[] m = new double[6];
                    for (int i = 0; i < 6; ++i) {
                        if (tt.nextToken() != -2) {
                            throw new IOException("Matrix value " + i + " not found in transform " + str + " token:" + tt.ttype + " " + tt.sval);
                        }
                        m[i] = tt.nval;
                    }
                    t.concatenate(new AffineTransform(m));
                } else if (type.equals("translate")) {
                    double ty;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-translation value not found in transform " + str);
                    }
                    double tx = tt.nval;
                    if (tt.nextToken() == -2) {
                        ty = tt.nval;
                    } else {
                        tt.pushBack();
                        ty = 0.0;
                    }
                    t.translate(tx, ty);
                } else if (type.equals("scale")) {
                    double sy;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-scale value not found in transform " + str);
                    }
                    double sx = tt.nval;
                    if (tt.nextToken() == -2) {
                        sy = tt.nval;
                    } else {
                        tt.pushBack();
                        sy = sx;
                    }
                    t.scale(sx, sy);
                } else if (type.equals("rotate")) {
                    double cy;
                    double cx;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Angle value not found in transform " + str);
                    }
                    double angle = tt.nval;
                    if (tt.nextToken() == -2) {
                        cx = tt.nval;
                        if (tt.nextToken() != -2) {
                            throw new IOException("Y-center value not found in transform " + str);
                        }
                        cy = tt.nval;
                    } else {
                        tt.pushBack();
                        cy = 0.0;
                        cx = 0.0;
                    }
                    t.rotate(angle * Math.PI / 180.0, cx, cy);
                } else if (type.equals("skewX")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t.concatenate(new AffineTransform(1.0, 0.0, Math.tan(angle * Math.PI / 180.0), 1.0, 0.0, 0.0));
                } else if (type.equals("skewY")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t.concatenate(new AffineTransform(1.0, Math.tan(angle * Math.PI / 180.0), 0.0, 1.0, 0.0, 0.0));
                } else {
                    throw new IOException("Unknown transform " + type + " in " + str);
                }
                if (tt.nextToken() == 41) continue;
                throw new IOException("')' not found in transform " + str);
            }
        }
        return t;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Scalable Vector Graphics (SVG)", "svg");
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.url = file.toURL();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.read(in, drawing);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.url = null;
    }

    @Override
    public void read(InputStream in, Drawing drawing) throws IOException {
        drawing.addAll(this.readFigures(in));
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("image") && flavor.getSubType().equals("svg+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Figure> readFigures(Transferable t) throws UnsupportedFlavorException, IOException {
        InputStream in = null;
        try {
            in = (InputStream)t.getTransferData(new DataFlavor("image/svg+xml", "Image SVG"));
            LinkedList<Figure> linkedList = this.readFigures(in);
            return linkedList;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static class Viewport {
        public double width = 640.0;
        public double height = 480.0;
        public Rectangle2D.Double viewBox = new Rectangle2D.Double(0.0, 0.0, 640.0, 480.0);
        public double widthPercentFactor = 6.4;
        public double heightPercentFactor = 4.8;
        public double numberFactor;
        public boolean isPreserveAspectRatio = true;

        private Viewport() {
        }

        public String toString() {
            return "widthPercentFactor:" + this.widthPercentFactor + ";" + "heightPercentFactor:" + this.heightPercentFactor + ";" + "numberFactor:" + this.numberFactor;
        }
    }
}

