/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.util.ArrayList;
import java.util.HashMap;
import ucar.bufr.BufrDataDescriptionSection;
import ucar.bufr.BufrDataSection;
import ucar.bufr.BufrIdentificationSection;
import ucar.bufr.TimeObservation;

final class BufrRecord {
    private final String header;
    private final BufrIdentificationSection ids;
    private final ArrayList dorder;
    private final HashMap bufrdatas;
    private final int datasets;
    private final long offsetDDS;
    private final long[] offset;
    private final int[] oBitPos;
    private final int[] oBitBuf;

    public BufrRecord(String header, BufrIdentificationSection ids, BufrDataDescriptionSection dds, BufrDataSection ds) {
        this.header = header;
        this.ids = ids;
        this.datasets = dds.getNumberDataSets();
        this.offsetDDS = dds.getOffset();
        TimeObservation to = new TimeObservation(dds, ds);
        this.bufrdatas = ds.getBufrDatas();
        this.dorder = ds.getDorder();
        this.offset = ds.getOffset();
        this.oBitPos = ds.getBitPos();
        this.oBitBuf = ds.getBitBuf();
        if (dds.getDataType() == 192 || dds.getDataType() == 64) {
            ids.setCompressed(true);
            this.oBitBuf[0] = dds.getNumberDataSets();
        } else if (dds.getDataType() == 128 || dds.getDataType() == 0) {
            ids.setCompressed(false);
        }
    }

    public final String getHeader() {
        return this.header;
    }

    public final BufrIdentificationSection getIds() {
        return this.ids;
    }

    public final ArrayList getDorder() {
        return this.dorder;
    }

    public final HashMap getBufrDatas() {
        return this.bufrdatas;
    }

    public final int getNumberDatasets() {
        return this.datasets;
    }

    public final long getOffsetDDS() {
        return this.offsetDDS;
    }

    public final long[] getOffset() {
        return this.offset;
    }

    public final int[] getBitPos() {
        return this.oBitPos;
    }

    public final int[] getBitBuf() {
        return this.oBitBuf;
    }
}

