/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

final class Descriptor {
    private final String fxy;
    private int scale;
    private int refVal;
    private int width;
    private String units;
    private final String name;
    private final String description;
    private boolean numeric = true;

    public Descriptor(String key, String scale, String refVal, String width, String uStr, String desc) {
        this.fxy = key;
        this.scale = Integer.parseInt(scale);
        this.refVal = Integer.parseInt(refVal);
        this.width = Integer.parseInt(width);
        uStr = uStr.trim();
        if (uStr.equals("CCITT_IA5")) {
            this.numeric = false;
            this.units = "";
        } else {
            this.units = uStr.equals("Numeric") || uStr.equals("Code_table") || uStr.equals("Flag_table") ? "" : uStr;
        }
        desc = desc.replaceFirst("\\w+\\s+TABLE B ENTRY( - )?", "");
        this.description = desc = desc.trim();
        desc = desc.replaceAll("\\s*\\(.*\\)", "");
        desc = desc.replaceAll("\\*", "");
        desc = desc.replaceAll("\\s+", "_");
        desc = desc.replaceAll("\\/", "_or_");
        desc = desc.replaceFirst("1-", "One-");
        this.name = desc = desc.replaceFirst("2-", "Two-");
    }

    public Descriptor(String f, String x, String y, String scale, String refVal, String width, String uStr, String desc) {
        if (x.length() == 2 && x.startsWith("0")) {
            x = x.substring(1);
        }
        if (y.length() == 3 && y.startsWith("00")) {
            y = y.substring(2);
        } else if (y.length() == 3 && y.startsWith("0")) {
            y = y.substring(1);
        }
        this.fxy = f + "-" + x + "-" + y;
        this.scale = Integer.parseInt(scale);
        this.refVal = Integer.parseInt(refVal);
        this.width = Integer.parseInt(width);
        uStr = uStr.trim();
        if (uStr.equals("CCITT_IA5")) {
            this.numeric = false;
            this.units = "";
        } else {
            this.units = uStr.equals("Numeric") || uStr.equals("Code_Table") || uStr.equals("Flag_Table") ? "" : uStr;
        }
        desc = desc.replaceFirst("\\w+\\s+TABLE B ENTRY( - )?", "");
        this.description = desc = desc.trim();
        desc = desc.replaceAll("\\s*\\(.*\\)", "");
        desc = desc.replaceAll("\\*", "");
        desc = desc.replaceAll("\\s+", "_");
        desc = desc.replaceAll("\\/", "_or_");
        desc = desc.replaceFirst("1-", "One-");
        this.name = desc = desc.replaceFirst("2-", "Two-");
    }

    public Descriptor(String f, String x, String y, String scaleSign, String scale, String refSign, String refVal, String width, String uStr, String desc) {
        if (x.length() == 2 && x.startsWith("0")) {
            x = x.substring(1);
        }
        if (y.length() == 3 && y.startsWith("00")) {
            y = y.substring(2);
        } else if (y.length() == 3 && y.startsWith("0")) {
            y = y.substring(1);
        }
        this.fxy = f + "-" + x + "-" + y;
        this.scale = Integer.parseInt(scale.trim());
        if (scaleSign.startsWith("-")) {
            this.scale *= -1;
        }
        this.refVal = Integer.parseInt(refVal.trim());
        if (refSign.startsWith("-")) {
            this.refVal *= -1;
        }
        this.width = Integer.parseInt(width.trim());
        if ((uStr = uStr.trim()).equals("CCITT_IA5") || uStr.equals("CCITT IA5")) {
            this.numeric = false;
            this.units = "";
        } else {
            this.units = uStr.equals("Numeric") || uStr.equals("Code_Table") || uStr.equals("Flag_Table") ? "" : uStr;
        }
        desc = desc.replaceFirst("\\w+\\s+TABLE B ENTRY( - )?", "");
        desc = desc.toLowerCase();
        this.description = desc = desc.trim();
        desc = desc.replaceAll("\\s*\\(.*\\)", "");
        desc = desc.replaceAll("\\*", "");
        desc = desc.replaceAll("\\s+", "_");
        desc = desc.replaceAll("\\/", "_or_");
        desc = desc.replaceFirst("1-", "One-");
        this.name = desc = desc.replaceFirst("2-", "Two-");
    }

    public final String getKey() {
        return this.fxy;
    }

    public final int getScale() {
        return this.scale;
    }

    public final int getRefVal() {
        return this.refVal;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final String getUnits() {
        return this.units;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isNumeric() {
        return this.numeric;
    }

    public final void setUnits(String units) {
        this.units = units;
    }
}

