/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenericIllegalRegexpCheck
extends AbstractFormatCheck {
    private String mMessage = "";
    private boolean mIgnoreComments;

    public void setMessage(String aMessage) {
        if (aMessage == null) {
            aMessage = "";
        }
        this.mMessage = aMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setIgnoreCase(boolean aCaseInsensitive) {
        if (aCaseInsensitive) {
            this.setCompileFlags(2);
        }
    }

    public void setIgnoreComments(boolean aIgnoreComments) {
        this.mIgnoreComments = aIgnoreComments;
    }

    public GenericIllegalRegexpCheck() {
        super("$^");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            boolean foundMatch = this.mIgnoreComments ? this.findNonCommentMatch(line, i + 1, 0) : this.getRegexp().matcher(line).find();
            if (!foundMatch) continue;
            if ("".equals(this.mMessage)) {
                this.log(i + 1, "illegal.regexp", (Object)this.getFormat());
                continue;
            }
            this.log(i + 1, this.mMessage);
        }
    }

    private boolean findNonCommentMatch(String aLine, int aLineNumber, int aStartPosition) {
        Pattern pattern = this.getRegexp();
        Matcher matcher = pattern.matcher(aLine);
        boolean foundMatch = matcher.find(aStartPosition);
        if (!foundMatch) {
            return false;
        }
        int startCol = matcher.start(0);
        int endCol = matcher.end(0);
        boolean intersectsWithComment = this.getFileContents().hasIntersectionWithComment(aLineNumber, startCol, aLineNumber, endCol - 1);
        if (intersectsWithComment) {
            if (endCol < aLine.length()) {
                return this.findNonCommentMatch(aLine, aLineNumber, endCol);
            }
            return false;
        }
        return true;
    }
}

