/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Ensemble {
    private int eType;
    private int eId;
    private int eProd;
    private int eSpatial;
    private int epd;
    private int ept;
    private int epll;
    private int epul;
    private int eSize;
    private int eCSize;
    private int eCNumber;
    private int eCMethod;
    private int nLat;
    private int sLat;
    private int eLat;
    private int wLat;
    private byte[] cm = null;

    public Grib1Ensemble(RandomAccessFile raf, int parameterNumber) throws IOException {
        raf.skipBytes(12);
        int app = raf.read();
        if (app != 1) {
            System.out.println("not ensemble product");
            return;
        }
        this.eType = raf.read();
        this.eId = raf.read();
        this.eProd = raf.read();
        this.eSpatial = raf.read();
        if (parameterNumber == 191 || parameterNumber == 192) {
            this.epd = raf.read();
            this.ept = raf.read();
            this.epll = raf.readInt();
            this.epul = raf.readInt();
            int reserved = raf.readInt();
            if (this.eType == 4 || this.eType == 5) {
                this.eSize = raf.read();
                this.eCSize = raf.read();
                this.eCNumber = raf.read();
                this.eCMethod = raf.read();
                this.nLat = GribNumbers.int3(raf);
                this.sLat = GribNumbers.int3(raf);
                this.eLat = GribNumbers.int3(raf);
                this.wLat = GribNumbers.int3(raf);
                if (this.eType == 4) {
                    this.cm = new byte[10];
                    raf.read(this.cm);
                }
            }
        }
    }
}

