/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.util.JDBCExceptionReporter;

class SuppliedConnectionHelper
implements ConnectionHelper {
    private Connection connection;
    private boolean toggleAutoCommit;

    public SuppliedConnectionHelper(Connection connection) {
        this.connection = connection;
    }

    public void prepare(boolean needsAutoCommit) throws SQLException {
        boolean bl = this.toggleAutoCommit = needsAutoCommit && !this.connection.getAutoCommit();
        if (this.toggleAutoCommit) {
            try {
                this.connection.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection.setAutoCommit(true);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void release() throws SQLException {
        JDBCExceptionReporter.logAndClearWarnings(this.connection);
        if (this.toggleAutoCommit) {
            this.connection.setAutoCommit(false);
        }
        this.connection = null;
    }
}

