/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class PriorityMatcher
implements Matcher {
    private int priority;

    public String toString() {
        return "priority==" + this.priority;
    }

    public PriorityMatcher(String priorityAsString) {
        this.priority = Integer.parseInt(priorityAsString);
    }

    public int hashCode() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PriorityMatcher)) {
            return false;
        }
        PriorityMatcher other = (PriorityMatcher)o;
        return this.priority == other.priority;
    }

    public boolean match(BugInstance bugInstance) {
        return bugInstance.getPriority() == this.priority;
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("value", Integer.toString(this.priority));
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Priority", attributes);
    }
}

