/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import ucar.grib.Index;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Indexer {
    public final Index writeFileIndex(RandomAccessFile inputRaf, PrintStream ps, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        long start = System.currentTimeMillis();
        int count = 0;
        Index index = makeIndex ? new Index() : null;
        try {
            inputRaf.seek(0L);
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            ps.println("index_version = 4.0");
            ps.println("grid_edition = 2");
            ps.println("location = " + inputRaf.getLocation());
            ps.println("length = " + inputRaf.length());
            ps.println("created = " + dateFormat.format(now));
            if (makeIndex) {
                index.addGlobalAttribute("length", Long.toString(inputRaf.length()));
                index.addGlobalAttribute("location", inputRaf.getLocation());
                index.addGlobalAttribute("created", dateFormat.format(now));
            }
            ArrayList products = g2i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = (Grib2Product)products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    ps.println("center = " + id.getCenter_id());
                    ps.println("sub_center = " + id.getSubcenter_id());
                    ps.println("table_version = " + id.getLocal_table_version());
                    ps.println("--------------------------------------------------------------------");
                }
                ps.println(pds.getProductDefinition() + " " + product.getDiscipline() + " " + pds.getParameterCategory() + " " + pds.getParameterNumber() + " " + pds.getTypeGenProcess() + " " + pds.getTypeFirstFixedSurface() + " " + pds.getValueFirstFixedSurface() + " " + pds.getTypeSecondFixedSurface() + " " + pds.getValueSecondFixedSurface() + " " + product.getReferenceTime() + " " + pds.getForecastTime() + " " + product.getGDSkey() + " " + product.getGdsOffset() + " " + product.getPdsOffset());
                if (makeIndex) {
                    index.addGribRecord(Grib2Indexer.makeGribRecord(index, product));
                }
                ++count;
            }
            HashMap gdsHM = g2i.getGDSs();
            Iterator it = gdsHM.keySet().iterator();
            while (it.hasNext()) {
                ps.println("--------------------------------------------------------------------");
                String key = (String)it.next();
                ps.println("GDSkey = " + key);
                Grib2GridDefinitionSection gds = (Grib2GridDefinitionSection)gdsHM.get(key);
                this.printGDS(gds, ps);
                if (!makeIndex) continue;
                index.addHorizCoordSys(Grib2Indexer.makeGdsRecord(gds));
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        ps.close();
        return index;
    }

    protected static final Index.GribRecord makeGribRecord(Index index, Grib2Product product) {
        Index.GribRecord gr = index.getGribRecord();
        Grib2ProductDefinitionSection pds = product.getPDS();
        gr.productType = pds.getProductDefinition();
        gr.discipline = product.getDiscipline();
        gr.category = pds.getParameterCategory();
        gr.paramNumber = pds.getParameterNumber();
        gr.typeGenProcess = pds.getTypeGenProcess();
        gr.levelType1 = pds.getTypeFirstFixedSurface();
        gr.levelValue1 = pds.getValueFirstFixedSurface();
        gr.levelType2 = pds.getTypeSecondFixedSurface();
        gr.levelValue2 = pds.getValueSecondFixedSurface();
        gr.refTime = product.getReferenceTime().toString();
        gr.forecastTime = pds.getForecastTime();
        gr.gdsKey = product.getGDSkey().trim();
        gr.offset1 = product.getGdsOffset();
        gr.offset2 = product.getPdsOffset();
        return gr;
    }

    protected static final Index.GdsRecord makeGdsRecord(Grib2GridDefinitionSection gds) {
        String winds;
        Index.GdsRecord igds = new Index.GdsRecord();
        igds.gdsKey = gds.getCheckSum();
        igds.addParam("GDSkey", gds.getCheckSum());
        String string = winds = (gds.getResolution() & 8) == 0 ? "Relative" : "True";
        if ((gds.getGdtn() < 50 || gds.getGdtn() > 53) && gds.getGdtn() != 100 && gds.getGdtn() != 120 && gds.getGdtn() != 1200) {
            igds.grid_shape_code = gds.getShape();
            igds.addParam("grid_shape_code", Integer.toString(gds.getShape()));
            igds.grid_type = gds.getGdtn();
            igds.addParam("grid_type", Integer.toString(gds.getGdtn()));
            igds.addParam("grid_shape", gds.getShapeName());
            if (gds.getShape() < 2 || gds.getShape() == 6) {
                igds.radius_spherical_earth = gds.getEarthRadius();
                igds.addParam("radius_spherical_earth", Double.toString(gds.getEarthRadius()));
            } else if (gds.getShape() > 1 && gds.getShape() < 5) {
                igds.major_axis_earth = gds.getMajorAxis();
                igds.addParam("major_axis_earth", Double.toString(gds.getMajorAxis()));
                igds.minor_axis_earth = gds.getMinorAxis();
                igds.addParam("minor_axis_earth", Double.toString(gds.getMinorAxis()));
            }
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                igds.winds = winds;
                igds.addParam("La2", Double.toString(gds.getLa2()));
                igds.addParam("Lo2", Double.toString(gds.getLo2()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                if (gds.getGdtn() == 1) {
                    igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                    igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                    break;
                }
                if (gds.getGdtn() == 2) {
                    igds.addParam("pLat", Double.toString(gds.getPoleLat()));
                    igds.addParam("pLon", Double.toString(gds.getPoleLon()));
                    break;
                }
                if (gds.getGdtn() != 3) break;
                igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                break;
            }
            case 10: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                igds.winds = winds;
                igds.addParam("La2", Double.toString(gds.getLa2()));
                igds.addParam("Lo2", Double.toString(gds.getLo2()));
                igds.addParam("Angle", Double.toString(gds.getAngle()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                break;
            }
            case 20: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                String NpProj = (gds.getProjectionCenter() & 0x80) == 0 ? "true" : "false";
                igds.addParam("NpProj", NpProj);
                igds.winds = winds;
                igds.LaD = gds.getLad();
                igds.addParam("Lad", Double.toString(gds.getLad()));
                igds.LoV = gds.getLov();
                igds.addParam("Lov", Double.toString(gds.getLov()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                break;
            }
            case 30: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                String NpProj = (gds.getProjectionCenter() & 0x80) == 0 ? "true" : "false";
                igds.addParam("NpProj", NpProj);
                igds.winds = winds;
                igds.LaD = gds.getLad();
                igds.addParam("Lad", Double.toString(gds.getLad()));
                igds.LoV = gds.getLov();
                igds.addParam("Lov", Double.toString(gds.getLov()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                igds.latin1 = gds.getLatin1();
                igds.addParam("Latin1", Double.toString(gds.getLatin1()));
                igds.latin2 = gds.getLatin2();
                igds.addParam("Latin2", Double.toString(gds.getLatin2()));
                igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                break;
            }
            case 31: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                String NpProj = (gds.getProjectionCenter() & 0x80) == 0 ? "true" : "false";
                igds.addParam("NpProj", NpProj);
                igds.winds = winds;
                igds.LaD = gds.getLad();
                igds.addParam("Lad", Double.toString(gds.getLad()));
                igds.LoV = gds.getLov();
                igds.addParam("Lov", Double.toString(gds.getLov()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                igds.latin1 = gds.getLatin1();
                igds.addParam("Latin1", Double.toString(gds.getLatin1()));
                igds.latin2 = gds.getLatin2();
                igds.addParam("Latin2", Double.toString(gds.getLatin2()));
                igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                igds.winds = winds;
                igds.addParam("La2", Double.toString(gds.getLa2()));
                igds.addParam("Lo2", Double.toString(gds.getLo2()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.addParam("NumberParallels", Double.toString(gds.getN()));
                if (gds.getGdtn() == 41) {
                    igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                    igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                    break;
                }
                if (gds.getGdtn() == 42) {
                    igds.addParam("pLat", Double.toString(gds.getPoleLat()));
                    igds.addParam("pLon", Double.toString(gds.getPoleLon()));
                    break;
                }
                if (gds.getGdtn() != 43) break;
                igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                igds.addParam("Angle", Double.toString(gds.getAngle()));
                igds.addParam("pLat", Double.toString(gds.getPoleLat()));
                igds.addParam("pLon", Double.toString(gds.getPoleLon()));
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 90: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.addParam("Lap", Double.toString(gds.getLap()));
                igds.addParam("Lop", Double.toString(gds.getLop()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                igds.winds = winds;
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                igds.addParam("Xp", Double.toString(gds.getXp()));
                igds.addParam("Yp", Double.toString(gds.getYp()));
                igds.addParam("Angle", Double.toString(gds.getAngle()));
                igds.addParam("Nr", Double.toString(gds.getAltitude()));
                igds.addParam("Xo", Double.toString(gds.getXo()));
                igds.addParam("Yo", Double.toString(gds.getYo()));
                break;
            }
            case 100: {
                igds.addParam("pLat", Double.toString(gds.getPoleLat()));
                igds.addParam("pLon", Double.toString(gds.getPoleLon()));
                break;
            }
            case 110: {
                igds.nx = gds.getNx();
                igds.addParam("Nx", Integer.toString(gds.getNx()));
                igds.ny = gds.getNy();
                igds.addParam("Ny", Integer.toString(gds.getNy()));
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.resolution = gds.getResolution();
                igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
                String NpProj = (gds.getProjectionCenter() & 0x80) == 0 ? "true" : "false";
                igds.addParam("NpProj", NpProj);
                igds.winds = winds;
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.dy = gds.getDy();
                igds.addParam("Dy", Double.toString(gds.getDy()));
                break;
            }
            case 120: {
                igds.La1 = gds.getLa1();
                igds.addParam("La1", Double.toString(gds.getLa1()));
                igds.Lo1 = gds.getLo1();
                igds.addParam("Lo1", Double.toString(gds.getLo1()));
                igds.dx = gds.getDx();
                igds.addParam("Dx", Double.toString(gds.getDx()));
            }
        }
        return igds;
    }

    public void printGDS(Grib2GridDefinitionSection gds, PrintStream ps) {
        String winds;
        ps.println("grid_type = " + gds.getGdtn());
        ps.println("grid_name = " + gds.getName());
        String string = winds = (gds.getResolution() & 8) == 0 ? "Relative" : "True";
        if ((gds.getGdtn() < 50 || gds.getGdtn() > 53) && gds.getGdtn() != 100 && gds.getGdtn() != 120 && gds.getGdtn() != 1200) {
            ps.println("grid_shape_code = " + gds.getShape());
            ps.println("grid_shape = " + gds.getShapeName());
            if (gds.getShape() < 2 || gds.getShape() == 6) {
                ps.println("radius_spherical_earth = " + gds.getEarthRadius());
            } else if (gds.getShape() > 1 && gds.getShape() < 5) {
                ps.println("major_axis_earth = " + gds.getMajorAxis());
                ps.println("minor_axis_earth = " + gds.getMinorAxis());
            }
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Winds = " + winds);
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ScanningMode = " + gds.getScanMode());
                if (gds.getGdtn() == 1) {
                    ps.println("SpLat = " + gds.getSpLat());
                    ps.println("SpLon = " + gds.getSpLon());
                    ps.println("RotationAngle = " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 2) {
                    ps.println("pLat = " + gds.getPoleLat());
                    ps.println("pLon = " + gds.getPoleLon());
                    ps.println("StretchingFactor = " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 3) break;
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                ps.println("RotationAngle = " + gds.getRotationangle());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("StretchingFactor = " + gds.getFactor());
                break;
            }
            case 10: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Winds = " + winds);
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("BasicAngle = " + gds.getAngle());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                break;
            }
            case 20: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Winds = " + winds);
                ps.println("LaD = " + gds.getLad());
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("NpProj = " + ((gds.getProjectionCenter() & 0x80) == 0));
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            case 30: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Winds = " + winds);
                ps.println("LaD = " + gds.getLad());
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("NpProj = " + ((gds.getProjectionCenter() & 0x80) == 0));
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Latin1 = " + gds.getLatin1());
                ps.println("Latin2 = " + gds.getLatin2());
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Winds = " + winds);
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Dx = " + gds.getDx());
                ps.println("StretchingFactor = " + gds.getFactor());
                ps.println("NumberParallels = " + gds.getN());
                ps.println("ScanningMode = " + gds.getScanMode());
                if (gds.getGdtn() == 41) {
                    ps.println("SpLat = " + gds.getSpLat());
                    ps.println("SpLon = " + gds.getSpLon());
                    ps.println("RotationAngle = " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 42) {
                    ps.println("pLat = " + gds.getPoleLat());
                    ps.println("pLon = " + gds.getPoleLon());
                    ps.println("StretchingFactor = " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 43) break;
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                ps.println("RotationAngle = " + gds.getRotationangle());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("StretchingFactor = " + gds.getFactor());
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                ps.println("J = " + gds.getJ());
                ps.println("K = " + gds.getK());
                ps.println("M = " + gds.getM());
                ps.println("MethodNorm = " + gds.getMethod());
                ps.println("ModeOrder = " + gds.getMode());
                if (gds.getGdtn() == 51) {
                    ps.println("SpLat = " + gds.getSpLat());
                    ps.println("SpLon = " + gds.getSpLon());
                    ps.println("RotationAngle = " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 52) {
                    ps.println("pLat = " + gds.getPoleLat());
                    ps.println("pLon = " + gds.getPoleLon());
                    ps.println("StretchingFactor = " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 53) break;
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                ps.println("RotationAngle = " + gds.getRotationangle());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("StretchingFactor = " + gds.getFactor());
                break;
            }
            case 90: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("Lap = " + gds.getLap());
                ps.println("Lop = " + gds.getLop());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Winds = " + winds);
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("Xp = " + gds.getXp());
                ps.println("Yp = " + gds.getYp());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Angle = " + gds.getAngle());
                ps.println("Nr = " + gds.getAltitude());
                ps.println("Xo = " + gds.getXo());
                ps.println("Yo = " + gds.getYo());
                break;
            }
            case 100: {
                ps.println("Exponent2Intervals = " + gds.getN2());
                ps.println("Exponent3Intervals = " + gds.getN3());
                ps.println("NumberIntervals = " + gds.getNi());
                ps.println("NumberDiamonds = " + gds.getNd());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("GridPointPosition = " + gds.getPosition());
                ps.println("NumberOrderDiamonds = " + gds.getOrder());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("NumberParallels = " + gds.getN());
                break;
            }
            case 110: {
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("NpProj = " + ((gds.getProjectionCenter() & 0x80) == 0));
                ps.println("Winds = " + winds);
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            case 120: {
                ps.println("NumberDataBins = " + gds.getNb());
                ps.println("NumberRadials = " + gds.getNr());
                ps.println("NumberPointsParallel = " + gds.getNx());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("Dx = " + gds.getDx());
                ps.println("OffsetFromOrigin = " + gds.getDstart());
                break;
            }
            default: {
                ps.println("Unknown Grid Type" + gds.getGdtn());
            }
        }
        if (gds.getOlon() == 0) {
            ps.println("Quasi = false");
        } else {
            ps.println("Quasi = true");
        }
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans for index");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib2Indexer indexer = new Grib2Indexer();
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib2Indexer.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        if (args.length == 2) {
            String idxfile = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            File idx = new File(idxfile);
            idxfile = idxfile + ".tmp";
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(idxfile, false)));
            indexer.writeFileIndex(raf, ps, false);
            ps.close();
            File tidx = new File(idxfile);
            tidx.renameTo(idx);
        } else if (args.length == 1) {
            ps = System.out;
            indexer.writeFileIndex(raf, ps, true);
        }
    }
}

