/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import ome.xml.model.Experimenter;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;

public class ImportUserData {
    private GroupData group;
    private String name;
    private ExperimenterData experimenter;

    public ImportUserData(GroupData group, DataObject parent, ExperimenterData experimenter) {
        this.group = group;
        if (parent instanceof ProjectData) {
            this.name = parent.asProject().getName().getValue();
        } else if (parent instanceof ScreenData) {
            this.name = parent.asScreen().getName().getValue();
        }
        this.experimenter = experimenter;
    }

    public String getGroup() {
        return this.group.getName();
    }

    public String getProject() {
        return this.name;
    }

    public Experimenter getUser() {
        Experimenter e = new Experimenter();
        e.setFirstName(this.experimenter.getFirstName());
        e.setLastName(this.experimenter.getLastName());
        return e;
    }

    public String getUserName() {
        return this.experimenter.getLastName();
    }

    public String[] getUserFullName() {
        String[] name = new String[]{this.experimenter.getFirstName(), this.experimenter.getLastName()};
        return name;
    }
}

