/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import com.google.common.collect.ArrayListMultimap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.ShapeData;
import omero.gateway.model.TagAnnotationData;
import omero.log.LogMessage;
import omero.log.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.events.measurement.ROIEvent;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.FileMap;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.data.views.calls.ROIFolderSaver;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class MeasurementViewerComponent
extends AbstractComponent
implements MeasurementViewer {
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private MeasurementViewerUI view;

    private void postEvent(int index) {
        MeasurementToolLoaded response = new MeasurementToolLoaded(MeasurementViewerFactory.getRequest(this.model.getPixelsID()), this.model.getSecurityContext(), (JComponent)((Object)this.model.getDrawingView()), index);
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        bus.post(response);
    }

    private FileChooser createChooserDialog(int type) {
        String word = "Save ";
        if (type == 0) {
            word = "Load ";
        }
        String title = word + "the ROI File";
        String text = word + "the ROI data in the file associated with the image.";
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        filters.add(new XMLFilter());
        FileChooser chooser = new FileChooser(this.view, type, title, text, filters, false, true);
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        try {
            String s = FileMap.getSavedFile(this.model.getServerName(), this.model.getUserName(), this.model.getPixelsID());
            if (s != null) {
                File savedFile = new File(s);
                chooser.setCurrentDirectory(savedFile);
                chooser.setSelectedFile(savedFile);
            } else if (type == 1) {
                s = this.model.getImageName();
                File savedFile = new File(s);
                chooser.setSelectedFile(savedFile.getName());
            }
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        return chooser;
    }

    MeasurementViewerComponent(MeasurementViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MeasurementViewerControl();
        this.view = new MeasurementViewerUI(model.getImageTitle());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this, this.controller, this.model);
    }

    MeasurementViewerModel getModel() {
        return this.model;
    }

    void saveAndDiscard() {
        this.model.saveROIToServer(false, false);
        this.discard();
    }

    void onROIDeleted(long imageID) {
        this.model.onROIDeleted(imageID);
        this.fireStateChange();
    }

    @Override
    public void activate() {
        this.activate(this.model.getMeasurements(), this.model.isHCSData(), this.model.isBigImage());
    }

    @Override
    public void activate(List<FileAnnotationData> measurements, boolean HCSData, boolean isBigImage) {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                double f = this.model.getMagnification();
                Dimension d = new Dimension((int)((double)this.model.getSizeX() * f), (int)((double)this.model.getSizeY() * f));
                UIUtilities.setDefaultSize((Component)((Object)this.model.getDrawingView()), d);
                this.model.getDrawingView().setSize(d);
                this.model.setHCSData(HCSData);
                this.model.setBigImage(isBigImage);
                this.view.buildGUI();
                if (HCSData) {
                    if (measurements == null) {
                        this.model.setHCSData(false);
                        this.model.fireLoadROIServerOrClient(false);
                        break;
                    }
                    this.model.fireLoadROIFromServer(measurements);
                    break;
                }
                this.model.fireLoadROIServerOrClient(false);
                break;
            }
            case 6: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (!this.view.isVisible()) {
                    this.postEvent(0);
                }
                this.view.deIconify();
                this.view.setVisible(true);
            }
        }
    }

    @Override
    public JFrame getUI() {
        return this.view;
    }

    @Override
    public void discard() {
        if (this.model.getState() != 6) {
            this.view.setVisible(false);
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public void setDataChanged() {
        this.model.notifyDataChanged(true);
        this.firePropertyChange("roiChanged", false, true);
        this.fireStateChange();
    }

    @Override
    public void cancel() {
        this.model.cancel();
        this.view.setReadyStatus();
        this.fireStateChange();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void setROI(InputStream input) {
        block9: {
            if (this.model.getState() != 3) {
                return;
            }
            if (input == null) {
                this.model.setState(5);
                this.view.refreshToolBar();
                this.view.rebuildManagerTable();
                this.view.updateDrawingArea();
                this.view.setReadyStatus();
                this.fireStateChange();
                this.postEvent(0);
                return;
            }
            Registry reg = MeasurementAgent.getRegistry();
            Logger log = reg.getLogger();
            try {
                boolean valid = this.model.setROI(input);
                if (valid) break block9;
                reg.getUserNotifier().notifyInfo("ROI", "The ROI are not compatible with the image.");
                try {
                    input.close();
                }
                catch (Exception io) {
                    log.warn((Object)this, "Cannot close the stream " + io.getMessage());
                }
                this.fireStateChange();
                return;
            }
            catch (Exception e) {
                if (e instanceof ParsingException) {
                    log.error((Object)this, "Cannot parse the ROI for " + this.model.getImageID());
                }
                try {
                    input.close();
                }
                catch (Exception io) {
                    log.warn((Object)this, "Cannot close the stream " + io.getMessage());
                }
                return;
            }
        }
        this.view.refreshToolBar();
        this.view.rebuildManagerTable();
        this.view.updateDrawingArea();
        this.view.setReadyStatus();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public void setMagnifiedPlane(int defaultZ, int defaultT, double magnification) {
        int z = this.model.getDefaultZ();
        int t = this.model.getDefaultT();
        double f = this.model.getMagnification();
        if (z == defaultZ && t == defaultT) {
            if (f != magnification) {
                this.model.setMagnification(magnification);
                this.view.onMagnificationChanged();
            }
            if (!this.model.isBigImage()) {
                return;
            }
        }
        this.model.setPlane(defaultZ, defaultT);
        Drawing drawing = this.model.getDrawing();
        drawing.removeDrawingListener((DrawingListener)this.controller);
        drawing.clear();
        ShapeList list = null;
        try {
            list = this.model.getShapeList();
        }
        catch (Exception e) {
            this.view.handleROIException(e, "Cannot retrieve the ROI");
        }
        this.view.setStatus("");
        if (list != null) {
            TreeMap<Long, ROIShape> map = list.getList();
            for (ROIShape shape : map.values()) {
                if (shape == null) continue;
                ROIFigure fig = shape.getFigure();
                drawing.add((Figure)fig);
                if (!fig.canAnnotate()) continue;
                fig.addFigureListener(this.controller);
            }
        }
        this.view.displayAnalysisResults();
        this.model.getDrawingView().setDrawing(drawing);
        drawing.addDrawingListener((DrawingListener)this.controller);
        if (f != magnification) {
            this.model.setMagnification(magnification);
        }
    }

    @Override
    public void close() {
        if (this.model.getState() == 6) {
            return;
        }
        this.postEvent(1);
        if (this.model.isHCSData()) {
            List<FileAnnotationData> list = this.model.getMeasurements();
            if (list == null || list.size() == 0) {
                this.view.setVisible(false);
            } else {
                this.discard();
            }
        } else {
            this.view.setVisible(false);
        }
    }

    @Override
    public void iconified(boolean b) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method shouldn't be invoked in the DISCARDED state:" + this.model.getState());
        }
        this.view.setVisible(b);
    }

    @Override
    public void loadROI() {
        FileChooser chooser = this.createChooserDialog(0);
        chooser.setCheckOverride(false);
        if (chooser.showDialog() != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.model.fireROILoading(f.getAbsolutePath());
        this.fireStateChange();
    }

    @Override
    public void saveROI() {
        FileChooser chooser = this.createChooserDialog(1);
        if (chooser.showDialog() != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String s = file.getAbsolutePath();
        if (s == null || s.trim().length() == 0) {
            return;
        }
        if (!s.endsWith("xml")) {
            String fileName = s + ".xml";
            file = new File(fileName);
        }
        this.saveBackROI(file.getAbsolutePath());
    }

    @Override
    public void saveROIToServer(boolean close) {
        if (!this.canAnnotate()) {
            return;
        }
        List<ROI> l = this.model.getROIToDelete();
        if (l != null && l.size() > 0) {
            ArrayList<DeletableObject> objects = new ArrayList<DeletableObject>();
            Iterator<ROI> i = l.iterator();
            SecurityContext ctx = this.model.getSecurityContext();
            while (i.hasNext()) {
                ROI roi = i.next();
                if (roi.isClientSide() || !roi.canDelete()) continue;
                ROIData data = new ROIData();
                data.setId(roi.getID());
                data.setImage(this.model.getImage().asImage());
                DeletableObject d = new DeletableObject(data);
                d.setSecurityContext(ctx);
                objects.add(d);
            }
            if (objects.size() == 0) {
                this.model.saveROIToServer(true, close);
            } else {
                this.model.deleteAllROIs(objects);
            }
        } else {
            this.model.saveROIToServer(true, close);
        }
        this.fireStateChange();
    }

    @Override
    public void figureAttributeChanged(AttributeKey key, ROIFigure figure) {
        this.model.figureAttributeChanged(key, figure);
    }

    @Override
    public void showROIAssistant() {
        this.view.showROIAssistant();
    }

    @Override
    public void showROIAssistant(ROI roi) {
        this.view.showROIAssistant(roi);
    }

    @Override
    public void showMeasurementsInMicrons(boolean inMicrons) {
        this.model.showMeasurementsInMicrons(inMicrons);
        this.view.updateDrawingArea();
        this.view.refreshResultsTable();
    }

    @Override
    public void setActiveChannels(Map activeChannels) {
        TreeMap<Coord3D, ROIShape> shapeMap;
        ROI roi;
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(activeChannels);
        TreeMap rois = this.model.getROI();
        Collection figures = this.model.getAllFigures();
        if (rois != null) {
            for (Map.Entry entry : rois.entrySet()) {
                roi = (ROI)entry.getValue();
                shapeMap = roi.getShapes();
                for (Map.Entry<Coord3D, ROIShape> entry2 : shapeMap.entrySet()) {
                    ROIShape shape = entry2.getValue();
                    Coord3D coord = shape.getCoord3D();
                    ROIFigure f = shape.getFigure();
                    int c = coord.getChannel();
                    if (c < 0 || !f.canAnnotate()) continue;
                    f.removeFigureListener(this.controller);
                    f.setVisible(this.model.isChannelActive(c));
                    f.addFigureListener(this.controller);
                }
            }
            this.view.repaint();
        }
        if (!this.view.inDataView() || !this.view.isVisible()) {
            return;
        }
        figures = this.getSelectedFigures();
        if (figures.size() != 1) {
            return;
        }
        ROIFigure figure = (ROIFigure)figures.iterator().next();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        roi = figure.getROI();
        shapeMap = roi.getShapes();
        for (Map.Entry<Coord3D, ROIShape> entry : shapeMap.entrySet()) {
            shapeList.add(entry.getValue());
        }
        if (shapeList.size() != 0) {
            this.analyseShapeList(shapeList);
        }
    }

    @Override
    public void setActiveChannelsColor(Map channels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(channels);
        if (!this.view.inDataView() || !this.view.isVisible()) {
            return;
        }
        Collection collection = this.getSelectedFigures();
        if (collection.size() != 1) {
            return;
        }
        ROIFigure figure = (ROIFigure)collection.iterator().next();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = figure.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() != 0) {
            this.analyseShapeList(shapeList);
        }
    }

    @Override
    public void setStatsShapes(Map result) {
        int state = this.model.getState();
        if (state != 4) {
            MeasurementAgent.getRegistry().getLogger().debug((Object)this, "This method can only be invoked in the ANALYSE_SHAPE state: " + state);
            return;
        }
        this.model.setAnalysisResults(result);
        this.view.displayAnalysisResults();
        this.fireStateChange();
    }

    @Override
    public void analyseShapeList(List<ROIShape> shapeList) {
        if (shapeList == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA or LOADING_ROI state: " + state);
            }
            case 4: {
                return;
            }
        }
        if (!this.validShapeList(shapeList)) {
            return;
        }
        if (this.model.getActiveChannels().size() == 0) {
            this.model.setAnalysisResults(null);
            this.view.displayAnalysisResults();
        } else {
            this.model.fireAnalyzeShape(shapeList);
            this.fireStateChange();
        }
    }

    private boolean validShapeList(List<ROIShape> shapeList) {
        for (ROIShape shape : shapeList) {
            if (!(shape.getFigure() instanceof MeasureTextFigure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection getSelectedFigures() {
        return this.model.getSelectedFigures();
    }

    @Override
    public void createSingleFigure(boolean createSingleFig) {
        this.view.createSingleFigure(createSingleFig);
    }

    private void saveBackROI(String path) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.saveROI(path, false);
        }
        catch (ParsingException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        un.notifyInfo("Save ROI", "The Regions of Interests have been successfully saved. ");
        this.firePropertyChange("roiChanged", false, true);
    }

    @Override
    public void toFront() {
        if (this.model.getState() == 6) {
            return;
        }
        this.controller.toFront();
    }

    @Override
    public void setIconImage(BufferedImage thumbnail) {
        if (this.model.getState() == 6) {
            return;
        }
    }

    @Override
    public void setRndImage(Object rndImage) {
        if (this.model.getState() == 6) {
            return;
        }
        this.model.setRenderedImage(rndImage);
    }

    @Override
    public boolean hasROIToSave() {
        if (this.model.getState() == 6) {
            return false;
        }
        return this.model.hasROIToSave();
    }

    @Override
    public void setServerROI(Collection result) {
        if (this.model.getState() != 3) {
            throw new IllegalArgumentException("The method can only be invoked in the LOADING_ROI state.");
        }
        List<DataObject> nodes = null;
        try {
            if (result != null) {
                nodes = this.model.setServerROI(result);
            }
        }
        catch (Exception e) {
            String s = "Cannot convert server ROI into UI objects:";
            MeasurementAgent.getRegistry().getLogger().error((Object)this, s + e);
        }
        this.view.layoutUI();
        this.view.updateDrawingArea();
        this.fireStateChange();
        this.postEvent(0);
        if (CollectionUtils.isNotEmpty(nodes)) {
            this.model.fireLoadROIAnnotations(nodes);
        }
    }

    @Override
    public boolean isHCSData() {
        return this.model.isHCSData();
    }

    @Override
    public String getViewTitle() {
        return this.model.getImageTitle();
    }

    @Override
    public void setLoadingFromServerClient(Collection result) {
        if (this.model.getState() != 3) {
            throw new IllegalArgumentException("The method can only be invoked in the LOADING_ROI state.");
        }
        List<DataObject> nodes = null;
        try {
            Iterator i;
            boolean hasResult = false;
            if (result != null && (i = result.iterator()).hasNext()) {
                ROIResult roiResult = (ROIResult)i.next();
                this.model.setFolders(roiResult.getFolders());
                hasResult = true;
            }
            if (!hasResult) {
                this.model.fireROILoading(null);
                return;
            }
            nodes = this.model.setServerROI(result);
        }
        catch (Exception e) {
            String s = "Cannot convert server ROI into UI objects:";
            MeasurementAgent.getRegistry().getLogger().error((Object)this, s + e);
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Load ROI", "Cannot display the ROI.");
        }
        this.view.refreshToolBar();
        this.view.rebuildManagerTable();
        this.view.refreshResultsTable();
        this.view.updateDrawingArea();
        this.view.setReadyStatus();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public void setUpdateROIComponent(Map<FolderData, Collection<ROIData>> result, ROIFolderSaver.ROIFolderAction action) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.removeAllROI();
            this.view.rebuildManagerTable(result, action);
            this.view.clearInspector();
            this.view.refreshResultsTable();
            this.view.updateDrawingArea();
        }
        catch (NoSuchROIException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        this.model.fireLoadROIServerOrClient(false);
        reg.getEventBus().post(new ROIEvent(this.model.getImageID()));
    }

    @Override
    public void setUpdateROIComponent(Collection result) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.removeAllROI();
            this.view.rebuildManagerTable();
            this.view.clearInspector();
            this.view.refreshResultsTable();
            this.view.updateDrawingArea();
        }
        catch (NoSuchROIException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        this.model.fireLoadROIServerOrClient(false);
        reg.getEventBus().post(new ROIEvent(this.model.getImageID()));
    }

    @Override
    public long getImageID() {
        return this.model.getImageID();
    }

    @Override
    public boolean canAnnotate() {
        if (this.model.getState() == 6) {
            return false;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        long id = exp.getId();
        Object ref = this.model.getRefObject();
        boolean b = EditorUtil.isUserOwner(ref, id);
        if (b) {
            return b;
        }
        if (ref instanceof DataObject) {
            return ((DataObject)ref).canAnnotate();
        }
        return false;
    }

    @Override
    public boolean canDelete() {
        if (this.model.getState() == 6) {
            return false;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        long id = exp.getId();
        Object ref = this.model.getRefObject();
        boolean b = EditorUtil.isUserOwner(ref, id);
        if (b) {
            return b;
        }
        if (ref instanceof DataObject) {
            return ((DataObject)ref).canDelete();
        }
        return false;
    }

    public String toString() {
        return "ROI for: " + EditorUtil.truncate(this.model.getImageName());
    }

    @Override
    public void deleteAllROIs(int level) {
        List<ROIData> list;
        if (!this.canDelete()) {
            return;
        }
        if (this.model.isMember()) {
            level = 1;
        }
        if ((list = this.model.getROIData(level)).size() == 0) {
            return;
        }
        ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
        Iterator<ROIData> i = list.iterator();
        SecurityContext ctx = this.model.getSecurityContext();
        while (i.hasNext()) {
            ROIData roi = i.next();
            if (roi.getId() <= 0L) continue;
            DeletableObject d = new DeletableObject(roi);
            d.setSecurityContext(ctx);
            l.add(d);
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        try {
            List<ROIFigure> figures = this.model.removeAllROI(exp.getId(), level);
            if (figures != null) {
                this.view.deleteROIs(figures);
                this.model.getROIComponent().reset();
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Delete ROI");
            msg.print((Throwable)e);
            MeasurementAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        this.model.deleteAllROIs(l);
        this.fireStateChange();
    }

    @Override
    public boolean hasROIToDelete() {
        if (this.model.getState() == 6) {
            return false;
        }
        return this.model.hasROIToDelete();
    }

    @Override
    public boolean isMember() {
        return this.model.isMember();
    }

    @Override
    public void onUpdatedChannels(List<ChannelData> channels) {
        if (this.model.getState() == 6) {
            return;
        }
        this.model.setChannelData(channels);
        this.view.displayAnalysisResults();
    }

    @Override
    public void exportGraph() {
        this.view.exportGraph();
    }

    @Override
    public void setROIAnnotations(Map<DataObject, StructuredDataResults> result) {
        if (this.model.getState() == 6 || result == null || result.size() == 0) {
            return;
        }
        Collection<ROIFigure> figures = this.model.getAllFigures();
        if (CollectionUtils.isEmpty(figures)) {
            return;
        }
        Iterator<ROIFigure> i = figures.iterator();
        Map<Long, StructuredDataResults> r = this.convertMap(result, null);
        if (r == null) {
            return;
        }
        while (i.hasNext()) {
            ROIFigure rOIFigure = i.next();
            ShapeData shape = rOIFigure.getROIShape().getData();
            if (shape == null) continue;
            rOIFigure.setAttribute(AnnotationKeys.TAG, r.get(shape.getId()));
            rOIFigure.setAttribute(AnnotationKeys.FOLDERS, rOIFigure.getROIShape().getROI().getFolders());
        }
        Collection<Figure> figs = this.view.getSelectedFiguresFromTables();
        if (CollectionUtils.isNotEmpty(figs)) {
            ArrayList<ROIShape> shapes = new ArrayList<ROIShape>();
            for (ROIFigure rOIFigure : figs) {
                shapes.add(rOIFigure.getROIShape());
            }
            this.view.displayAnnotations(shapes);
        }
    }

    private Map<Long, StructuredDataResults> convertMap(Map<DataObject, StructuredDataResults> result, Class<?> type) {
        HashMap<Long, StructuredDataResults> r = new HashMap<Long, StructuredDataResults>();
        for (Map.Entry<DataObject, StructuredDataResults> e : result.entrySet()) {
            if (type == null) {
                r.put(e.getKey().getId(), e.getValue());
                continue;
            }
            if (!e.getKey().getClass().equals(type)) continue;
            r.put(e.getKey().getId(), e.getValue());
        }
        return r;
    }

    @Override
    public void setExistingTags(Collection tags) {
        boolean valid;
        this.model.setExistingTags(tags);
        Collection<Figure> shapes = this.model.getSelectedFigures();
        Iterator<Figure> i = shapes.iterator();
        ArrayList<Object> l = new ArrayList<Object>();
        ArrayList<Long> ids = new ArrayList<Long>();
        boolean bl = valid = tags != null && CollectionUtils.isNotEmpty((Collection)tags);
        while (i.hasNext()) {
            ROIFigure shape = (ROIFigure)i.next();
            StructuredDataResults data = (StructuredDataResults)shape.getAttribute(AnnotationKeys.TAG);
            if (data == null || !CollectionUtils.isNotEmpty(data.getTags())) continue;
            if (valid) {
                for (TagAnnotationData d : data.getTags()) {
                    ids.add(d.getId());
                    l.add(d);
                }
                continue;
            }
            l.addAll(data.getTags());
        }
        ArrayList<Object> available = new ArrayList<Object>();
        if (valid) {
            for (AnnotationData object : tags) {
                if (ids.contains(object.getId())) continue;
                available.add(object);
            }
        }
        SelectionWizard wizard = new SelectionWizard((JFrame)this.view, available, l, TagAnnotationData.class, true, this.model.getCurrentUser());
        wizard.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(wizard);
    }

    @Override
    public void loadTags() {
        Collection tags = this.model.getExistingTags();
        if (tags == null) {
            this.model.fireExistingTagsLoading();
        } else {
            this.setExistingTags(tags);
        }
    }

    @Override
    public void tagSelectedFigures(List<AnnotationData> tags) {
        Long id;
        Collection<Figure> figures = this.view.getSelectedFiguresFromTables();
        if (CollectionUtils.isEmpty(figures)) {
            return;
        }
        ArrayList<ROIShape> shapes = new ArrayList<ROIShape>();
        for (ROIFigure rOIFigure : figures) {
            shapes.add(rOIFigure.getROIShape());
        }
        if (CollectionUtils.isEmpty(shapes)) {
            return;
        }
        ArrayListMultimap m = ArrayListMultimap.create();
        for (AnnotationData an : tags) {
            m.put((Object)an.getId(), (Object)an);
        }
        Iterator i = shapes.iterator();
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        HashMap<Long, TagAnnotationData> mo = new HashMap<Long, TagAnnotationData>();
        while (i.hasNext()) {
            ROIShape shape = (ROIShape)i.next();
            ShapeData d = shape.getData();
            if (d == null || d.getId() <= 0L) continue;
            objects.add(d);
            StructuredDataResults data = (StructuredDataResults)shape.getFigure().getAttribute(AnnotationKeys.TAG);
            if (data == null || !CollectionUtils.isNotEmpty(data.getTags())) continue;
            Collection<TagAnnotationData> t = data.getTags();
            for (TagAnnotationData tag : t) {
                if (mo.containsKey(tag.getId())) continue;
                mo.put(tag.getId(), tag);
            }
        }
        if (objects.isEmpty()) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("ROI Annotations", "You must save the ROI before annotating it.");
            return;
        }
        ArrayList<AnnotationData> toAdd = new ArrayList<AnnotationData>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)m.get((Object)-1L))) {
            toAdd.addAll(m.removeAll((Object)-1L));
        }
        for (Map.Entry entry : m.entries()) {
            id = (Long)entry.getKey();
            if (mo.containsKey(id)) continue;
            toAdd.add((AnnotationData)entry.getValue());
        }
        for (Map.Entry entry : mo.entrySet()) {
            id = (Long)entry.getKey();
            if (m.containsKey((Object)id)) continue;
            toRemove.add(entry.getValue());
        }
        this.model.fireAnnotationSaving(objects, toAdd, toRemove);
    }

    @Override
    public void onAnnotationSaved() {
        Collection<ROIFigure> figures = this.model.getAllFigures();
        if (CollectionUtils.isEmpty(figures)) {
            return;
        }
        ArrayList<ROIShape> shapes = new ArrayList<ROIShape>();
        for (ROIFigure fig : figures) {
            shapes.add(fig.getROIShape());
        }
        if (CollectionUtils.isEmpty(shapes)) {
            return;
        }
        Iterator i = shapes.iterator();
        ArrayList<DataObject> nodes = new ArrayList<DataObject>();
        while (i.hasNext()) {
            ROIShape shape = (ROIShape)i.next();
            nodes.add(shape.getData());
        }
        this.model.fireLoadROIAnnotations(nodes);
    }
}

