/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class AnnotationEditor
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String EDIT_PROPERTY = "edit";
    public static final String CLOSE_PROPERTY = "close";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private JButton cancel;
    private JButton save;
    private JTextArea area;
    private String originalText;

    private void initComponents() {
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText("Cancel edition.");
        this.cancel.addActionListener(this);
        this.cancel.setActionCommand("0");
        this.save = new JButton("OK");
        this.save.setToolTipText("Save edition.");
        this.save.addActionListener(this);
        this.save.setActionCommand("1");
        this.save.setEnabled(false);
        this.area = new JTextArea(this.originalText);
        this.area.setCaretPosition(this.originalText.length());
        this.area.setBorder(BorderFactory.createBevelBorder(1));
        this.area.getDocument().addDocumentListener(this);
        this.getRootPane().setDefaultButton(this.save);
    }

    private void handleTextModification() {
        String text = this.area.getText();
        this.save.setEnabled(!this.originalText.equals(text = text.trim()));
    }

    private void cancel() {
        this.firePropertyChange(CLOSE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        String text = this.area.getText();
        this.firePropertyChange(EDIT_PROPERTY, this.originalText, text);
        this.cancel();
    }

    private JPanel buildBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancel);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.save);
        bar.add(Box.createHorizontalStrut(5));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        JPanel top = new JPanel();
        top.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        ImageIcon icon = IconManager.getInstance().getIcon(23);
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel(new GridBagLayout());
        JPanel realBody = new JPanel(new BorderLayout());
        realBody.add((Component)body, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 10;
        cons.insets = new Insets(0, 0, 3, 0);
        cons.fill = 2;
        cons.weightx = 1.0;
        body.add((Component)this.area, cons);
        top.add((Component)realBody, "Center");
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setVerticalAlignment(0);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(iconLabel);
        p.add(Box.createHorizontalStrut(10));
        top.add((Component)p, "Before");
        top.add((Component)this.buildBar(), "South");
        this.getContentPane().add(top);
    }

    public AnnotationEditor(JFrame owner, String title, String originalText) {
        super(owner);
        if (originalText == null) {
            originalText = "";
        }
        this.originalText = originalText;
        this.setTitle("Edit: " + title);
        this.setModal(true);
        this.initComponents();
        this.buildGUI();
        this.setSize(250, 150);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.save();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleTextModification();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleTextModification();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

