/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

public class ViewerSorter {
    private boolean ascending;
    private boolean byDate;
    private Collection collection;
    private List results;
    private boolean caseSensitive;

    private int compareDates(Date d1, Date d2) {
        long n1 = d1.getTime();
        long n2 = d2.getTime();
        int v = 0;
        if (n1 < n2) {
            v = -1;
        } else if (n1 > n2) {
            v = 1;
        }
        return v;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int v = 0;
        int result = !this.caseSensitive ? s1.toLowerCase().compareTo(s2.toLowerCase()) : s1.compareTo(s2);
        if (result < 0) {
            v = -1;
        } else if (result > 0) {
            v = 1;
        }
        return v;
    }

    private int compareObjects(Object o1, Object o2) {
        return this.compareStrings(o1.toString(), o2.toString());
    }

    private int compareBooleans(Boolean bool1, Boolean bool2) {
        boolean b1 = bool1;
        boolean b2 = bool2;
        int v = 0;
        v = b1 == b2 ? 0 : (b1 ? -1 : 1);
        return v;
    }

    private int compareNumbers(Number n1, Number n2) {
        double d1 = n1.doubleValue();
        double d2 = n2.doubleValue();
        int v = 0;
        if (d1 < d2) {
            v = -1;
        } else if (d1 > d2) {
            v = 1;
        }
        return v;
    }

    private int compareLongs(long d1, long d2) {
        int v = 0;
        if (d1 < d2) {
            v = -1;
        } else if (d1 > d2) {
            v = 1;
        }
        return v;
    }

    private int compareTimestamps(Timestamp t1, Timestamp t2) {
        int v = 0;
        int r = t1.compareTo(t2);
        if (r < 0) {
            v = -1;
        } else if (r > 0) {
            v = 1;
        }
        return v;
    }

    private int compareDataObjects(DataObject o1, DataObject o2) {
        if (o1 instanceof FolderData && o2 instanceof FolderData) {
            return ((FolderData)o1).getFolderPathString().compareToIgnoreCase(((FolderData)o2).getFolderPathString());
        }
        if (o1 instanceof ChannelData) {
            ChannelData c1 = (ChannelData)o1;
            ChannelData c2 = (ChannelData)o2;
            return this.compareNumbers(c1.getIndex(), c2.getIndex());
        }
        if (o1 instanceof WellData) {
            return this.compareNumbers(((WellData)o1).getRow(), ((WellData)o2).getRow());
        }
        return this.compareObjects(o1, o2, true);
    }

    private int compareObjects(Object o1, Object o2, boolean dataObject) {
        if (!this.byDate) {
            int r = this.compareStrings(this.getNameFor(o1), this.getNameFor(o2));
            if (r == 0 && dataObject) {
                return this.compareLongs(((DataObject)o1).getId(), ((DataObject)o2).getId());
            }
            return r;
        }
        return this.compareTimestamps(this.getTimeFor(o1), this.getTimeFor(o2));
    }

    private int compareTreeImageDisplays(TreeImageDisplay o1, TreeImageDisplay o2) {
        Object ob1 = o1.getUserObject();
        Object ob2 = o2.getUserObject();
        if (ob1 instanceof DataObject && ob2 instanceof DataObject) {
            return this.compareDataObjects((DataObject)ob1, (DataObject)ob2);
        }
        return -1;
    }

    private int compareImageDisplays(ImageDisplay o1, ImageDisplay o2) {
        Object ob1 = o1.getHierarchyObject();
        Object ob2 = o2.getHierarchyObject();
        if (!(ob1 instanceof DataObject)) {
            return -1;
        }
        if (!(ob2 instanceof DataObject)) {
            return 1;
        }
        return this.compareDataObjects((DataObject)ob1, (DataObject)ob2);
    }

    private Timestamp getTimeFor(Object o) {
        Timestamp t = null;
        if (o instanceof ImageData) {
            try {
                t = ((ImageData)o).getAcquisitionDate();
            }
            catch (Exception exception) {}
        } else {
            try {
                if (o instanceof DataObject) {
                    t = ((DataObject)o).getCreated();
                } else if (o instanceof File) {
                    t = new Timestamp(((File)o).lastModified());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (t == null) {
            t = new Timestamp(new Date().getTime());
        }
        return t;
    }

    public String getNameFor(Object obj) {
        if (obj instanceof ProjectData) {
            return ((ProjectData)obj).getName();
        }
        if (obj instanceof DatasetData) {
            return ((DatasetData)obj).getName();
        }
        if (obj instanceof ImageData) {
            return ((ImageData)obj).getName();
        }
        if (obj instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)obj;
            String s = exp.getLastName();
            if (s != null && s.trim().length() != 0) {
                return s;
            }
            s = exp.getFirstName();
            if (s != null && s.trim().length() != 0) {
                return s;
            }
            return exp.getUserName();
        }
        if (obj instanceof GroupData) {
            return ((GroupData)obj).getName();
        }
        if (obj instanceof AnnotationData) {
            return ((AnnotationData)obj).getContentAsString();
        }
        if (obj instanceof ScreenData) {
            return ((ScreenData)obj).getName();
        }
        if (obj instanceof PlateData) {
            return ((PlateData)obj).getName();
        }
        if (obj instanceof TagAnnotationData) {
            return ((TagAnnotationData)obj).getTagValue();
        }
        if (obj instanceof FileData) {
            return ((FileData)obj).getName();
        }
        if (obj instanceof GroupData) {
            return ((GroupData)obj).getName();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int result = 0;
        result = o1 instanceof Number || o1 instanceof Integer || o1 instanceof Double || o1 instanceof Float ? this.compareNumbers((Number)o1, (Number)o2) : (o1 instanceof Date && o2 instanceof Date ? this.compareDates((Date)o1, (Date)o2) : (o1 instanceof String && o2 instanceof String ? this.compareStrings((String)o1, (String)o2) : (o1 instanceof Boolean && o2 instanceof Boolean ? this.compareBooleans((Boolean)o1, (Boolean)o2) : (o1 instanceof DataObject && o2 instanceof DataObject ? this.compareDataObjects((DataObject)o1, (DataObject)o2) : (o1 instanceof TreeImageDisplay && o2 instanceof TreeImageDisplay ? this.compareTreeImageDisplays((TreeImageDisplay)o1, (TreeImageDisplay)o2) : (o1 instanceof ImageDisplay && o2 instanceof ImageDisplay ? this.compareImageDisplays((ImageDisplay)o1, (ImageDisplay)o2) : (o1 instanceof Timestamp && o2 instanceof Timestamp ? this.compareTimestamps((Timestamp)o1, (Timestamp)o2) : (o1 instanceof FileFilter && o2 instanceof FileFilter ? this.compareStrings(((FileFilter)o1).getDescription(), ((FileFilter)o2).getDescription()) : (o1 instanceof ROIShape && o2 instanceof ROIShape ? this.compareLongs(((ROIShape)o1).getID(), ((ROIShape)o2).getID()) : this.compareObjects(o1, o2))))))))));
        if (result != 0) {
            return this.ascending ? result : -result;
        }
        return result;
    }

    private void shuttlesort(Object[] from, Object[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    private void initialize() {
        this.ascending = true;
        this.byDate = false;
        this.caseSensitive = false;
    }

    public ViewerSorter() {
        this.initialize();
    }

    public ViewerSorter(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("No collection");
        }
        this.collection = collection;
        this.initialize();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean b) {
        if (b == this.ascending) {
            return;
        }
        this.ascending = b;
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isByDate() {
        return this.byDate;
    }

    public void setByDate(boolean b) {
        this.byDate = b;
    }

    public List sort(Object[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            l.add(array[i]);
        }
        this.collection = l;
        return this.sort();
    }

    public List sort(Collection collection) {
        if (collection == null) {
            return null;
        }
        this.collection = collection;
        return this.sort();
    }

    public List sort() {
        if (this.collection == null) {
            return null;
        }
        Iterator i = this.collection.iterator();
        Object[] array = new Object[this.collection.size()];
        Object[] clone = new Object[this.collection.size()];
        int index = 0;
        while (i.hasNext()) {
            Object obj = i.next();
            array[index] = obj;
            clone[index] = obj;
            ++index;
        }
        this.shuttlesort(clone, array, 0, array.length);
        this.results = new ArrayList();
        for (int j = 0; j < array.length; ++j) {
            this.results.add(array[j]);
        }
        return this.results;
    }

    public Object[] sortAsArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        this.collection = collection;
        return this.sortAsArray();
    }

    public Object[] sortAsArray(Object[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            l.add(array[i]);
        }
        this.collection = l;
        return this.sortAsArray();
    }

    public Object[] sortAsArray() {
        if (this.collection == null) {
            return null;
        }
        Iterator i = this.collection.iterator();
        Object[] array = new Object[this.collection.size()];
        Object[] clone = new Object[this.collection.size()];
        int index = 0;
        while (i.hasNext()) {
            Object obj = i.next();
            array[index] = obj;
            clone[index] = obj;
            ++index;
        }
        this.shuttlesort(clone, array, 0, array.length);
        return array;
    }
}

