/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.util.ui.RowPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ComplexParamPane
extends JPanel
implements PropertyChangeListener {
    static final int MAP = 0;
    static final int LIST = 1;
    private int defaultIndex;
    private Object[] values;
    private Class keyType;
    private Class valueType;
    private int index;
    private List<RowPane> rows;
    private JPanel rowsPane;
    private JButton addButton;

    private void initializeComponents() {
        IconManager icons = IconManager.getInstance();
        this.addButton = new JButton(icons.getIcon(56));
        UIUtilities.unifiedButtonLookAndFeel(this.addButton);
        this.addButton.setToolTipText("Add a new row.");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComplexParamPane.this.createRow();
                ComplexParamPane.this.layoutRows();
            }
        });
    }

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    private RowPane createRow() {
        RowPane row = null;
        switch (this.index) {
            case 1: {
                if (this.keyType == null && this.values != null) {
                    row = new RowPane(this.values);
                    break;
                }
                if (this.keyType == null || this.values != null) break;
                row = new RowPane(this.keyType);
                break;
            }
            case 0: {
                if (this.values == null && this.valueType != null) {
                    row = new RowPane(this.keyType, this.valueType);
                    break;
                }
                if (this.values == null || this.valueType != null) break;
                row = new RowPane(this.keyType, this.values);
            }
        }
        if (row != null) {
            row.setDefaultValue(this.defaultIndex);
            row.setToolTipText(this.getToolTipText());
            this.rows.add(row);
            row.addPropertyChangeListener("removeRow", this);
        }
        return row;
    }

    private void layoutRows() {
        this.rowsPane.removeAll();
        TableLayout layout = (TableLayout)this.rowsPane.getLayout();
        Iterator<RowPane> i = this.rows.iterator();
        int index = 0;
        while (i.hasNext()) {
            layout.insertRow(index, -2.0);
            this.rowsPane.add((Component)i.next(), "0," + index + ", LEFT, CENTER");
            ++index;
        }
        this.revalidate();
        this.repaint();
    }

    private void removeRow(RowPane row) {
        if (row == null) {
            return;
        }
        this.rows.remove(row);
        this.layoutRows();
    }

    private void buildGUI() {
        double[] columns = new double[]{-2.0, 5.0, -1.0};
        this.rowsPane = new JPanel();
        TableLayout layout = new TableLayout();
        layout.setColumn(columns);
        this.rowsPane.setLayout((LayoutManager)layout);
        RowPane row = this.createRow();
        row.addPropertyChangeListener(this);
        row.disableRemove();
        this.layoutRows();
        double[][] size = new double[][]{{-2.0, 2.0, -1.0}, {-2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.addButton, "0, 0, LEFT, TOP");
        this.add((Component)this.rowsPane, "2, 0, 2, 1");
    }

    ComplexParamPane(JComboBox values) {
        this(1, values, null, null);
    }

    ComplexParamPane(Class keyType) {
        this(1, null, keyType, null);
    }

    ComplexParamPane(Class keyType, JComboBox values) {
        this(0, values, keyType, null);
    }

    ComplexParamPane(Class keyType, Class valueType) {
        this(0, null, keyType, valueType);
    }

    ComplexParamPane(int index, JComboBox values, Class keyType, Class valueType) {
        if (values == null && valueType == null && keyType == null) {
            throw new IllegalArgumentException("Value not specified.");
        }
        this.checkIndex(index);
        if (index == 0 && keyType == null) {
            throw new IllegalArgumentException("Key cannot be null for Map Type.");
        }
        this.index = index;
        if (values != null) {
            this.defaultIndex = values.getSelectedIndex();
            Object[] v = new Object[values.getItemCount()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = values.getItemAt(i);
            }
            this.values = v;
        }
        this.keyType = keyType;
        this.valueType = valueType;
        this.rows = new ArrayList<RowPane>();
        this.initializeComponents();
        this.buildGUI();
    }

    Object getValue() {
        Iterator<RowPane> i = this.rows.iterator();
        switch (this.index) {
            case 1: {
                ArrayList<Object> r = new ArrayList<Object>();
                while (i.hasNext()) {
                    RowPane row = i.next();
                    Object key = row.getKeyResult();
                    if (key == null) continue;
                    r.add(key);
                }
                if (r.size() == 0) {
                    return null;
                }
                return r;
            }
            case 0: {
                HashMap<Object, Object> m = new HashMap<Object, Object>();
                while (i.hasNext()) {
                    RowPane row = i.next();
                    Object key = row.getKeyResult();
                    Object value = row.getValueResult();
                    if (value == null || key == null) continue;
                    m.put(key, value);
                }
                if (m.size() == 0) {
                    return m;
                }
                return m;
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("removeRow".equals(name)) {
            this.removeRow((RowPane)evt.getNewValue());
        } else if ("modifiedContent".equals(name)) {
            this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        Iterator<RowPane> i = this.rows.iterator();
        while (i.hasNext()) {
            i.next().setToolTipText(text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
        Iterator<RowPane> i = this.rows.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(enabled);
        }
    }
}

