/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ome.io.nio.OriginalFilesService;
import ome.model.IAnnotated;
import ome.model.IEnum;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.DoubleAnnotation;
import ome.model.annotations.FileAnnotation;
import ome.model.annotations.LongAnnotation;
import ome.model.annotations.MapAnnotation;
import ome.model.annotations.TagAnnotation;
import ome.model.annotations.TermAnnotation;
import ome.model.annotations.TextAnnotation;
import ome.model.containers.Folder;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.fs.Fileset;
import ome.model.fs.FilesetEntry;
import ome.model.internal.Details;
import ome.model.internal.NamedValue;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.roi.Roi;
import ome.services.fulltext.BridgeHelper;
import ome.services.fulltext.FileParser;
import ome.services.fulltext.SimpleLuceneOptions;
import ome.util.Utils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.builtin.DateBridge;

@Deprecated
public class FullTextBridge
extends BridgeHelper {
    protected final OriginalFilesService files;
    protected final Map<String, FileParser> parsers;
    protected final Class<FieldBridge>[] classes;
    protected int maxFilesetSize;

    public FullTextBridge() {
        this(null, null);
    }

    public FullTextBridge(OriginalFilesService files, Map<String, FileParser> parsers) {
        this(files, parsers, new Class[0]);
    }

    public FullTextBridge(OriginalFilesService files, Map<String, FileParser> parsers, Class<FieldBridge>[] bridgeClasses) {
        this.files = files;
        this.parsers = parsers;
        this.classes = bridgeClasses == null ? new Class[]{} : bridgeClasses;
    }

    public void setMaxFilesetSize(int maxFilesetSize) {
        this.logger().info("Setting maximum fileset size to {}", (Object)maxFilesetSize);
        this.maxFilesetSize = maxFilesetSize;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions opts) {
        IObject object = (IObject)value;
        String cls = Utils.trueClass(object.getClass()).getName();
        this.add(document, null, cls, opts);
        this.set_file(name, object, document, opts);
        this.set_annotations(name, object, document, opts);
        this.set_acquisition(name, object, document, opts);
        this.set_details(name, object, document, opts);
        this.set_fileset(name, object, document, opts);
        this.set_folders(name, object, document, opts);
        this.set_custom(name, object, document, opts);
    }

    public void set_file(String name, IObject object, Document document, LuceneOptions opts) {
        if (object instanceof OriginalFile) {
            OriginalFile file = (OriginalFile)object;
            this.addContents(document, "file.contents", file, this.files, this.parsers, opts);
        }
    }

    public void set_annotations(String name, IObject object, Document document, LuceneOptions opts) {
        ILink link;
        if (object instanceof ILink && (link = (ILink)object).getChild() instanceof Annotation) {
            this.reindex(link.getParent());
        }
        if (object instanceof IAnnotated) {
            IAnnotated annotated = (IAnnotated)object;
            List list = annotated.linkedAnnotationList();
            for (Annotation annotation : list) {
                Number value;
                if (annotation instanceof HibernateProxy) {
                    annotation = (Annotation)((HibernateProxy)annotation).getHibernateLazyInitializer().getImplementation();
                }
                String at = annotation.getClass().getSimpleName();
                this.add(document, "annotation.type", at, opts);
                if (annotation.getName() != null) {
                    this.add(document, "annotation.name", annotation.getName(), opts);
                }
                if (annotation.getNs() != null) {
                    this.add(document, "annotation.ns", annotation.getNs(), opts);
                }
                if (annotation instanceof TermAnnotation) {
                    TermAnnotation term = (TermAnnotation)annotation;
                    String termValue = term.getTermValue();
                    termValue = termValue == null ? "" : termValue;
                    this.add(document, "term", termValue, opts);
                    continue;
                }
                if (annotation instanceof DoubleAnnotation) {
                    value = ((DoubleAnnotation)annotation).getDoubleValue();
                    if (value == null) continue;
                    this.add(document, "annotation", ((Double)value).toString(), opts);
                    continue;
                }
                if (annotation instanceof LongAnnotation) {
                    value = ((LongAnnotation)annotation).getLongValue();
                    if (value == null) continue;
                    this.add(document, "annotation", ((Long)value).toString(), opts);
                    continue;
                }
                if (annotation instanceof TextAnnotation) {
                    TextAnnotation text = (TextAnnotation)annotation;
                    String textValue = text.getTextValue();
                    textValue = textValue == null ? "" : textValue;
                    this.add(document, "annotation", textValue, opts);
                    if (!(annotation instanceof TagAnnotation)) continue;
                    this.add(document, "tag", textValue, opts);
                    List list2 = annotation.linkedAnnotationList();
                    for (Annotation annotation2 : list2) {
                        if (!(annotation2 instanceof TextAnnotation)) continue;
                        TextAnnotation text2 = (TextAnnotation)annotation2;
                        String textValue2 = text2.getTextValue();
                        textValue2 = textValue2 == null ? "" : textValue2;
                        this.add(document, "annotation", textValue2, opts);
                    }
                    continue;
                }
                if (annotation instanceof FileAnnotation) {
                    FileAnnotation fileAnnotation = (FileAnnotation)annotation;
                    this.handleFileAnnotation(document, opts, fileAnnotation);
                    continue;
                }
                if (!(annotation instanceof MapAnnotation)) continue;
                MapAnnotation mapAnnotation = (MapAnnotation)annotation;
                this.handleMapAnnotation(document, opts, mapAnnotation);
            }
        }
        if (object instanceof FileAnnotation) {
            FileAnnotation fileAnnotation = (FileAnnotation)object;
            this.handleFileAnnotation(document, opts, fileAnnotation);
        } else if (object instanceof MapAnnotation) {
            MapAnnotation mapAnnotation = (MapAnnotation)object;
            this.handleMapAnnotation(document, opts, mapAnnotation);
        }
    }

    public void set_acquisition(String name, IObject object, Document document, LuceneOptions opts) {
        if (object instanceof Image) {
            Image image = (Image)object;
            if (image.sizeOfPixels() == 0) {
                return;
            }
            Pixels pixels = image.getPrimaryPixels();
            if (pixels == null) {
                return;
            }
            Iterator channelIterator = pixels.iterateChannels();
            while (channelIterator.hasNext()) {
                LogicalChannel logical;
                Channel channel = (Channel)channelIterator.next();
                if (channel == null || (logical = channel.getLogicalChannel()) == null) continue;
                this.addIfNotNull(document, "channel.name", logical.getName(), opts);
                this.addIfNotNull(document, "channel.fluor", logical.getFluor(), opts);
                this.addEnumIfNotNull(document, "channel.mode", (IEnum)logical.getMode(), opts);
                this.addEnumIfNotNull(document, "channel.photometricInterpretation", (IEnum)logical.getPhotometricInterpretation(), opts);
            }
        }
    }

    public void set_details(String name, IObject object, Document document, LuceneOptions opts) {
        SimpleLuceneOptions stored = new SimpleLuceneOptions(opts, Field.Store.YES);
        SimpleLuceneOptions storedNotAnalyzed = new SimpleLuceneOptions(opts, Field.Index.NOT_ANALYZED, Field.Store.YES);
        Details details = object.getDetails();
        if (details != null) {
            Permissions perms;
            Event updateEvent;
            Event creationEvent;
            ExperimenterGroup g;
            Experimenter e = details.getOwner();
            if (e != null && e.isLoaded()) {
                String omename = e.getOmeName();
                String firstName = e.getFirstName();
                String lastName = e.getLastName();
                this.add(document, "details.owner.omeName", omename, stored);
                this.add(document, "details.owner.firstName", firstName, opts);
                this.add(document, "details.owner.lastName", lastName, opts);
            }
            if ((g = details.getGroup()) != null && g.isLoaded()) {
                String groupName = g.getName();
                this.add(document, "details.group.name", groupName, stored);
            }
            if ((creationEvent = details.getCreationEvent()) != null) {
                this.add(document, "details.creationEvent.id", creationEvent.getId().toString(), storedNotAnalyzed);
                if (creationEvent.isLoaded()) {
                    String creation = DateBridge.DATE_SECOND.objectToString((Object)creationEvent.getTime());
                    this.add(document, "details.creationEvent.time", creation, storedNotAnalyzed);
                }
            }
            if ((updateEvent = details.getUpdateEvent()) != null) {
                this.add(document, "details.updateEvent.id", updateEvent.getId().toString(), storedNotAnalyzed);
                if (updateEvent.isLoaded()) {
                    String update = DateBridge.DATE_SECOND.objectToString((Object)updateEvent.getTime());
                    this.add(document, "details.updateEvent.time", update, storedNotAnalyzed);
                }
            }
            if ((perms = details.getPermissions()) != null) {
                this.add(document, "details.permissions", perms.toString(), stored);
            }
        }
    }

    public void set_folders(String name, IObject object, Document document, LuceneOptions opts) {
        if (object instanceof Image) {
            Image image = (Image)object;
            Iterator roiIterator = image.iterateRois();
            while (roiIterator.hasNext()) {
                Roi roi = (Roi)roiIterator.next();
                Iterator folderIterator = roi.linkedFolderIterator();
                while (folderIterator.hasNext()) {
                    Folder folder = (Folder)folderIterator.next();
                    this.add(document, "roi.folder.name", folder.getName(), opts);
                }
            }
        }
    }

    public void set_fileset(String name, IObject object, Document document, LuceneOptions opts) {
        if (object instanceof Image) {
            Image image = (Image)object;
            Fileset fileset = image.getFileset();
            if (fileset == null || this.maxFilesetSize < 1) {
                return;
            }
            this.add(document, "fileset.templatePrefix", fileset.getTemplatePrefix(), opts);
            Iterator entryIterator = fileset.iterateUsedFiles();
            int index = 0;
            while (entryIterator.hasNext()) {
                FilesetEntry entry = (FilesetEntry)entryIterator.next();
                if (entry == null) continue;
                if (++index > this.maxFilesetSize) {
                    return;
                }
                this.add(document, "fileset.entry.clientPath", entry.getClientPath(), opts);
                this.add(document, "fileset.entry.name", entry.getOriginalFile().getName(), opts);
            }
        }
    }

    public void set_custom(String name, IObject object, Document document, LuceneOptions opts) {
        for (Class<FieldBridge> bridgeClass : this.classes) {
            if (bridgeClass == null) continue;
            FieldBridge bridge = null;
            try {
                bridge = bridgeClass.newInstance();
                if (bridge instanceof BridgeHelper) {
                    BridgeHelper helper = (BridgeHelper)bridge;
                    helper.setApplicationEventPublisher(this.publisher);
                }
                bridge.set(name, (Object)object, document, opts);
            }
            catch (Exception e) {
                String msg = String.format("Error calling set on custom bridge type:%s; instance:%s", bridgeClass, bridge);
                this.logger().error(msg, (Throwable)e);
            }
        }
    }

    private void handleFileAnnotation(Document document, LuceneOptions opts, FileAnnotation fileAnnotation) {
        OriginalFile file = fileAnnotation.getFile();
        if (file != null) {
            this.add(document, "file.name", file.getName(), opts);
            this.add(document, "file.path", file.getPath(), opts);
            if (file.getHasher() != null) {
                this.add(document, "file.hasher", file.getHasher().getValue(), opts);
            }
            if (file.getHash() != null) {
                this.add(document, "file.hash", file.getHash(), opts);
            }
            if (file.getMimetype() != null) {
                this.add(document, "file.format", file.getMimetype(), opts);
                this.add(document, "file.mimetype", file.getMimetype(), opts);
            }
            this.addContents(document, "file.contents", file, this.files, this.parsers, opts);
        }
    }

    private void handleMapAnnotation(Document document, LuceneOptions opts, MapAnnotation mapAnnotation) {
        List nvs = mapAnnotation.getMapValue();
        if (nvs != null && nvs.size() > 0) {
            for (NamedValue nv : nvs) {
                if (nv == null) continue;
                this.add(document, nv.getName(), nv.getValue(), opts);
                this.add(document, "has_key", nv.getName(), opts);
                this.add(document, "annotation", nv.getValue(), opts);
                this.add(document, "annotation", nv.getName(), opts);
            }
        }
    }
}

