/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentPlatform {
    private static final OperatingSystem os;

    public static boolean isWindows() {
        return os == OperatingSystem.WINDOWS;
    }

    public static boolean isLinux() {
        return os == OperatingSystem.LINUX;
    }

    public static boolean isMacOSX() {
        return os == OperatingSystem.MAC;
    }

    public static boolean isUnknown() {
        return os == null;
    }

    static {
        Logger logger = LoggerFactory.getLogger(CurrentPlatform.class);
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows ")) {
            os = OperatingSystem.WINDOWS;
        } else if (osName.equals("Linux")) {
            os = OperatingSystem.LINUX;
        } else if (osName.equals("Mac OS X")) {
            os = OperatingSystem.MAC;
        } else {
            os = null;
            logger.warn("failed to recognize current operating system");
        }
        if (os != null && logger.isDebugEnabled()) {
            logger.debug("recognized current operating system as being " + (Object)((Object)os));
        }
    }

    private static enum OperatingSystem {
        WINDOWS("Microsoft Windows"),
        LINUX("Linux"),
        MAC("Apple Mac OS X");

        private final String name;

        private OperatingSystem(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

