/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashSet;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DragTracker;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleTracker;
import org.jhotdraw.draw.SelectAreaTracker;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;

public class SelectionTool
extends AbstractTool
implements ToolListener {
    private Tool tracker = this.createAreaTracker();

    public SelectionTool() {
        this.tracker.addToolListener(this);
    }

    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.tracker.activate(editor);
    }

    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.tracker.deactivate(editor);
    }

    public void keyPressed(KeyEvent e) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyReleased(evt);
        }
    }

    public void keyTyped(KeyEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyTyped(evt);
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseClicked(evt);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseDragged(evt);
        }
    }

    public void mouseEntered(MouseEvent evt) {
        super.mouseEntered(evt);
        this.tracker.mouseEntered(evt);
    }

    public void mouseExited(MouseEvent evt) {
        super.mouseExited(evt);
        this.tracker.mouseExited(evt);
    }

    public void mouseMoved(MouseEvent evt) {
        this.tracker.mouseMoved(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseReleased(evt);
        }
    }

    public void draw(Graphics2D g) {
        this.tracker.draw(g);
    }

    public void mousePressed(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            super.mousePressed(evt);
            DrawingView view = this.getView();
            Handle handle = view.findHandle(this.anchor);
            Tool newTracker = null;
            if (handle != null) {
                newTracker = this.createHandleTracker(handle);
            } else {
                Figure figure;
                if ((evt.getModifiersEx() & 0x280) != 0) {
                    figure = view.findFigure(this.anchor);
                    HashSet<Figure> ignoredFigures = new HashSet<Figure>(view.getSelectedFigures());
                    ignoredFigures.add(figure);
                    Figure figureBehind = view.getDrawing().findFigureBehind(view.viewToDrawing(this.anchor), ignoredFigures);
                    if (figureBehind != null) {
                        figure = figureBehind;
                    }
                } else {
                    Point2D.Double p = view.viewToDrawing(this.anchor);
                    figure = null;
                    for (Figure f : view.getSelectedFigures()) {
                        if (!f.contains(p)) continue;
                        figure = f;
                        break;
                    }
                    if (figure == null) {
                        figure = view.findFigure(this.anchor);
                    }
                }
                if (figure != null) {
                    newTracker = this.createDragTracker(figure);
                } else {
                    if (!evt.isShiftDown()) {
                        view.clearSelection();
                        view.setHandleDetailLevel(0);
                    }
                    newTracker = this.createAreaTracker();
                }
            }
            if (newTracker != null) {
                this.setTracker(newTracker);
            }
            this.tracker.mousePressed(evt);
        }
    }

    protected void setTracker(Tool newTracker) {
        if (this.tracker != null) {
            this.tracker.deactivate(this.getEditor());
            this.tracker.removeToolListener(this);
        }
        this.tracker = newTracker;
        if (this.tracker != null) {
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this);
        }
    }

    protected Tool createHandleTracker(Handle handle) {
        return new HandleTracker(handle, this.getView().getCompatibleHandles(handle));
    }

    protected Tool createDragTracker(Figure f) {
        return new DragTracker(f);
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker();
    }

    public void toolStarted(ToolEvent event) {
    }

    public void toolDone(ToolEvent event) {
        Tool newTracker = this.createAreaTracker();
        if (newTracker != null) {
            if (this.tracker != null) {
                this.tracker.deactivate(this.getEditor());
                this.tracker.removeToolListener(this);
            }
            this.tracker = newTracker;
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this);
        }
        this.fireToolDone();
    }

    public void areaInvalidated(ToolEvent e) {
        this.fireAreaInvalidated(e.getInvalidatedArea());
    }
}

