/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.util.ui.MagnificationComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

class DataBrowserWellToolBar
extends JPanel
implements ActionListener {
    private static final int ROLL_OVER = 0;
    private static final int FACTOR = 10;
    private DataBrowserControl controller;
    private DataBrowserUI view;
    private JButton refreshButton;
    private JToggleButton rollOverButton;
    private JComboBox fields;
    private JXBusyLabel busyLabel;
    private MagnificationComponent mag;
    private OneKnobSlider zoomSlider;
    private ChangeListener zoomListener;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.rollOverButton = new JToggleButton();
        this.rollOverButton.setIcon(icons.getIcon(21));
        this.rollOverButton.setToolTipText("Turn on/off the magnification of a thumbnail while mousing over it.");
        this.rollOverButton.addActionListener(this);
        this.rollOverButton.setActionCommand("0");
        this.busyLabel = new JXBusyLabel(new Dimension(16, 16));
        this.busyLabel.setVisible(false);
        this.refreshButton = new JButton(this.controller.getAction(DataBrowserControl.REFRESH));
        UIUtilities.unifiedButtonLookAndFeel(this.refreshButton);
        int f = this.view.getFieldsNumber();
        if (f > 1) {
            String[] values = new String[f];
            for (int i = 0; i < f; ++i) {
                values[i] = "Field #" + (i + 1);
            }
            this.fields = new JComboBox<String>(values);
            this.fields.setSelectedIndex(this.view.getSelectedField());
            this.fields.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataBrowserWellToolBar.this.controller.viewField(DataBrowserWellToolBar.this.fields.getSelectedIndex());
                }
            });
        }
        double scale = DataBrowserFactory.getThumbnailScaleFactor();
        this.mag = new MagnificationComponent(0.25, 2.5, scale);
        this.mag.addPropertyChangeListener("magnification", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("magnification".equals(name)) {
                    double v = (Double)evt.getNewValue();
                    DataBrowserWellToolBar.this.view.setMagnificationFactor(v);
                    int value = (int)(v * 10.0);
                    DataBrowserWellToolBar.this.zoomSlider.removeChangeListener(DataBrowserWellToolBar.this.zoomListener);
                    DataBrowserWellToolBar.this.zoomSlider.setValue(value);
                    DataBrowserWellToolBar.this.zoomSlider.addChangeListener(DataBrowserWellToolBar.this.zoomListener);
                }
            }
        });
        this.zoomSlider = new OneKnobSlider(0, 2, 25, (int)(scale * 10.0));
        this.zoomListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object src = e.getSource();
                if (src == DataBrowserWellToolBar.this.zoomSlider) {
                    int v = DataBrowserWellToolBar.this.zoomSlider.getValue();
                    double f = (double)v / 10.0;
                    DataBrowserWellToolBar.this.view.setMagnificationFactor(f);
                    DataBrowserWellToolBar.this.firePropertyChange("magnificationUpdate", null, f);
                    DataBrowserFactory.setThumbnailScaleFactor(f);
                }
            }
        };
        this.zoomSlider.addChangeListener(this.zoomListener);
        this.zoomSlider.setToolTipText("Magnifies the thumbnails.");
    }

    private JToolBar buildViewsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.add(this.refreshButton);
        bar.add(this.rollOverButton);
        if (this.fields != null) {
            bar.add(this.fields);
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.mag);
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.zoomSlider);
            bar.add(Box.createHorizontalStrut(5));
            bar.add((Component)this.busyLabel);
        }
        return bar;
    }

    private void buildGUI() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        JPanel p = new JPanel();
        p.add(this.buildViewsBar());
        content.add(p);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(content);
    }

    DataBrowserWellToolBar(DataBrowserUI view, DataBrowserControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void setStatus(boolean busy) {
        SwingUtilities.invokeLater(() -> {
            this.busyLabel.setVisible(busy);
            this.busyLabel.setBusy(busy);
        });
    }

    void displayFieldsOptions(boolean show) {
        this.refreshButton.setEnabled(!show);
        if (this.fields != null) {
            this.fields.setEnabled(show);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.view.setRollOver(this.rollOverButton.isSelected());
            }
        }
    }
}

