/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;

public class OntologyElement {
    private String val;
    private String id;
    private String uri;
    private String onto_name;

    public OntologyElement(String val, String id, String uri) {
        this.val = val;
        this.parseId(id);
        this.uri = uri;
        ImporterAgent.getRegistry().getLogger().debug(null, "[MDE] -- SET OntologyElement:" + this.toString());
    }

    private void parseId(String accession) {
        if (accession == null) {
            this.id = "";
            this.onto_name = "";
            return;
        }
        int brkIdx = -1;
        brkIdx = accession.indexOf("_");
        if (brkIdx == -1) {
            this.id = accession;
            this.onto_name = "";
        } else {
            this.id = accession.substring(brkIdx + 1, accession.length());
            this.onto_name = accession.substring(0, brkIdx);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public String getOntologyName() {
        return this.onto_name;
    }

    public String toString() {
        return String.format("{name:%s,id:%s,uri:%s}", this.getName(), this.getAccession(), this.getUri());
    }

    public String getName() {
        return this.val;
    }

    public String getAccession() {
        if (this.getOntologyName().equals("")) {
            return this.getId();
        }
        return String.format("%s_%s", this.getOntologyName(), this.getId());
    }
}

