/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.ui;

import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.agents.measurement.util.model.FigureTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.model.ValueType;
import org.openmicroscopy.shoola.agents.measurement.util.ui.InspectorCellRenderer;

public class FigureTable
extends JTable
implements DocumentListener {
    public static final String VALUE_CHANGED_PROPERTY = "valueChanged";
    private FigureTableModel tableModel;
    private TableCellRenderer renderer;

    public FigureTable(FigureTableModel model) {
        super(model);
        this.tableModel = model;
    }

    public AttributeField getFieldAt(int row) {
        return this.tableModel.getFieldAt(row);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.renderer == null) {
            this.renderer = new InspectorCellRenderer();
        }
        return this.renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        AttributeField field = this.tableModel.getFieldAt(row);
        InspectorCellRenderer renderer = (InspectorCellRenderer)this.getCellRenderer(row, col);
        Object v = this.tableModel.getValueAt(row, col);
        if (field.getValueType() == ValueType.ENUM) {
            return new DefaultCellEditor((JComboBox)renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col));
        }
        if (v instanceof Double || v instanceof Integer || v instanceof Long || v instanceof String) {
            DefaultCellEditor editor = new DefaultCellEditor((JTextField)renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col));
            JTextField f = (JTextField)editor.getComponent();
            f.getDocument().addDocumentListener(this);
            return editor;
        }
        if (v instanceof Boolean) {
            return new DefaultCellEditor((JCheckBox)renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col));
        }
        return super.getCellEditor(row, col);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            String text = e.getDocument().getText(0, e.getDocument().getLength());
            this.firePropertyChange(VALUE_CHANGED_PROPERTY, null, text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            String text = e.getDocument().getText(0, e.getDocument().getLength());
            this.firePropertyChange(VALUE_CHANGED_PROPERTY, null, text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

