/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.IconManager;

public class ROIAssistantCellRenderer
extends JComponent
implements TableCellRenderer {
    private static final Color SELECTED_COLOUR = new Color(255, 206, 206);
    private static final Color FOCUS_COLOUR = new Color(255, 135, 135);
    private static final Icon ELLIPSE_ICON;
    private static final Icon SQUARE_ICON;
    private static final Icon POLYLINE_ICON;
    private static final Icon POLYGON_ICON;
    private static final Icon LINE_ICON;
    private static final Icon POINT_ICON;
    private static final Icon LINECONNECTION_ICON;
    private static final Icon TEXT_ICON;

    public ROIAssistantCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = new JLabel();
        label.setHorizontalAlignment(0);
        label.setOpaque(true);
        label.setBackground(Color.white);
        if (value instanceof String) {
            if (value.equals("Ellipse")) {
                label.setIcon(ELLIPSE_ICON);
            } else if (value.equals("Rectangle")) {
                label.setIcon(SQUARE_ICON);
            } else if (value.equals("Scribble")) {
                label.setIcon(POLYLINE_ICON);
            } else if (value.equals("Polygon")) {
                label.setIcon(POLYGON_ICON);
            } else if (value.equals("Line")) {
                label.setIcon(LINE_ICON);
            } else if (value.equals("LineConnection")) {
                label.setIcon(LINECONNECTION_ICON);
            } else if (value.equals("Point")) {
                label.setIcon(POINT_ICON);
            } else if (value.equals("Text")) {
                label.setIcon(TEXT_ICON);
            } else {
                label.setText((String)value);
                label.setHorizontalTextPosition(0);
            }
        }
        if (isSelected) {
            label.setBackground(SELECTED_COLOUR);
        }
        if (hasFocus) {
            label.setBackground(FOCUS_COLOUR);
        }
        JLabel thisComponent = label;
        return thisComponent;
    }

    static {
        IconManager icons = IconManager.getInstance();
        ELLIPSE_ICON = icons.getIcon(15);
        SQUARE_ICON = icons.getIcon(14);
        POLYLINE_ICON = icons.getIcon(16);
        POLYGON_ICON = icons.getIcon(17);
        LINE_ICON = icons.getIcon(21);
        POINT_ICON = icons.getIcon(20);
        LINECONNECTION_ICON = icons.getIcon(22);
        TEXT_ICON = icons.getIcon(23);
    }
}

