/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class LDAPLoader
extends EditorLoader {
    private CallHandle handle;
    private long userID;

    public LDAPLoader(Editor viewer, SecurityContext ctx, long userID) {
        super(viewer, ctx);
        this.userID = userID;
    }

    @Override
    public void load() {
        this.handle = this.adminView.lookupLdapAuthExperimenter(this.ctx, this.userID, this);
    }

    @Override
    public void handleException(Throwable exc) {
        this.viewer.setStatus(false);
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.viewer.setLDAPDetails(this.userID, "No LDAP information found");
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof String) {
            this.viewer.setLDAPDetails(this.userID, (String)result);
        }
    }
}

