/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DisplayModeAction
extends TreeViewerAction {
    private static final String NAME_GROUP = "Group Display";
    private static final String NAME_EXPERIMENTER = "User Display";
    private static final String DESCRIPTION_EXP = "Display the data per user";
    private static final String DESCRIPTION_GROUP = "Display the data per group";
    private int index;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: {
                this.index = index;
                break;
            }
            default: {
                this.index = 1;
            }
        }
    }

    private void setDetails() {
        switch (this.index) {
            case 0: {
                this.putValue("Name", NAME_GROUP);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_GROUP));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_EXPERIMENTER);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_EXP));
            }
        }
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        this.setEnabled(this.model.getState() == 7);
    }

    public DisplayModeAction(TreeViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.setEnabled(true);
        this.setDetails();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.setDisplayMode(this.index);
    }
}

