/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ActivatedUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.AddAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowseContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClearAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateObjectWithChildren;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateTopContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.DisplayModeAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.DownloadAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ExitApplicationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FinderAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FullScreenViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.GroupSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ImportAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.InspectorVisibilityAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.LogOffAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManageObjectAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.MetadataVisibilityAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.MoveToAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.NewObjectAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PasswordResetAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PersonalManagementAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshTreeAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RemoveExperimenterNode;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RemoveGroupNode;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RollOverAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RunScriptAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SaveResultsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SearchAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SendFeedbackAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchGroup;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TaggingAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.UploadScriptAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewImageAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewInPlugin;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewOtherAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CopyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CutCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteRndSettingsCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TaskPaneBrowser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.DataObjectRegistration;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.JXTaskPaneContainerSingle;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class TreeViewerControl
implements ChangeListener,
PropertyChangeListener,
WindowFocusListener {
    static final Integer BROWSE = 1;
    static final Integer CREATE_OBJECT = 3;
    static final Integer COPY_OBJECT = 4;
    static final Integer PASTE_OBJECT = 5;
    static final Integer DELETE_OBJECT = 6;
    static final Integer HIERARCHY_EXPLORER = 7;
    static final Integer IMAGES_EXPLORER = 9;
    static final Integer FIND = 10;
    static final Integer EXIT = 14;
    static final Integer CLEAR = 15;
    static final Integer ADD_OBJECT = 16;
    static final Integer CREATE_TOP_PROJECT = 17;
    static final Integer REFRESH_TREE = 18;
    static final Integer MANAGER = 19;
    static final Integer CUT_OBJECT = 21;
    static final Integer ACTIVATION = 22;
    static final Integer SWITCH_USER = 23;
    static final Integer ROLL_OVER = 26;
    static final Integer REMOVE_FROM_DISPLAY = 27;
    static final Integer REFRESH_EXPERIMENTER = 29;
    static final Integer PASTE_RND_SETTINGS = 31;
    static final Integer COPY_RND_SETTINGS = 32;
    static final Integer RESET_RND_SETTINGS = 33;
    static final Integer SEARCH = 34;
    static final Integer TAGS_EXPLORER = 35;
    static final Integer SET_RND_SETTINGS = 36;
    static final Integer CREATE_TOP_DATASET = 37;
    static final Integer CREATE_TOP_TAG = 38;
    static final Integer SCREENS_EXPLORER = 39;
    static final Integer CREATE_TOP_SCREEN = 40;
    static final Integer VIEW = 41;
    static final Integer NEW_OBJECT = 42;
    static final Integer FILES_EXPLORER = 44;
    static final Integer CREATE_TOP_TAG_SET = 45;
    static final Integer NEW_TAG_OBJECT = 46;
    static final Integer TAGGING = 47;
    static final Integer INSPECTOR = 50;
    static final Integer FILE_SYSTEM_EXPLORER = 52;
    static final Integer IMPORT = 53;
    static final Integer DOWNLOAD = 54;
    static final Integer BROWSE_NO_THUMBNAILS = 55;
    static final Integer VIEWER_WITH_OTHER = 56;
    static final Integer PERSONAL = 57;
    static final Integer FULLSCREEN = 58;
    static final Integer METADATA = 59;
    static final Integer UPLOAD_SCRIPT = 60;
    static final Integer CREATE_TOP_GROUP = 61;
    static final Integer CREATE_TOP_EXPERIMENTER = 62;
    static final Integer RESET_PASSWORD = 63;
    static final Integer SET_OWNER_RND_SETTINGS = 64;
    static final Integer SEND_COMMENT = 65;
    static final Integer USER_ACTIVATED = 66;
    static final Integer IMPORT_NO_SELECTION = 67;
    static final Integer LOG_OFF = 68;
    static final Integer CREATE_DATASET_FROM_SELECTION = 69;
    static final Integer AVAILABLE_SCRIPTS = 70;
    static final Integer REMOVE_GROUP = 71;
    static final Integer VIEW_IN_IJ = 72;
    static final Integer SWITCH_GROUP = 73;
    static final Integer VIEW_IN_KNIME = 74;
    static final Integer DISPLAY_EXPERIMENTER = 75;
    static final Integer DISPLAY_GROUP = 76;
    static final Integer SAVE_TO_OMERO = 77;
    private TreeViewer model;
    private TreeViewerWin view;
    private Map<Integer, TreeViewerAction> actionsMap;
    private ChangeListener tabsListener;
    private LoadingWindow loadingWindow;
    private List<MoveToAction> moveActions;

    private void downloadScript(ScriptActivityParam param) {
        FileChooser chooser = new FileChooser(this.view, 1, "Download", "Select where to download the file.", null, true);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(109));
        chooser.setSelectedFileFull(param.getScript().getName());
        chooser.setApproveButtonText("Download");
        final long id = param.getScript().getScriptID();
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File[] files = (File[])evt.getNewValue();
                    File folder = files[0];
                    IconManager icons = IconManager.getInstance();
                    DownloadActivityParam activity = new DownloadActivityParam(id, 0, folder, icons.getIcon(110));
                    UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                    SecurityContext ctx = new SecurityContext(TreeViewerAgent.getUserDetails().getDefaultGroup().getId());
                    un.notifyActivity(ctx, activity);
                }
            }
        });
        chooser.centerDialog();
    }

    private void handleTaskPaneSelection(JXTaskPane pane) {
        JXTaskPaneContainerSingle container = (JXTaskPaneContainerSingle)((Object)pane.getParent());
        if (pane.isCollapsed() && container.hasTaskPaneExpanded()) {
            return;
        }
        int state = this.model.getState();
        if (state == 7 || state == 1) {
            this.model.clearFoundResults();
            if (!container.hasTaskPaneExpanded()) {
                this.model.setSelectedBrowser(null, true);
            } else if (pane instanceof TaskPaneBrowser) {
                TaskPaneBrowser p = (TaskPaneBrowser)pane;
                if (p.getBrowser() != null) {
                    this.model.setSelectedBrowser(p.getBrowser(), true);
                } else {
                    this.model.setSelectedBrowser(null, true);
                    this.model.showSearch();
                }
            } else {
                this.model.setSelectedBrowser(null, true);
            }
        } else {
            pane.setCollapsed(true);
        }
    }

    private void createActions() {
        this.actionsMap.put(BROWSE, new BrowseContainerAction(this.model));
        this.actionsMap.put(BROWSE_NO_THUMBNAILS, new BrowseContainerAction(this.model, false));
        this.actionsMap.put(CREATE_OBJECT, new CreateAction(this.model));
        this.actionsMap.put(COPY_OBJECT, new ManageObjectAction(this.model, 0));
        this.actionsMap.put(DELETE_OBJECT, new ManageObjectAction(this.model, 2));
        this.actionsMap.put(PASTE_OBJECT, new ManageObjectAction(this.model, 1));
        this.actionsMap.put(CUT_OBJECT, new ManageObjectAction(this.model, 3));
        this.actionsMap.put(SCREENS_EXPLORER, new BrowserSelectionAction(this.model, 1));
        this.actionsMap.put(HIERARCHY_EXPLORER, new BrowserSelectionAction(this.model, 0));
        this.actionsMap.put(TAGS_EXPLORER, new BrowserSelectionAction(this.model, 2));
        this.actionsMap.put(IMAGES_EXPLORER, new BrowserSelectionAction(this.model, 5));
        this.actionsMap.put(FILES_EXPLORER, new BrowserSelectionAction(this.model, 3));
        this.actionsMap.put(FILE_SYSTEM_EXPLORER, new BrowserSelectionAction(this.model, 4));
        this.actionsMap.put(FIND, new FinderAction(this.model));
        this.actionsMap.put(CLEAR, new ClearAction(this.model));
        this.actionsMap.put(EXIT, new ExitApplicationAction(this.model));
        this.actionsMap.put(ADD_OBJECT, new AddAction(this.model));
        this.actionsMap.put(CREATE_TOP_PROJECT, new CreateTopContainerAction(this.model, 0));
        this.actionsMap.put(CREATE_TOP_DATASET, new CreateTopContainerAction(this.model, 1));
        this.actionsMap.put(CREATE_TOP_TAG, new CreateTopContainerAction(this.model, 2));
        this.actionsMap.put(REFRESH_TREE, new RefreshTreeAction(this.model));
        this.actionsMap.put(MANAGER, new ManagerAction(this.model));
        this.actionsMap.put(ACTIVATION, new ActivationAction(this.model));
        this.actionsMap.put(SWITCH_USER, new SwitchUserAction(this.model));
        this.actionsMap.put(ROLL_OVER, new RollOverAction(this.model));
        this.actionsMap.put(REMOVE_FROM_DISPLAY, new RemoveExperimenterNode(this.model));
        this.actionsMap.put(REFRESH_EXPERIMENTER, new RefreshExperimenterData(this.model));
        this.actionsMap.put(PASTE_RND_SETTINGS, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(COPY_RND_SETTINGS, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(RESET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(SET_OWNER_RND_SETTINGS, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(SEARCH, new SearchAction(this.model));
        this.actionsMap.put(SET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(CREATE_TOP_SCREEN, new CreateTopContainerAction(this.model, 3));
        this.actionsMap.put(VIEW, new ViewImageAction(this.model));
        this.actionsMap.put(NEW_OBJECT, new NewObjectAction(this.model, 1));
        this.actionsMap.put(CREATE_TOP_TAG_SET, new CreateTopContainerAction(this.model, 6));
        this.actionsMap.put(NEW_TAG_OBJECT, new NewObjectAction(this.model, 0));
        this.actionsMap.put(TAGGING, new TaggingAction(this.model));
        this.actionsMap.put(INSPECTOR, new InspectorVisibilityAction(this.model));
        this.actionsMap.put(IMPORT, new ImportAction(this.model, false));
        this.actionsMap.put(DOWNLOAD, new DownloadAction(this.model));
        this.actionsMap.put(VIEWER_WITH_OTHER, new ViewOtherAction(this.model, null));
        this.actionsMap.put(PERSONAL, new PersonalManagementAction(this.model));
        this.actionsMap.put(FULLSCREEN, new FullScreenViewerAction(this.model));
        this.actionsMap.put(METADATA, new MetadataVisibilityAction(this.model));
        this.actionsMap.put(UPLOAD_SCRIPT, new UploadScriptAction(this.model));
        this.actionsMap.put(CREATE_TOP_GROUP, new CreateTopContainerAction(this.model, 7));
        this.actionsMap.put(CREATE_TOP_EXPERIMENTER, new CreateTopContainerAction(this.model, 8));
        this.actionsMap.put(RESET_PASSWORD, new PasswordResetAction(this.model));
        this.actionsMap.put(USER_ACTIVATED, new ActivatedUserAction(this.model));
        this.actionsMap.put(SEND_COMMENT, new SendFeedbackAction(this.model));
        this.actionsMap.put(IMPORT_NO_SELECTION, new ImportAction(this.model, true));
        this.actionsMap.put(LOG_OFF, new LogOffAction(this.model));
        this.actionsMap.put(CREATE_DATASET_FROM_SELECTION, new CreateObjectWithChildren(this.model, 1));
        this.actionsMap.put(VIEW_IN_IJ, new ViewInPlugin(this.model, 1));
        this.actionsMap.put(VIEW_IN_KNIME, new ViewInPlugin(this.model, 2));
        this.actionsMap.put(AVAILABLE_SCRIPTS, new RunScriptAction(this.model));
        this.actionsMap.put(REMOVE_GROUP, new RemoveGroupNode(this.model));
        this.actionsMap.put(SWITCH_GROUP, new SwitchGroup(this.model));
        this.actionsMap.put(DISPLAY_GROUP, new DisplayModeAction(this.model, 0));
        this.actionsMap.put(DISPLAY_EXPERIMENTER, new DisplayModeAction(this.model, 1));
        this.actionsMap.put(SAVE_TO_OMERO, new SaveResultsAction(this.model, 1));
    }

    private void createWindowsMenuItems(JMenu menu) {
        Set viewers = TreeViewerFactory.getViewers();
        Iterator i = viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction((TreeViewer)i.next())));
        }
    }

    private void attachListeners() {
        if (UIUtilities.isMacOS()) {
            try {
                MacOSMenuHandler handler = new MacOSMenuHandler(this.view);
                handler.initialize();
                this.view.addPropertyChangeListener(this);
            }
            catch (Throwable handler) {
                // empty catch block
            }
        }
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        for (Browser browser : browsers.values()) {
            browser.addPropertyChangeListener(this);
            browser.addChangeListener(this);
        }
        this.view.addWindowFocusListener(this);
        this.model.addPropertyChangeListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TreeViewerControl.this.model.closeWindow();
            }
        });
        JMenu menu = TreeViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
    }

    TreeViewerControl(TreeViewer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, TreeViewerAction>();
    }

    void initialize(TreeViewerWin view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.model.addChangeListener(this);
        this.attachListeners();
        TreeViewerFactory.attachWindowMenuToTaskBar();
        this.loadingWindow = new LoadingWindow(view);
        this.loadingWindow.setAlwaysOnTop(false);
        this.loadingWindow.setStatus("Saving changes");
    }

    int getSelectedBrowserType() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return -1;
        }
        return browser.getBrowserType();
    }

    List<ViewOtherAction> getApplicationActions() {
        ArrayList<ViewOtherAction> l = new ArrayList<ViewOtherAction>();
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return l;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d == null) {
            return l;
        }
        Object object = d.getUserObject();
        if (!(object instanceof DataObject)) {
            return l;
        }
        String type = this.view.getObjectMimeType();
        if (type == null) {
            return l;
        }
        List<ApplicationData> applications = TreeViewerFactory.getApplications(type);
        if (applications == null) {
            return l;
        }
        for (ApplicationData data : applications) {
            l.add(new ViewOtherAction(this.model, data));
        }
        return l;
    }

    List<MoveToAction> getMoveAction() {
        Browser browser = this.model.getSelectedBrowser();
        List selection = null;
        ArrayList<Long> owners = new ArrayList<Long>();
        if (browser != null) {
            selection = browser.getSelectedDataObjects();
            if (selection.isEmpty()) {
                return null;
            }
            int count = 0;
            for (Object o : selection) {
                if (!(o instanceof DataObject) || o instanceof GroupData || o instanceof ExperimenterData || o instanceof PlateAcquisitionData || o instanceof TagAnnotationData || !this.model.canChgrp(o)) continue;
                DataObject data = (DataObject)o;
                if (!owners.contains(data.getOwner().getId())) {
                    owners.add(data.getOwner().getId());
                }
                ++count;
            }
            if (count != selection.size()) {
                return null;
            }
            if (owners.size() > 1) {
                return null;
            }
        }
        long userID = TreeViewerAgent.getUserDetails().getId();
        long ownerID = -1L;
        if (owners.size() > 0) {
            ownerID = (Long)owners.get(0);
        }
        List<GroupData> l = null;
        if (ownerID == userID) {
            l = TreeViewerAgent.getAvailableUserGroups();
        } else if (TreeViewerAgent.isAdministrator()) {
            SecurityContext ctx = TreeViewerAgent.getAdminContext();
            try {
                l = TreeViewerAgent.getRegistry().getAdminService().loadGroupsForExperimenter(ctx, ownerID);
            }
            catch (Exception e) {
                TreeViewerAgent.getRegistry().getLogger().error((Object)this, "cannot retrieve user's groups");
            }
        }
        if (l == null) {
            return null;
        }
        if (this.moveActions == null) {
            this.moveActions = new ArrayList<MoveToAction>(l.size());
        }
        this.moveActions.clear();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (browser != null && selection != null) {
            for (DataObject data : selection) {
                if (ids.contains(data.getGroupId())) continue;
                ids.add(data.getGroupId());
            }
        }
        ViewerSorter sorter = new ViewerSorter();
        List values = sorter.sort(l);
        if (this.moveActions == null) {
            this.moveActions = new ArrayList<MoveToAction>(l.size());
        }
        this.moveActions.clear();
        for (GroupData group : values) {
            if (ids.contains(group.getGroupId())) continue;
            this.moveActions.add(new MoveToAction(this.model, group));
        }
        return this.moveActions;
    }

    ChangeListener getTabbedListener() {
        if (this.tabsListener == null) {
            this.tabsListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    JTabbedPane pane = (JTabbedPane)ce.getSource();
                    TreeViewerControl.this.model.clearFoundResults();
                    Component c = pane.getSelectedComponent();
                    if (c == null) {
                        TreeViewerControl.this.model.setSelectedBrowser(null, true);
                        return;
                    }
                    Map<Integer, Browser> browsers = TreeViewerControl.this.model.getBrowsers();
                    Iterator<Browser> i = browsers.values().iterator();
                    boolean selected = false;
                    while (i.hasNext()) {
                        Browser browser = i.next();
                        if (!c.equals(browser.getUI())) continue;
                        TreeViewerControl.this.model.setSelectedBrowser(browser, true);
                        selected = true;
                        break;
                    }
                    if (!selected) {
                        TreeViewerControl.this.model.setSelectedBrowser(null, true);
                    }
                }
            };
        }
        return this.tabsListener;
    }

    void attachUIListeners(JComponent component) {
        if (component instanceof JTabbedPane) {
            ((JTabbedPane)component).addChangeListener(this.getTabbedListener());
        } else if (component instanceof JXTaskPaneContainer) {
            component.addPropertyChangeListener("selectedTaskPane", this);
        }
    }

    TreeViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    List<GroupSelectionAction> getUserGroupAction(boolean add) {
        ArrayList<GroupSelectionAction> l = new ArrayList<GroupSelectionAction>();
        Collection m = TreeViewerAgent.getAvailableUserGroups();
        if (m == null || m.size() == 0) {
            return l;
        }
        ViewerSorter sorter = new ViewerSorter();
        Iterator i = sorter.sort(m).iterator();
        while (i.hasNext()) {
            l.add(new GroupSelectionAction(this.model, (GroupData)i.next(), add));
        }
        return l;
    }

    private void handleScript(ScriptObject script, int index) {
        if (script == null) {
            return;
        }
        SecurityContext ctx = new SecurityContext(TreeViewerAgent.getUserDetails().getDefaultGroup().getId());
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        if (index == 3) {
            Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
            Object path = env.getOmeroFilesHome();
            path = (String)path + File.separator + script.getName();
            File f = new File((String)path);
            DownloadAndLaunchActivityParam activity = new DownloadAndLaunchActivityParam(script.getScriptID(), 0, f, null);
            un.notifyActivity(ctx, activity);
        } else if (index == 2) {
            this.downloadScript(new ScriptActivityParam(script, 2));
        } else {
            long groupID = script.getGroupID();
            if (groupID < 0L) {
                GroupData g = this.model.getSelectedGroup();
                if (g == null) {
                    g = TreeViewerAgent.getUserDetails().getDefaultGroup();
                }
                groupID = g.getId();
            }
            ctx = new SecurityContext(groupID);
            un.notifyActivity(ctx, new ScriptActivityParam(script, 0));
        }
    }

    TreeImageDisplay getLastSelectedDisplay() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return null;
        }
        return browser.getLastSelectedDisplay();
    }

    void activateUser() {
        TreeImageDisplay node = this.getLastSelectedDisplay();
        if (node != null && node.getUserObject() instanceof ExperimenterData) {
            this.model.activateUser((ExperimenterData)node.getUserObject());
        }
    }

    void cancel() {
        this.model.cancel();
    }

    void reloadAvailableScripts(Point location, Component source) {
        this.model.showMenu(10, source, location);
    }

    void handleScriptSelection(ScriptObject object) {
        if (object == null) {
            return;
        }
        if (!object.isParametersLoaded()) {
            this.model.loadScript(object.getScriptID());
        } else {
            this.model.setScript(object);
        }
    }

    void showMenu(int menuID, Component invoker, Point loc) {
        this.model.showMenu(menuID, invoker, loc);
    }

    void setSelection(GroupData group, List<ExperimenterData> seletectedUsers, boolean removeGroup) {
        if (removeGroup) {
            this.model.removeGroup(group.getId());
        } else {
            if (this.model.getGroups().size() > 1) {
                this.model.setUserGroup(Arrays.asList(group));
            }
            this.model.setHierarchyRoot(group.getId(), seletectedUsers);
        }
    }

    void setSelectedGroups(List<GroupData> toAdd, List<GroupData> toRemove) {
        if (toRemove != null) {
            Iterator<GroupData> i = toRemove.iterator();
            while (i.hasNext()) {
                this.model.removeGroup(i.next().getId());
            }
        }
        this.model.setUserGroup(toAdd);
    }

    boolean isOrphanedImagesSelected() {
        Browser b = this.model.getSelectedBrowser();
        if (b == null) {
            return false;
        }
        TreeImageDisplay[] nodes = b.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay n = nodes[i];
            TreeImageDisplay np = n.getParentDisplay();
            if (!(np instanceof TreeFileSet) || ((TreeFileSet)np).getType() != 5) continue;
            return true;
        }
        return false;
    }

    void setDisplayMode(int mode) {
        this.model.setDisplayMode(mode);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name == null) {
            return;
        }
        if ("cancelLoading".equals(name)) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.cancel();
            }
        } else if ("popupMenu".equals(name)) {
            Integer c = (Integer)pce.getNewValue();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                this.view.showPopup(c, browser.getClickComponent(), browser.getClickPoint());
            }
        } else if ("close".equals(name)) {
            Browser browser = (Browser)pce.getNewValue();
            if (browser != null) {
                this.view.removeBrowser(browser);
            }
        } else if ("finderVisible".equals(name)) {
            Boolean b = (Boolean)pce.getNewValue();
            if (!b.booleanValue()) {
                this.model.clearFoundResults();
                this.model.onComponentStateChange(true);
            }
        } else if ("selectedBrowser".equals(name)) {
            Browser b = this.model.getSelectedBrowser();
            for (Browser browser : this.model.getBrowsers().values()) {
                browser.setSelected(browser.equals(b));
            }
        } else if ("selectedTreeNodeDisplay".equals(name)) {
            this.model.onSelectedDisplay();
            this.view.updateMenuItems();
        } else if (!"hierarchyRoot".equals(name)) {
            if ("existingAdd".equals(name)) {
                this.model.addExistingObjects((Set)pce.getNewValue());
            } else if ("userSwitch".equals(name)) {
                Map m = (Map)pce.getNewValue();
                for (Map.Entry entry : m.entrySet()) {
                    Long groupID = (Long)entry.getKey();
                    List users = (List)entry.getValue();
                    this.model.setHierarchyRoot(groupID, users);
                }
            } else if ("noUserSwitch".equals(name)) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("User Selection", "Please select a user first.");
            } else if ("create".equals(name)) {
                DataObject data = (DataObject)pce.getNewValue();
                this.model.createObject(data, true);
            } else if ("createNoParent".equals(name)) {
                DataObject data = (DataObject)pce.getNewValue();
                this.model.createObject(data, false);
            } else if ("onDataSave".equals(name)) {
                Object object = pce.getNewValue();
                if (object != null) {
                    if (object instanceof DataObject) {
                        this.model.onDataObjectSave((DataObject)object, 301);
                    } else {
                        this.model.onDataObjectSave((List)object, 301);
                    }
                }
            } else if ("selectedNodeDisplay".equals(name)) {
                this.model.setSelectedNode(pce.getNewValue());
            } else if ("unselectedNodeDisplay".equals(name)) {
                this.model.setUnselectedNode(pce.getNewValue());
            } else if ("dataObjectCreated".equals(name)) {
                Map map = (Map)pce.getNewValue();
                if (map != null && map.size() == 1) {
                    DataObject data = null;
                    Set set = map.entrySet();
                    Iterator i = set.iterator();
                    DataObject parent = null;
                    if (i.hasNext()) {
                        Map.Entry entry = i.next();
                        data = (DataObject)entry.getKey();
                        Object o = entry.getValue();
                        if (o != null) {
                            parent = (DataObject)o;
                        }
                    }
                    if (parent == null) {
                        this.model.onOrphanDataObjectCreated(data);
                    } else {
                        this.model.onDataObjectSave(data, parent, 300);
                    }
                }
            } else if ("addedToDataObject".equals(name)) {
                this.model.refreshTree();
            } else if ("copyRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                if (data != null) {
                    this.model.copyRndSettings((ImageData)data);
                } else {
                    this.model.copyRndSettings(null);
                }
            } else if ("pasteRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 0, (Collection)data) : new PasteRndSettingsCmd(this.model, 0);
                cmd.execute();
            } else if ("resetRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 1, (Collection)data) : new PasteRndSettingsCmd(this.model, 1);
                cmd.execute();
            } else if ("setOriginalRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 2, (Collection)data) : new PasteRndSettingsCmd(this.model, 2);
                cmd.execute();
            } else if ("setOriginalRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 3, (Collection)data) : new PasteRndSettingsCmd(this.model, 3);
                cmd.execute();
            } else if ("cutItems".equals(name)) {
                CutCmd cmd = new CutCmd(this.model);
                cmd.execute();
            } else if ("copyItems".equals(name)) {
                CopyCmd cmd = new CopyCmd(this.model);
                cmd.execute();
            } else if ("pasteItems".equals(name)) {
                PasteCmd cmd = new PasteCmd(this.model);
                cmd.execute();
            } else if ("removeItems".equals(name)) {
                DeleteCmd cmd = new DeleteCmd(this.model.getSelectedBrowser());
                cmd.execute();
            } else if ("viewImageNode".equals(name)) {
                Browser browser = this.model.getSelectedBrowser();
                if (browser != null) {
                    TreeImageDisplay node = browser.getLastSelectedDisplay();
                    this.model.browse(node, (DataObject)pce.getNewValue(), false);
                }
            } else if ("internalViewImageNode".equals(name)) {
                ViewCmd cmd = new ViewCmd(this.model, true);
                cmd.execute();
            } else if ("resultsFound".equals(name)) {
                this.model.setSearchResult(pce.getNewValue());
            } else if ("saveGeneric".equals(name)) {
                Object parent = pce.getNewValue();
                if (parent instanceof MetadataViewer) {
                    MetadataViewer mv = (MetadataViewer)parent;
                    mv.saveData();
                }
            } else if ("dataRefreshed".equals(name)) {
                this.model.onSelectedDisplay();
            } else if ("adminUpdated".equals(name)) {
                Object data = pce.getNewValue();
                Map<Integer, Browser> browsers = this.model.getBrowsers();
                Set<Map.Entry<Integer, Browser>> set = browsers.entrySet();
                for (Map.Entry<Integer, Browser> entry : set) {
                    Browser browser = entry.getValue();
                    browser.refreshAdmin(data);
                }
                this.view.createTitle();
            } else if ("tagWizard".equals(name)) {
                this.model.showTagWizard();
            } else if ("fieldSelected".equals(name)) {
                this.model.setSelectedField(pce.getNewValue());
            } else if ("renderThumbnail".equals(name)) {
                long imageID = (Long)pce.getNewValue();
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(imageID);
                this.view.reloadThumbnails(ids);
            } else if ("applySettings".equals(name)) {
                Object object = pce.getNewValue();
                if (object instanceof ImageData) {
                    ImageData img = (ImageData)object;
                    this.model.copyRndSettings((ImageData)object);
                    ArrayList<Long> ids = new ArrayList<Long>(1);
                    ids.add(img.getId());
                    this.view.reloadThumbnails(ids);
                    List l = this.model.getSelectedBrowser().getSelectedDataObjects();
                    Collection toUpdate = l.size() > 1 ? l : this.model.getDisplayedImages();
                    if (toUpdate != null) {
                        PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 0, toUpdate);
                        cmd.execute();
                    }
                } else if (object instanceof Object[]) {
                    Object[] objects = (Object[])object;
                    WellSampleData wsd = (WellSampleData)objects[0];
                    long plateId = (Long)objects[1];
                    ImageData img = wsd.getImage();
                    this.model.copyRndSettings(img);
                    this.model.pasteRndSettings(Arrays.asList(plateId), PlateData.class);
                }
            } else if ("selectedTaskPane".equals(name)) {
                this.handleTaskPaneSelection((JXTaskPane)pce.getNewValue());
            } else if ("generateFigure".equals(name)) {
                TreeImageDisplay[] nodes;
                Browser browser;
                ArrayList<DataObject> l;
                Object object = pce.getNewValue();
                if (!(object instanceof FigureParam)) {
                    return;
                }
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                IconManager icons = IconManager.getInstance();
                ImageIcon icon = icons.getIcon(107);
                ArrayList<Long> ids = new ArrayList<Long>();
                FigureParam param = (FigureParam)object;
                if (param.isSelectedObjects()) {
                    Browser b = this.model.getSelectedBrowser();
                    if (b != null) {
                        l = b.getSelectedDataObjects();
                    } else {
                        l = new ArrayList<DataObject>();
                        Collection<DataObject> nodes2 = this.model.getSelectedObjectsFromBrowser();
                        if (nodes2 != null) {
                            l.addAll(nodes2);
                        }
                    }
                } else {
                    l = this.model.getDisplayedImages();
                }
                if (CollectionUtils.isEmpty((Collection)l)) {
                    return;
                }
                Class<?> klass = null;
                Object p = null;
                if (param.getIndex() == 2 && (browser = this.model.getSelectedBrowser()) != null && (nodes = browser.getSelectedDisplays()) != null && nodes.length > 0) {
                    TreeImageDisplay node = nodes[0];
                    Object ho = node.getUserObject();
                    if (ho instanceof DatasetData) {
                        klass = ho.getClass();
                        p = ho;
                    } else if (ho instanceof ImageData) {
                        klass = ho.getClass();
                        TreeImageDisplay pNode = node.getParentDisplay();
                        if (pNode != null && !((p = pNode.getUserObject()) instanceof DatasetData)) {
                            p = null;
                        }
                        if (p == null) {
                            p = ho;
                        }
                    }
                    if (p != null) {
                        param.setAnchor((DataObject)p);
                    }
                }
                Iterator i = l.iterator();
                int n = 0;
                ArrayList<Long> groupIds = new ArrayList<Long>();
                boolean canRun = true;
                while (i.hasNext()) {
                    DataObject obj = (DataObject)i.next();
                    if (groupIds.size() == 0) {
                        groupIds.add(obj.getGroupId());
                    }
                    if (groupIds.contains(obj.getGroupId())) {
                        ids.add(obj.getId());
                        if (n == 0) {
                            p = obj;
                        }
                        ++n;
                        continue;
                    }
                    canRun = false;
                    break;
                }
                if (!canRun) {
                    un.notifyInfo("Script", "You can run the script only\non objects from the same group");
                    return;
                }
                if (ids.size() == 0) {
                    return;
                }
                if (param.getIndex() != 2) {
                    param.setAnchor((DataObject)p);
                }
                FigureActivityParam activity = new FigureActivityParam(object, ids, klass, 0);
                activity.setIcon(icon);
                un.notifyActivity(new SecurityContext((Long)groupIds.get(0)), activity);
            } else if ("handleScript".equals(name)) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                ScriptActivityParam p = (ScriptActivityParam)pce.getNewValue();
                int index = p.getIndex();
                ScriptObject script = p.getScript();
                if (index == 3) {
                    Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
                    Object path = env.getOmeroFilesHome();
                    path = (String)path + File.separator + script.getName();
                    File f = new File((String)path);
                    DownloadAndLaunchActivityParam activity = new DownloadAndLaunchActivityParam(p.getScript().getScriptID(), 0, f, null);
                    un.notifyActivity(this.model.getSecurityContext(), activity);
                } else if (index == 2) {
                    this.downloadScript(p);
                }
            } else if ("openDocument".equals(name)) {
                ApplicationData data = (ApplicationData)pce.getNewValue();
                if (data == null) {
                    return;
                }
                String format = this.view.getObjectMimeType();
                if (format != null) {
                    TreeViewerFactory.register(data, format);
                }
                this.model.openWith(data);
            } else if ("openExternalApplication".equals(name)) {
                this.model.openWith((ApplicationData)pce.getNewValue());
            } else if ("createAdmin".equals(name)) {
                AdminObject object = (AdminObject)pce.getNewValue();
                this.model.administrate(object);
            } else if ("register".equals(name)) {
                this.model.register((DataObjectRegistration)pce.getNewValue());
            } else if ("resetPassword".equals(name)) {
                this.model.resetPassword((String)pce.getNewValue());
            } else if ("uploadScript".equals(name)) {
                TreeViewerAction action = this.getAction(UPLOAD_SCRIPT);
                action.actionPerformed(new ActionEvent(this, 1, ""));
            } else if ("selectedItems".equals(name)) {
                Map m = (Map)pce.getNewValue();
                if (m == null || m.size() != 1) {
                    return;
                }
                for (Map.Entry entry : m.entrySet()) {
                    Object uo;
                    Class klass = (Class)entry.getKey();
                    if (!ExperimenterData.class.equals((Object)klass)) continue;
                    Collection list = (Collection)entry.getValue();
                    TreeImageDisplay node = this.model.getSelectedBrowser().getLastSelectedDisplay();
                    if (node == null || !((uo = node.getUserObject()) instanceof GroupData)) continue;
                    AdminObject object = new AdminObject((GroupData)uo, list);
                    this.model.administrate(object);
                }
            } else if ("setOwnerRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 3, (Collection)data) : new PasteRndSettingsCmd(this.model, 3);
                cmd.execute();
            } else if ("runSelectedScript".equals(name)) {
                this.handleScript((ScriptObject)pce.getNewValue(), 0);
            } else if ("downloadSelectedScript".equals(name)) {
                ScriptObject script;
                Object value = pce.getNewValue();
                if (value instanceof ScriptObject) {
                    this.handleScript((ScriptObject)value, 2);
                } else if (value instanceof String && (script = this.view.getScriptFromName((String)value)) != null) {
                    this.handleScript(script, 2);
                }
            } else if ("viewSelectedScript".equals(name)) {
                ScriptObject script;
                Object value = pce.getNewValue();
                if (value instanceof ScriptObject) {
                    this.handleScript((ScriptObject)value, 3);
                } else if (value instanceof String && (script = this.view.getScriptFromName((String)value)) != null) {
                    this.handleScript(script, 3);
                }
            } else if ("scriptsLoading".equals(name)) {
                this.view.setScriptsLoadingStatus(true);
            } else if ("scriptsLoaded".equals(name)) {
                this.view.setScriptsLoadingStatus(false);
            } else if ("selectedNodesDisplay".equals(name)) {
                this.model.setSelectedNodes(pce.getNewValue());
            } else if ("groupChanged".equals(name)) {
                this.view.setPermissions();
            } else if ("quitApplication".equals(name)) {
                TreeViewerAction a = this.getAction(EXIT);
                ActionEvent event = new ActionEvent(this, 1001, "");
                a.actionPerformed(event);
            } else if ("groupSwitch".equals(name)) {
                List groups = (List)pce.getNewValue();
                if (groups.size() == 0) {
                    UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                    un.notifyInfo("Groups Selection", "At least one group must be selected.");
                    return;
                }
                this.model.setUserGroup(groups);
            } else if ("activateUser".equals(name)) {
                ExperimenterData exp = (ExperimenterData)pce.getNewValue();
                if (exp != null) {
                    this.model.activateUser(exp);
                }
            } else if ("resetUserPassword".equals(name)) {
                this.getAction(RESET_PASSWORD).actionPerformed(new ActionEvent(pce.getNewValue(), 0, "Reset Password"));
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            switch (browser.getState()) {
                case 14: {
                    this.loadingWindow.setStatus("Loading Data...");
                    UIUtilities.centerAndShow(this.loadingWindow);
                    return;
                }
                case 15: {
                    this.loadingWindow.setVisible(false);
                }
            }
        }
        switch (this.model.getState()) {
            case 2: {
                this.view.closeViewer();
                break;
            }
            case 5: {
                this.view.setStatus("Loading Data...", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 3: {
                this.view.setStatus("Saving Data", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 6: 
            case 7: {
                this.loadingWindow.setVisible(false);
                this.view.setStatus(null, true);
                this.view.setStatusIcon(false);
                this.view.onStateChanged(true);
                this.view.requestFocus();
                break;
            }
            case 8: {
                UIUtilities.centerAndShow(this.loadingWindow);
            }
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.view.refreshRenderer();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }
}

