/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.util.Iterator;
import java.util.Map;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.grid.RepositoryPrx;
import org.openmicroscopy.shoola.env.data.FSAccessException;

public class FSFileSystemView {
    private static final String NO_NAME = "NoName";
    private Map<FileData, RepositoryPrx> repositories;
    private long userID;

    private Map.Entry getRepository(DataObject file) {
        block4: {
            block3: {
                if (!(file instanceof ImageData)) break block3;
                ImageData img = (ImageData)file;
                String refPath = img.getPathToFile();
                if (img.getIndex() >= 0) {
                    refPath = img.getParentFilePath();
                }
                for (Map.Entry<FileData, RepositoryPrx> entry : this.repositories.entrySet()) {
                    FileData data = entry.getKey();
                    String path = data.getAbsolutePath();
                    if (!refPath.startsWith(path)) continue;
                    return entry;
                }
                break block4;
            }
            if (!(file instanceof FileData)) break block4;
            FileData f = (FileData)file;
            String refPath = f.getAbsolutePath();
            for (Map.Entry<FileData, RepositoryPrx> entry : this.repositories.entrySet()) {
                FileData data = entry.getKey();
                String path = data.getAbsolutePath();
                if (!refPath.startsWith(path)) continue;
                return entry;
            }
        }
        return null;
    }

    FSFileSystemView(long userID, Map<FileData, RepositoryPrx> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException("No repositories specified.");
        }
        this.userID = userID;
        this.repositories = repositories;
    }

    public long getUserID() {
        return this.userID;
    }

    public boolean isRoot(FileData f) {
        if (f == null) {
            return false;
        }
        for (Map.Entry<FileData, RepositoryPrx> entry : this.repositories.entrySet()) {
            FileData data = entry.getKey();
            String path = data.getAbsolutePath();
            if (!path.equals(f.getAbsolutePath()) || data.getId() != f.getId()) continue;
            return true;
        }
        return false;
    }

    public FileData[] getRoots() {
        FileData[] files = new FileData[this.repositories.size()];
        Iterator<Map.Entry<FileData, RepositoryPrx>> i = this.repositories.entrySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Map.Entry<FileData, RepositoryPrx> entry = i.next();
            files[index] = entry.getKey();
            ++index;
        }
        return files;
    }

    public DataObject register(DataObject file) throws FSAccessException {
        return null;
    }

    public String getThumbnail(DataObject object) throws FSAccessException {
        return null;
    }

    public DataObject[] getFiles(FileData dir, boolean useFileHiding) throws FSAccessException {
        return null;
    }
}

