/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformsParser {
    public static String SPECIFICATION = "specification";
    static String TRANSFORM_FOLDER = "transforms/";
    private static String CATALOG = "transforms/ome-transforms.xml";
    private static String CURRENT = "current";
    private static String SOURCE = "source";
    private Document document;
    private List<Target> targets = new ArrayList<Target>();
    private String current;

    private void extractCurrentSchema(String schema) throws Exception {
        NodeList list = this.document.getElementsByTagName(SOURCE);
        for (int i = 0; i < list.getLength(); ++i) {
            Element n = (Element)list.item(i);
            NamedNodeMap map = n.getAttributes();
            for (int j = 0; j < map.getLength(); ++j) {
                Node attribute = map.item(j);
                if (!Target.SCHEMA.equals(attribute.getNodeName()) || !schema.equals(attribute.getNodeValue())) continue;
                NodeList t = n.getElementsByTagName(Target.TARGET);
                for (int k = 0; k < t.getLength(); ++k) {
                    Target target = new Target((Element)t.item(k));
                    target.parse();
                    this.targets.add(target);
                }
            }
        }
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public String getCurrentSchema() {
        return this.current;
    }

    public void parse() throws Exception {
        Object name = CATALOG;
        InputStream stream = null;
        if (!UIUtilities.isWindowsOS()) {
            name = "/" + (String)name;
            stream = this.getClass().getResourceAsStream((String)name);
        } else {
            stream = this.getClass().getClassLoader().getResourceAsStream((String)name);
        }
        if (stream == null) {
            throw new Exception("No Catalog found.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(stream);
            this.current = this.document.getDocumentElement().getAttribute(CURRENT);
            if (CommonsLangUtils.isBlank(this.current)) {
                throw new Exception("No schema specified.");
            }
            this.extractCurrentSchema(this.current);
        }
        catch (Exception e) {
            throw new Exception("Unable to parse the catalog.", e);
        }
        finally {
            stream.close();
        }
    }
}

