/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class SwitchUserLoader
extends UserNotifierLoader {
    private ExperimenterData experimenter;
    private long groupID;
    private CallHandle handle;

    public SwitchUserLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, ExperimenterData experimenter, long groupID) {
        super(viewer, registry, ctx, null);
        this.experimenter = experimenter;
        this.groupID = groupID;
    }

    @Override
    public void load() {
        this.handle = this.dhView.switchUserGroup(this.ctx, this.experimenter, this.groupID, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object result = fe.getPartialResult();
        if (result != null) {
            this.viewer.setStatus(result);
            if (result instanceof ExperimenterData) {
                this.registry.getEventBus().post(new UserGroupSwitched(true));
            }
        }
    }

    @Override
    public void handleNullResult() {
    }
}

