/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MultilineHeaderSelectionRenderer
extends JPanel
implements TableCellRenderer {
    private JList list;
    private JCheckBox box;
    private boolean mousePressed;
    private int column;
    private boolean initListener;
    private JTable table;

    private void handleClickEvent(MouseEvent event) {
        if (!this.mousePressed) {
            return;
        }
        this.mousePressed = false;
        JTableHeader header = (JTableHeader)event.getSource();
        if (header == null) {
            return;
        }
        if (this.table == null) {
            this.table = header.getTable();
        }
        if (this.table == null) {
            return;
        }
        TableColumnModel columnModel = this.table.getColumnModel();
        int vc = columnModel.getColumnIndexAtX(event.getX());
        int c = this.table.convertColumnIndexToModel(vc);
        if (vc == this.column && event.getClickCount() == 1 && c != -1) {
            this.box.doClick();
        }
        header.repaint();
    }

    public MultilineHeaderSelectionRenderer(JTable table, JCheckBox box) {
        this.table = table;
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        JLabel l = new JLabel();
        l.setOpaque(true);
        this.setBackground(l.getBackground());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.list = new JList();
        ListCellRenderer renderer = this.list.getCellRenderer();
        ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
        this.list.setCellRenderer(renderer);
        this.list.setBackground(l.getBackground());
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.list);
        this.box = box;
        if (box != null) {
            box.setBackground(l.getBackground());
            this.add(box);
        }
    }

    public MultilineHeaderSelectionRenderer(JCheckBox box) {
        this(null, box);
    }

    public MultilineHeaderSelectionRenderer() {
        this(null, null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (this.table == null) {
            this.table = t;
        }
        if (this.table != null && !this.initListener && this.box != null && (header = this.table.getTableHeader()) != null) {
            this.initListener = true;
            header.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MultilineHeaderSelectionRenderer.this.handleClickEvent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    MultilineHeaderSelectionRenderer.this.mousePressed = true;
                }
            });
        }
        this.column = column;
        if (this.table != null) {
            this.setFont(this.table.getFont());
        }
        String str = value == null ? "" : value.toString();
        BufferedReader br = new BufferedReader(new StringReader(str));
        Vector<String> v = new Vector<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.list.setListData(v);
        return this;
    }
}

