/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class ScrollablePopupMenu
extends JPopupMenu {
    public static final int ROWS = 30;
    protected int maximumVisibleRows;
    private JScrollBar verticalBar;

    private void initListeners() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                JScrollBar bar = ScrollablePopupMenu.this.getVerticalScrollBar();
                int amount = event.getScrollType() == 0 ? event.getUnitsToScroll() * bar.getUnitIncrement() : (event.getWheelRotation() < 0 ? -bar.getBlockIncrement() : bar.getBlockIncrement());
                bar.setValue(bar.getValue() + amount);
                event.consume();
            }
        });
    }

    public ScrollablePopupMenu() {
        this(30, 4);
    }

    public ScrollablePopupMenu(int location) {
        this(30, location);
    }

    public ScrollablePopupMenu(int visibleRows, int location) {
        super.add(this.getVerticalScrollBar());
        if (visibleRows <= 0) {
            visibleRows = 30;
        }
        this.maximumVisibleRows = visibleRows;
        this.setLayout(new ScrollPopupMenuLayout(location));
        this.initListeners();
    }

    protected JScrollBar getVerticalScrollBar() {
        if (this.verticalBar == null) {
            this.verticalBar = new JScrollBar(1);
            this.verticalBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent arg0) {
                    ScrollablePopupMenu.this.doLayout();
                    ScrollablePopupMenu.this.repaint();
                }
            });
            this.verticalBar.setVisible(false);
        }
        return this.verticalBar;
    }

    public int getMaximumVisibleRows() {
        return this.maximumVisibleRows;
    }

    public void setMaximumVisibleRows(int rows) {
        this.maximumVisibleRows = rows;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        super.add(this.getVerticalScrollBar());
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        Insets insets = this.getInsets();
        g.clipRect(insets.left, insets.top, this.getWidth(), this.getHeight() - insets.top - insets.bottom);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this.maximumVisibleRows < this.getComponentCount() - 1) {
            this.getVerticalScrollBar().setVisible(true);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        JScrollBar scrollBar = this.getVerticalScrollBar();
        if (scrollBar.isVisible()) {
            int extent = 0;
            int max = 0;
            int i = 0;
            int unit = -1;
            int width = 0;
            for (Component comp : this.getComponents()) {
                if (comp instanceof JScrollBar) continue;
                Dimension preferredSize = comp.getPreferredSize();
                width = Math.max(width, preferredSize.width);
                if (unit < 0) {
                    unit = preferredSize.height;
                }
                if (i++ < this.maximumVisibleRows) {
                    extent += preferredSize.height;
                }
                max += preferredSize.height;
            }
            Insets insets = this.getInsets();
            int widthMargin = insets.left + insets.right;
            int heightMargin = insets.top + insets.bottom;
            scrollBar.setUnitIncrement(unit);
            scrollBar.setBlockIncrement(extent);
            scrollBar.setValues(0, heightMargin + extent, 0, heightMargin + max);
            int height = heightMargin + extent;
            this.setPopupSize(new Dimension(width += scrollBar.getPreferredSize().width + widthMargin, height));
        }
        super.show(invoker, x, y);
    }

    protected static class ScrollPopupMenuLayout
    implements LayoutManager {
        private int location = 4;

        ScrollPopupMenuLayout() {
            this(4);
        }

        ScrollPopupMenuLayout(int location) {
            switch (location) {
                case 2: 
                case 4: {
                    this.location = location;
                    break;
                }
                default: {
                    location = 4;
                }
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int visibleAmount = Integer.MAX_VALUE;
            Dimension dim = new Dimension();
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                if (comp instanceof JScrollBar) {
                    JScrollBar scrollBar = (JScrollBar)comp;
                    visibleAmount = scrollBar.getVisibleAmount();
                    continue;
                }
                Dimension pref = comp.getPreferredSize();
                dim.width = Math.max(dim.width, pref.width);
                dim.height += pref.height;
            }
            Insets insets = parent.getInsets();
            dim.height = Math.min(dim.height + insets.top + insets.bottom, visibleAmount);
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int visibleAmount = Integer.MAX_VALUE;
            Dimension dim = new Dimension();
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                if (comp instanceof JScrollBar) {
                    JScrollBar scrollBar = (JScrollBar)comp;
                    visibleAmount = scrollBar.getVisibleAmount();
                    continue;
                }
                Dimension min = comp.getMinimumSize();
                dim.width = Math.max(dim.width, min.width);
                dim.height += min.height;
            }
            Insets insets = parent.getInsets();
            dim.height = Math.min(dim.height + insets.top + insets.bottom, visibleAmount);
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int width = parent.getWidth() - insets.left - insets.right;
            int height = parent.getHeight() - insets.top - insets.bottom;
            int x = insets.left;
            int y = insets.top;
            int position = 0;
            for (Component comp : parent.getComponents()) {
                if (!(comp instanceof JScrollBar) || !comp.isVisible()) continue;
                JScrollBar scrollBar = (JScrollBar)comp;
                Dimension dim = scrollBar.getPreferredSize();
                switch (this.location) {
                    case 4: {
                        scrollBar.setBounds(x + width - dim.width, y, dim.width, height);
                        break;
                    }
                    case 2: {
                        scrollBar.setBounds(x + width - dim.width, y, dim.width, height);
                    }
                }
                width -= dim.width;
                position = scrollBar.getValue();
            }
            y -= position;
            for (Component comp : parent.getComponents()) {
                if (comp instanceof JScrollBar || !comp.isVisible()) continue;
                Dimension pref = comp.getPreferredSize();
                comp.setBounds(x, y, width, pref.height);
                y += pref.height;
            }
        }
    }
}

