/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBModel;
import org.openmicroscopy.shoola.util.ui.colourpicker.TabbedPaneUI;

public class ColourPicker
extends JDialog {
    public static final int DEFAULT_WIDTH = 240;
    public static final int DEFAULT_HEIGHT = 310;
    public static final String ACCEPT_PROPERTY = "colour";
    public static final String CANCEL_PROPERTY = "cancelColourPicker";
    public static final String CLOSE = "closeColourPicker";
    private static final String TITLE = "Color Picker Window";
    private static final Color DEFAULT_COLOR = Color.red;
    private RGBModel model;
    private TabbedPaneUI tabbedPane;

    private void setWindowProperties() {
        this.setTitle(TITLE);
        this.setSize(240, 310);
        this.setModal(true);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
    }

    private void attachListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ColourPicker.this.cancel();
            }
        });
    }

    static void invalidColorValue() {
        IconManager icons = IconManager.getInstance();
        NotificationDialog dialog = new NotificationDialog("Invalid color component value", "The value must be in the interval [0, 255].", icons.getIcon(29));
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    void cancel() {
        this.setVisible(false);
        this.firePropertyChange(CANCEL_PROPERTY, (Object)false, (Object)true);
    }

    void accept() {
        ColourObject newColor = new ColourObject();
        ColourObject oldColor = new ColourObject();
        newColor.color = this.model.getColour();
        oldColor.color = this.model.getOriginalColor();
        newColor.lut = this.model.getLUT();
        oldColor.lut = this.model.getOriginalLUT();
        newColor.revInt = this.model.getReverseIntensity();
        oldColor.revInt = this.model.getOriginalReverseIntensity();
        newColor.description = this.tabbedPane.getDescription();
        this.firePropertyChange(ACCEPT_PROPERTY, oldColor, newColor);
        this.setVisible(false);
        this.firePropertyChange(CLOSE, false, true);
    }

    void preview() {
        ColourObject newColor = new ColourObject();
        ColourObject oldColor = new ColourObject();
        newColor.color = this.model.getColour();
        oldColor.color = this.model.getOriginalColor();
        newColor.lut = this.model.getLUT();
        oldColor.lut = this.model.getOriginalLUT();
        newColor.revInt = this.model.getReverseIntensity();
        oldColor.revInt = this.model.getOriginalReverseIntensity();
        newColor.description = this.tabbedPane.getDescription();
        newColor.preview = true;
        this.firePropertyChange(ACCEPT_PROPERTY, oldColor, newColor);
    }

    void reset() {
        ColourObject oldColor = new ColourObject();
        oldColor.color = this.model.getOriginalColor();
        oldColor.lut = this.model.getOriginalLUT();
        oldColor.revInt = this.model.getOriginalReverseIntensity();
        this.firePropertyChange(ACCEPT_PROPERTY, null, oldColor);
    }

    public void reinit(Color c, String desc, String lut, boolean revInt) {
        this.model.setColour(c, true);
        if (desc != null) {
            this.tabbedPane.setColorDescription(desc);
        }
        this.model.setLUT(lut, true);
        this.model.setReverseIntensity(revInt, true);
        this.tabbedPane.stateChanged(null);
    }

    public ColourPicker(JFrame owner, Color color, boolean field, Collection<String> luts, String selectedLUT, boolean revInt) {
        super(owner);
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        this.setWindowProperties();
        float[] vals = new float[4];
        vals = color.getComponents(vals);
        this.model = new RGBModel(vals[0], vals[1], vals[2], vals[3], selectedLUT, luts, revInt);
        RGBControl control = new RGBControl(this.model);
        this.tabbedPane = new TabbedPaneUI(this, control, field);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 80.0;
        gbc.weighty = 30.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.attachListeners();
        this.getContentPane().add((Component)this.tabbedPane, gbc);
        this.pack();
    }

    public ColourPicker(JFrame owner, Color color) {
        this(owner, color, false, null, null, false);
    }

    public ColourPicker(JFrame owner, Color color, boolean field) {
        this(owner, color, field, null, null, false);
    }

    public ColourPicker(JFrame owner, Color color, Collection<String> luts, String selectedLUT, boolean revInt) {
        this(owner, color, false, luts, selectedLUT, revInt);
    }

    public ColourPicker(JFrame owner) {
        this(owner, null, false, null, null, false);
    }

    public ColourPicker(JFrame owner, boolean field) {
        this(owner, null, field, null, null, false);
    }

    public void setColorDescription(String description) {
        this.tabbedPane.setColorDescription(description);
    }

    public void setPreviewVisible(boolean visible) {
        this.tabbedPane.setPreviewVisible(visible);
        this.tabbedPane.repaint();
        this.pack();
    }
}

