/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

public class ChemicalNameFormatter {
    StyledDocument doc;
    private boolean refresh;
    List<String> formulas = new ArrayList<String>();
    private SimpleAttributeSet plainText = new SimpleAttributeSet();
    private SimpleAttributeSet subscript;

    public ChemicalNameFormatter() {
        StyleConstants.setFontFamily(this.plainText, "SansSerif");
        StyleConstants.setFontSize(this.plainText, 14);
        this.subscript = new SimpleAttributeSet();
        StyleConstants.setSubscript(this.subscript, true);
        StyleConstants.setFontSize(this.subscript, 11);
    }

    public ChemicalNameFormatter(SimpleAttributeSet plainText) {
        this();
        this.plainText = plainText;
    }

    public void addFormula(String formula) {
        this.formulas.add(formula);
    }

    public void parseRegex(StyledDocument document, boolean refreshStyle) {
        this.doc = document;
        this.refresh = refreshStyle;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChemicalNameFormatter.this.refresh) {
                    ChemicalNameFormatter.this.doc.setCharacterAttributes(0, ChemicalNameFormatter.this.doc.getLength(), ChemicalNameFormatter.this.plainText, true);
                }
                try {
                    String text = ChemicalNameFormatter.this.doc.getText(0, ChemicalNameFormatter.this.doc.getLength());
                    ArrayList<Position> positionList = new ArrayList<Position>();
                    for (String formula : ChemicalNameFormatter.this.formulas) {
                        positionList.clear();
                        WikiView.findExpressions(text, formula, positionList);
                        for (Position p : positionList) {
                            int end = p.getEnd();
                            for (int start = p.getStart(); start < end; ++start) {
                                Character c = Character.valueOf(ChemicalNameFormatter.this.doc.getText(start, 1).charAt(0));
                                if (!Character.isDigit(c.charValue())) continue;
                                ChemicalNameFormatter.this.doc.setCharacterAttributes(start, 1, ChemicalNameFormatter.this.subscript, false);
                            }
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }
}

