/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SearchUtil {
    public static final String MINUS_SEPARATOR = "-";
    public static final String COMMA_SEPARATOR = ",";
    public static final String SPACE_SEPARATOR = " ";
    public static final String QUOTE_SEPARATOR = "\"";
    static final String ALL = "All";

    public static List<String> splitTerms(String text, String pattern) {
        ArrayList<String> l = new ArrayList<String>();
        if (text == null) {
            return l;
        }
        text = text.trim();
        String[] r = text.split(pattern);
        for (int i = 0; i < r.length; ++i) {
            String value = r[i];
            if (value == null || (value = value.trim()).length() == 0 || value.equals(ALL)) continue;
            l.add(value);
        }
        return l;
    }

    public static List<String> splitTerms(String text) {
        ArrayList<String> l = new ArrayList<String>();
        if (text == null) {
            return l;
        }
        text = text.trim();
        String pattern = SPACE_SEPARATOR;
        if (text.contains(QUOTE_SEPARATOR)) {
            pattern = QUOTE_SEPARATOR;
        }
        String[] r = text.split(pattern);
        for (int i = 0; i < r.length; ++i) {
            String value = r[i];
            if (value == null || (value = value.trim()).length() == 0 || value.equals(ALL) || value.equals(COMMA_SEPARATOR)) continue;
            if (value.contains(COMMA_SEPARATOR)) {
                value = value.replace(COMMA_SEPARATOR, "");
            }
            l.add(value);
        }
        return l;
    }

    public static String formatString(String termToAdd, List<String> terms) {
        String value;
        if (terms == null) {
            return termToAdd;
        }
        int n = terms.size();
        if (n == 0) {
            return termToAdd;
        }
        Object result = "";
        Iterator<String> i = terms.iterator();
        boolean exist = false;
        while (i.hasNext()) {
            value = i.next();
            if (value == null || !value.equals(termToAdd)) continue;
            exist = true;
        }
        StringBuffer buffer = new StringBuffer();
        if (exist) {
            i = terms.iterator();
            int index = 0;
            while (i.hasNext()) {
                value = i.next();
                buffer.append(value);
                if (index != n) {
                    buffer.append(", ");
                }
                ++index;
            }
            result = buffer.toString();
            return result;
        }
        i = terms.iterator();
        while (i.hasNext()) {
            buffer.append(i.next());
            buffer.append(", ");
        }
        result = (String)result + buffer.toString();
        result = (String)result + termToAdd;
        return result;
    }
}

