/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ome.services.messages.ParserOpenFileMessage;
import ome.system.OmeroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class FileParser
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(FileParser.class);
    protected OmeroContext context;
    protected long maxFileSize = 10000L;
    public static final Iterable<Reader> EMPTY = new Iterable<Reader>(){

        @Override
        public Iterator<Reader> iterator() {
            return new Iterator<Reader>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Reader next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.context = (OmeroContext)arg0;
    }

    public void setMaxFileSize(Long size) {
        if ((double)(size.floatValue() / (float)Runtime.getRuntime().maxMemory()) > 0.5) {
            log.warn("Indexer maximum file size is set to more than half of total heap size. Excessively large text files may cause search index corruption. Consider decreasing the maximum file size or increasing the Indexer heap size.");
        }
        this.maxFileSize = size;
    }

    public final Iterable<Reader> parse(File file) {
        if (file == null) {
            log.warn("Argument null. Returning EMPTY:");
            return EMPTY;
        }
        if (!file.exists() && !file.canRead()) {
            log.debug("empty|unreadable file: " + file.getAbsoluteFile());
            return EMPTY;
        }
        if (file.length() > this.maxFileSize) {
            log.info("File too large for indexing. Skipping: " + file.getAbsoluteFile());
            return EMPTY;
        }
        try {
            Iterable<Reader> it = this.doParse(file);
            if (it == null) {
                log.debug("Implementation returned null.");
                return EMPTY;
            }
            return it;
        }
        catch (Exception e) {
            log.warn("Implementation threw an exception.", (Throwable)e);
            return EMPTY;
        }
    }

    public Iterable<Reader> doParse(File file) throws Exception {
        FileReader reader = new FileReader(file);
        BufferedReader buffered = new BufferedReader(reader);
        this.context.publishEvent((ApplicationEvent)new ParserOpenFileMessage(this, buffered){

            @Override
            public void close() {
                try {
                    Reader r = (Reader)this.resource;
                    r.close();
                }
                catch (Exception e) {
                    log.debug("Error closing " + this.resource, (Throwable)e);
                }
            }
        });
        SingleIterator it = new SingleIterator(buffered);
        return this.wrap(it);
    }

    public Iterable<Reader> wrap(Iterator<Reader> it) {
        if (it == null) {
            return EMPTY;
        }
        return new IteratorWrapper(it);
    }

    public Iterable<Reader> wrap(Reader r) {
        if (r == null) {
            return EMPTY;
        }
        return this.wrap(new SingleIterator(r));
    }

    private static class OverlappingChunkFileIterator
    implements Iterator<String> {
        private static final String linesep = System.getProperty("line.separator");
        private static final int size = 10000;
        private final long fileSize;
        private final char[] buf;
        private String next;
        private BufferedReader reader;

        public OverlappingChunkFileIterator(File file) throws Exception {
            this.fileSize = file.length();
            if (this.fileSize > Integer.MAX_VALUE) {
                throw new RuntimeException(String.format("%s file is too large for current implementation: %s", file, this.fileSize));
            }
            this.reader = new BufferedReader(new FileReader(file), 10000);
            this.buf = new char[10000];
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.doRead();
            }
            return this.next != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String rv = this.next;
            this.next = null;
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String doRead() {
            if (this.reader == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer((int)this.fileSize);
            int rv = -1;
            try {
                while ((rv = this.reader.read(this.buf)) != -1) {
                    sb.append(this.buf, 0, rv);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error while parsing file", e);
            }
            this.closeReader();
            return sb.toString();
        }

        private void closeReader() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.reader = null;
                }
            }
        }
    }

    private static class IteratorWrapper
    implements Iterable<Reader> {
        private final Iterator<Reader> it;

        public IteratorWrapper(Iterator<Reader> it) {
            this.it = it;
        }

        @Override
        public Iterator<Reader> iterator() {
            return this.it;
        }
    }

    private static class SingleIterator
    implements Iterator<Reader> {
        Reader r;

        SingleIterator(Reader r) {
            this.r = r;
        }

        @Override
        public boolean hasNext() {
            return this.r != null;
        }

        @Override
        public Reader next() {
            Reader rv = this.r;
            this.r = null;
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

