/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.ExperimenterGroup;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import org.hibernate.Session;

public class PermissionsPredicate
implements GraphPolicyRulePredicate {
    private Map<Long, String> groupPermissions = new HashMap<Long, String>();

    @Override
    public String getName() {
        return "perms";
    }

    @Override
    public void noteDetails(Session session, IObject object, String realClass, long id) {
        Long groupId;
        if (!(object instanceof ExperimenterGroup)) {
            String hql = "SELECT details FROM " + realClass + " WHERE id = " + id;
            Details details = (Details)session.createQuery(hql).uniqueResult();
            if (details == null) {
                return;
            }
            object = details.getGroup();
            if (object == null) {
                return;
            }
        }
        if (!this.groupPermissions.containsKey(groupId = object.getId())) {
            ExperimenterGroup group = (ExperimenterGroup)session.get(ExperimenterGroup.class, (Serializable)groupId);
            Permissions permissions = group.getDetails().getPermissions();
            this.groupPermissions.put(groupId, permissions.toString());
        }
    }

    @Override
    public boolean isMatch(GraphPolicy.Details object, String parameter) throws GraphException {
        if (object.groupId == null) {
            return false;
        }
        String permissions = this.groupPermissions.get(object.groupId);
        if (permissions == null) {
            throw new GraphException("no group permissions for " + object);
        }
        if (parameter.length() != permissions.length()) {
            throw new GraphException("parameter " + parameter + " has different length from permissions " + permissions + " on " + object);
        }
        int index = permissions.length();
        while (--index >= 0) {
            char parameterChar = parameter.charAt(index);
            if (parameterChar == '?' || parameterChar == permissions.charAt(index)) continue;
            return false;
        }
        return true;
    }
}

